/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.creator.name;

import com.google.common.base.Preconditions;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.creator.name.SegmentNameGenerator;
import org.apache.pinot.segment.spi.creator.name.SegmentNameUtils;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DateTimeFormatPatternSpec;
import org.apache.pinot.spi.data.DateTimeFormatSpec;
import org.joda.time.DateTime;

public class NormalizedDateSegmentNameGenerator
implements SegmentNameGenerator {
    private static final String PUSH_FREQUENCY_HOURLY = "hourly";
    private final String _segmentNamePrefix;
    private final boolean _excludeSequenceId;
    private final boolean _appendPushType;
    private final String _segmentNamePostfix;
    private final boolean _appendUUIDToSegmentName;
    private final DateTimeFormatPatternSpec _outputSDF;
    private final TimeUnit _inputTimeUnit;
    private final DateTimeFormatPatternSpec _inputSDF;

    public NormalizedDateSegmentNameGenerator(String tableName, @Nullable String segmentNamePrefix, boolean excludeSequenceId, @Nullable String pushType, @Nullable String pushFrequency, @Nullable DateTimeFormatSpec dateTimeFormatSpec, @Nullable String segmentNamePostfix) {
        this(tableName, segmentNamePrefix, excludeSequenceId, pushType, pushFrequency, dateTimeFormatSpec, segmentNamePostfix, false);
    }

    public NormalizedDateSegmentNameGenerator(String tableName, @Nullable String segmentNamePrefix, boolean excludeSequenceId, @Nullable String pushType, @Nullable String pushFrequency, @Nullable DateTimeFormatSpec dateTimeFormatSpec, @Nullable String segmentNamePostfix, boolean appendUUIDToSegmentName) {
        this._segmentNamePrefix = segmentNamePrefix != null ? segmentNamePrefix.trim() : tableName;
        Preconditions.checkArgument((this._segmentNamePrefix != null ? 1 : 0) != 0, (Object)"Missing segmentNamePrefix for NormalizedDateSegmentNameGenerator");
        SegmentNameUtils.validatePartialOrFullSegmentName(this._segmentNamePrefix);
        this._excludeSequenceId = excludeSequenceId;
        this._appendPushType = "APPEND".equalsIgnoreCase(pushType);
        this._segmentNamePostfix = segmentNamePostfix != null ? segmentNamePostfix.trim() : null;
        this._appendUUIDToSegmentName = appendUUIDToSegmentName;
        if (this._segmentNamePostfix != null) {
            SegmentNameUtils.validatePartialOrFullSegmentName(this._segmentNamePostfix);
        }
        if (this._appendPushType) {
            String sdfPattern = PUSH_FREQUENCY_HOURLY.equalsIgnoreCase(pushFrequency) ? "yyyy-MM-dd-HH" : "yyyy-MM-dd";
            this._outputSDF = new DateTimeFormatPatternSpec(DateTimeFieldSpec.TimeFormat.SIMPLE_DATE_FORMAT, sdfPattern, "UTC");
            Preconditions.checkArgument((dateTimeFormatSpec != null ? 1 : 0) != 0, (Object)"Must provide date time format spec for NormalizedDateSegmentNameGenerator. Common problems: missing timeColumnName in table config, missing schema for timeColumnName, timeColumnName is not a date time field, or missing format spec in timeColumnName schema");
            DateTimeFieldSpec.TimeFormat timeFormat = dateTimeFormatSpec.getTimeFormat();
            if (timeFormat == DateTimeFieldSpec.TimeFormat.EPOCH || timeFormat == DateTimeFieldSpec.TimeFormat.TIMESTAMP) {
                this._inputTimeUnit = dateTimeFormatSpec.getColumnUnit();
                this._inputSDF = null;
            } else {
                Preconditions.checkArgument((dateTimeFormatSpec.getSDFPattern() != null ? 1 : 0) != 0, (Object)"Must provide pattern for SIMPLE_DATE_FORMAT for NormalizedDateSegmentNameGenerator. Common problem: the format spec in timeColumnName schema is SIMPLE_DATE_FORMAT but pattern is missing");
                this._inputTimeUnit = null;
                this._inputSDF = dateTimeFormatSpec.getDateTimeFormatPattenSpec();
            }
        } else {
            this._outputSDF = null;
            this._inputTimeUnit = null;
            this._inputSDF = null;
        }
    }

    @Override
    public String generateSegmentName(int sequenceId, @Nullable Object minTimeValue, @Nullable Object maxTimeValue) {
        Integer sequenceIdInSegmentName;
        Integer n = sequenceIdInSegmentName = !this._excludeSequenceId && sequenceId >= 0 ? Integer.valueOf(sequenceId) : null;
        if (this._appendPushType) {
            Preconditions.checkArgument((minTimeValue != null ? 1 : 0) != 0, (Object)"Missing minTimeValue for NormalizedDateSegmentNameGenerator");
            Preconditions.checkArgument((maxTimeValue != null ? 1 : 0) != 0, (Object)"Missing maxTimeValue for NormalizedDateSegmentNameGenerator");
            return JOINER.join((Object)this._segmentNamePrefix, (Object)this.getNormalizedDate(minTimeValue), new Object[]{this.getNormalizedDate(maxTimeValue), this._segmentNamePostfix, sequenceIdInSegmentName, this._appendUUIDToSegmentName ? UUID.randomUUID() : null});
        }
        return JOINER.join((Object)this._segmentNamePrefix, (Object)this._segmentNamePostfix, new Object[]{sequenceIdInSegmentName, this._appendUUIDToSegmentName ? UUID.randomUUID() : null});
    }

    public String getNormalizedDate(Object timeValue) {
        if (this._inputTimeUnit != null) {
            return new DateTime(this._inputTimeUnit.toMillis(Long.parseLong(timeValue.toString()))).toString(this._outputSDF.getDateTimeFormatter());
        }
        try {
            return this._inputSDF.getDateTimeFormatter().parseDateTime(timeValue.toString()).toString(this._outputSDF.getDateTimeFormatter());
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Caught exception while parsing simple date format: %s with value: %s", this._inputSDF.getSdfPattern(), timeValue), e);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("NormalizedDateSegmentNameGenerator: segmentNamePrefix=").append(this._segmentNamePrefix);
        if (this._segmentNamePostfix != null) {
            stringBuilder.append(", segmentNamePostfix=").append(this._segmentNamePostfix);
        }
        stringBuilder.append(", appendPushType=").append(this._appendPushType);
        if (this._excludeSequenceId) {
            stringBuilder.append(", excludeSequenceId=true");
        }
        if (this._outputSDF != null) {
            stringBuilder.append(", outputSDF=").append(this._outputSDF.getSdfPattern());
        }
        if (this._inputTimeUnit != null) {
            stringBuilder.append(", inputTimeUnit=").append((Object)this._inputTimeUnit);
        }
        if (this._inputSDF != null) {
            stringBuilder.append(", inputSDF=").append(this._inputSDF.getSdfPattern());
        }
        return stringBuilder.toString();
    }
}

