/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index.creator;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.index.IndexCreator;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.MapUtils;

public interface ForwardIndexCreator
extends IndexCreator {
    @Override
    default public void seal() throws IOException {
    }

    @Override
    default public void add(@Nonnull Object cellValue, int dictId) {
        if (dictId >= 0) {
            this.putDictId(dictId);
        } else {
            switch (this.getValueType()) {
                case INT: {
                    this.putInt((Integer)cellValue);
                    break;
                }
                case LONG: {
                    this.putLong((Long)cellValue);
                    break;
                }
                case FLOAT: {
                    this.putFloat(((Float)cellValue).floatValue());
                    break;
                }
                case DOUBLE: {
                    this.putDouble((Double)cellValue);
                    break;
                }
                case BIG_DECIMAL: {
                    this.putBigDecimal((BigDecimal)cellValue);
                    break;
                }
                case STRING: {
                    this.putString((String)cellValue);
                    break;
                }
                case BYTES: {
                    this.putBytes((byte[])cellValue);
                    break;
                }
                case JSON: 
                case MAP: {
                    if (cellValue instanceof String) {
                        this.putString((String)cellValue);
                        break;
                    }
                    if (cellValue instanceof byte[]) {
                        this.putBytes((byte[])cellValue);
                        break;
                    }
                    if (cellValue instanceof Map) {
                        this.putBytes(MapUtils.serializeMap((Map)((Map)cellValue)));
                        break;
                    }
                    throw new IllegalStateException("Unsupported value type: " + this.getValueType() + ", cellValue type is: " + cellValue.getClass());
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    @Override
    default public void add(@Nonnull Object[] cellValues, @Nullable int[] dictIds) throws IOException {
        if (dictIds != null) {
            this.putDictIdMV(dictIds);
        } else {
            int length = cellValues.length;
            switch (this.getValueType()) {
                case INT: {
                    int[] ints = new int[length];
                    for (int i = 0; i < length; ++i) {
                        ints[i] = (Integer)cellValues[i];
                    }
                    this.putIntMV(ints);
                    break;
                }
                case LONG: {
                    long[] longs = new long[length];
                    for (int i = 0; i < length; ++i) {
                        longs[i] = (Long)cellValues[i];
                    }
                    this.putLongMV(longs);
                    break;
                }
                case FLOAT: {
                    float[] floats = new float[length];
                    for (int i = 0; i < length; ++i) {
                        floats[i] = ((Float)cellValues[i]).floatValue();
                    }
                    this.putFloatMV(floats);
                    break;
                }
                case DOUBLE: {
                    double[] doubles = new double[length];
                    for (int i = 0; i < length; ++i) {
                        doubles[i] = (Double)cellValues[i];
                    }
                    this.putDoubleMV(doubles);
                    break;
                }
                case STRING: {
                    if (cellValues instanceof String[]) {
                        this.putStringMV((String[])cellValues);
                        break;
                    }
                    String[] strings = new String[length];
                    for (int i = 0; i < length; ++i) {
                        strings[i] = (String)cellValues[i];
                    }
                    this.putStringMV(strings);
                    break;
                }
                case BYTES: {
                    if (cellValues instanceof byte[][]) {
                        this.putBytesMV((byte[][])cellValues);
                        break;
                    }
                    byte[][] bytesArray = new byte[length][];
                    for (int i = 0; i < length; ++i) {
                        bytesArray[i] = (byte[])cellValues[i];
                    }
                    this.putBytesMV(bytesArray);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public boolean isDictionaryEncoded();

    public boolean isSingleValue();

    public FieldSpec.DataType getValueType();

    default public void putDictId(int dictId) {
        throw new UnsupportedOperationException();
    }

    default public void putDictIdMV(int[] dictIds) {
        throw new UnsupportedOperationException();
    }

    default public void putInt(int value) {
        throw new UnsupportedOperationException();
    }

    default public void putLong(long value) {
        throw new UnsupportedOperationException();
    }

    default public void putFloat(float value) {
        throw new UnsupportedOperationException();
    }

    default public void putDouble(double value) {
        throw new UnsupportedOperationException();
    }

    default public void putBigDecimal(BigDecimal value) {
        throw new UnsupportedOperationException();
    }

    default public void putString(String value) {
        throw new UnsupportedOperationException();
    }

    default public void putBytes(byte[] value) {
        throw new UnsupportedOperationException();
    }

    default public void putIntMV(int[] values) {
        throw new UnsupportedOperationException();
    }

    default public void putLongMV(long[] values) {
        throw new UnsupportedOperationException();
    }

    default public void putFloatMV(float[] values) {
        throw new UnsupportedOperationException();
    }

    default public void putDoubleMV(double[] values) {
        throw new UnsupportedOperationException();
    }

    default public void putStringMV(String[] values) {
        throw new UnsupportedOperationException();
    }

    default public void putBytesMV(byte[][] values) {
        throw new UnsupportedOperationException();
    }
}

