/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index.startree;

import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.pinot.segment.spi.index.ForwardIndexConfig;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.config.table.StarTreeAggregationConfig;

public class AggregationSpec {
    public static final FieldConfig.CompressionCodec DEFAULT_COMPRESSION_CODEC = FieldConfig.CompressionCodec.PASS_THROUGH;
    public static final AggregationSpec DEFAULT = new AggregationSpec(null, null, null, null, null, Map.of());
    private final FieldConfig.CompressionCodec _compressionCodec;
    private final boolean _deriveNumDocsPerChunk;
    private final int _indexVersion;
    private final int _targetMaxChunkSizeBytes;
    private final int _targetDocsPerChunk;
    private final Map<String, Object> _functionParameters;

    public AggregationSpec(StarTreeAggregationConfig aggregationConfig) {
        this(aggregationConfig.getCompressionCodec(), aggregationConfig.getDeriveNumDocsPerChunk(), aggregationConfig.getIndexVersion(), aggregationConfig.getTargetMaxChunkSizeBytes(), aggregationConfig.getTargetDocsPerChunk(), aggregationConfig.getFunctionParameters());
    }

    public AggregationSpec(@Nullable FieldConfig.CompressionCodec compressionCodec, @Nullable Boolean deriveNumDocsPerChunk, @Nullable Integer indexVersion, @Nullable Integer targetMaxChunkSizeBytes, @Nullable Integer targetDocsPerChunk, @Nullable Map<String, Object> functionParameters) {
        this._indexVersion = indexVersion != null ? indexVersion : ForwardIndexConfig.getDefaultRawWriterVersion();
        this._compressionCodec = compressionCodec != null ? compressionCodec : DEFAULT_COMPRESSION_CODEC;
        this._deriveNumDocsPerChunk = deriveNumDocsPerChunk != null ? deriveNumDocsPerChunk : false;
        this._targetMaxChunkSizeBytes = targetMaxChunkSizeBytes != null ? targetMaxChunkSizeBytes : ForwardIndexConfig.getDefaultTargetMaxChunkSizeBytes();
        this._targetDocsPerChunk = targetDocsPerChunk != null ? targetDocsPerChunk : ForwardIndexConfig.getDefaultTargetDocsPerChunk();
        this._functionParameters = functionParameters == null ? Map.of() : functionParameters;
    }

    public FieldConfig.CompressionCodec getCompressionCodec() {
        return this._compressionCodec;
    }

    public boolean isDeriveNumDocsPerChunk() {
        return this._deriveNumDocsPerChunk;
    }

    public int getIndexVersion() {
        return this._indexVersion;
    }

    public int getTargetMaxChunkSizeBytes() {
        return this._targetMaxChunkSizeBytes;
    }

    public int getTargetDocsPerChunk() {
        return this._targetDocsPerChunk;
    }

    public Map<String, Object> getFunctionParameters() {
        return this._functionParameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AggregationSpec)) {
            return false;
        }
        AggregationSpec that = (AggregationSpec)o;
        return this._deriveNumDocsPerChunk == that._deriveNumDocsPerChunk && this._indexVersion == that._indexVersion && this._targetMaxChunkSizeBytes == that._targetMaxChunkSizeBytes && this._targetDocsPerChunk == that._targetDocsPerChunk && this._compressionCodec == that._compressionCodec && Objects.equals(this._functionParameters, that._functionParameters);
    }

    public int hashCode() {
        return Objects.hash(this._compressionCodec, this._deriveNumDocsPerChunk, this._indexVersion, this._targetMaxChunkSizeBytes, this._targetDocsPerChunk, this._functionParameters);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("compressionCodec", (Object)this._compressionCodec).append("deriveNumDocsPerChunk", this._deriveNumDocsPerChunk).append("indexVersion", this._indexVersion).append("targetMaxChunkSizeBytes", this._targetMaxChunkSizeBytes).append("targetDocsPerChunk", this._targetDocsPerChunk).append("functionParameters", this._functionParameters).toString();
    }
}

