/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.memory.unsafe;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import jnr.ffi.LibraryLoader;
import jnr.ffi.types.size_t;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.posix.MSyncFlag;
import net.openhft.posix.PosixAPI;
import org.apache.pinot.segment.spi.memory.unsafe.Memory;
import org.apache.pinot.segment.spi.memory.unsafe.MmapMemoryConfig;
import org.apache.pinot.segment.spi.memory.unsafe.Unsafer;
import org.apache.pinot.segment.spi.utils.JavaVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MmapMemory
implements Memory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MmapMemory.class);
    private static final MapFun MAP_FUN;
    private final long _address;
    private final long _size;
    private final MapSection _section;
    private boolean _closed = false;

    public MmapMemory(File file, boolean readOnly, long offset, long size) {
        this._size = size;
        try {
            this._section = MAP_FUN.map(file, readOnly, offset, size);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this._address = this._section.getAddress();
    }

    @Override
    public long getAddress() {
        return this._address;
    }

    @Override
    public long getSize() {
        return this._size;
    }

    @Override
    public void flush() {
        MSyncFlag mode = MSyncFlag.MS_SYNC;
        PosixAPI.posix().msync(this._address, this._size, mode);
    }

    @Override
    public synchronized void close() {
        try {
            if (!this._closed) {
                this._section._unmapFun.unmap();
                this._closed = true;
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Error while calling unmap", e);
        }
    }

    protected void finalize() throws Throwable {
        if (!this._closed) {
            LOGGER.warn("Mmap section of size: {} wasn't explicitly closed", (Object)this._size);
            this.close();
        }
        super.finalize();
    }

    static {
        try {
            Jvm.init();
            MAP_FUN = MapFun.find();
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    protected static interface LibC {
        public static final int POSIX_MADV_NORMAL = 0;
        public static final int POSIX_MADV_RANDOM = 1;
        public static final int POSIX_MADV_SEQUENTIAL = 2;
        public static final int POSIX_MADV_WILLNEED = 3;
        public static final int POSIX_MADV_DONTNEED = 4;

        public int posix_madvise(@size_t long var1, @size_t long var3, int var5);
    }

    private static interface Finder<C> {
        public C tryFind() throws NoSuchMethodException, ClassNotFoundException;
    }

    static interface UnmapFun {
        public void unmap() throws InvocationTargetException, IllegalAccessException;
    }

    static interface Map0Fun
    extends MapFun {
        public MapSection map0(FileChannel var1, boolean var2, long var3, long var5) throws InvocationTargetException, IllegalAccessException, IOException;

        /*
         * Enabled aggressive exception aggregation
         */
        @Override
        default public MapSection map(File file, boolean readOnly, long offset, long size) throws IOException {
            String mode = readOnly ? "r" : "rw";
            try (RandomAccessFile raf = new RandomAccessFile(file, mode);){
                MapSection mapSection;
                block19: {
                    FileChannel fc;
                    block17: {
                        MapSection mapSection2;
                        block18: {
                            fc = raf.getChannel();
                            try {
                                if (size != 0L) break block17;
                                mapSection2 = MapSection.EMPTY;
                                if (fc == null) break block18;
                            }
                            catch (Throwable throwable) {
                                if (fc != null) {
                                    try {
                                        fc.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            fc.close();
                        }
                        return mapSection2;
                    }
                    long allocationGranule = Unsafer.UNSAFE.pageSize();
                    int pagePosition = (int)(offset % allocationGranule);
                    if (!fc.isOpen()) {
                        throw new IOException("closed " + file.getPath());
                    }
                    long fileSize = fc.size();
                    if (fileSize < offset + size) {
                        raf.seek(offset + size - 1L);
                        raf.write(0);
                    }
                    long mapPosition = offset - (long)pagePosition;
                    long mapSize = size + (long)pagePosition;
                    MapSection map0Section = this.map0(fc, readOnly, mapPosition, mapSize);
                    map0Section.madvise(mapSize);
                    mapSection = new MapSection(map0Section.getAddress() + (long)pagePosition, map0Section.getUnmapFun());
                    if (fc == null) break block19;
                    fc.close();
                }
                return mapSection;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Cannot map file " + file + " from address " + offset + " with size " + size, e);
            }
        }

        public static BiConsumer<Long, Long> tryFindUnmapper() throws NoSuchMethodException, ClassNotFoundException {
            Class<?> fileChannelImpl = MmapMemory.class.getClassLoader().loadClass("sun.nio.ch.FileChannelImpl");
            Method unmapMethod = fileChannelImpl.getDeclaredMethod("unmap0", Long.TYPE, Long.TYPE);
            unmapMethod.setAccessible(true);
            return (address, size) -> {
                try {
                    unmapMethod.invoke(null, address, size);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            };
        }

        public static class Java20
        implements Finder<Map0Fun> {
            @Override
            public Map0Fun tryFind() throws NoSuchMethodException, ClassNotFoundException {
                Class<?> fileChannelImpl = MmapMemory.class.getClassLoader().loadClass("sun.nio.ch.FileChannelImpl");
                Method mapMethod = fileChannelImpl.getDeclaredMethod("mapInternal", FileChannel.MapMode.class, Long.TYPE, Long.TYPE, Integer.TYPE, Boolean.TYPE);
                mapMethod.setAccessible(true);
                Class<?> unmapperClass = MmapMemory.class.getClassLoader().loadClass("sun.nio.ch.FileChannelImpl$Unmapper");
                Method unmapMethod = unmapperClass.getDeclaredMethod("unmap", new Class[0]);
                unmapMethod.setAccessible(true);
                Method addressMethod = unmapperClass.getDeclaredMethod("address", new Class[0]);
                addressMethod.setAccessible(true);
                return (fc, readOnly, pageAlignedOffset, size) -> {
                    UnmapFun unmapFun;
                    long address;
                    FileChannel.MapMode mapMode = readOnly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
                    int prot = readOnly ? 0 : 1;
                    Object unmapper = mapMethod.invoke((Object)fc, mapMode, pageAlignedOffset, size, prot, false);
                    if (unmapper == null) {
                        address = 0L;
                        unmapFun = () -> {};
                    } else {
                        address = (Long)addressMethod.invoke(unmapper, new Object[0]);
                        unmapFun = () -> unmapMethod.invoke(unmapper, new Object[0]);
                    }
                    return new MapSection(address, unmapFun);
                };
            }
        }

        public static class Java17
        implements Finder<Map0Fun> {
            @Override
            public Map0Fun tryFind() throws NoSuchMethodException, ClassNotFoundException {
                Class<?> fileChannelImpl = MmapMemory.class.getClassLoader().loadClass("sun.nio.ch.FileChannelImpl");
                Method mapMethod = fileChannelImpl.getDeclaredMethod("map0", Integer.TYPE, Long.TYPE, Long.TYPE, Boolean.TYPE);
                mapMethod.setAccessible(true);
                BiConsumer<Long, Long> unmap0 = Map0Fun.tryFindUnmapper();
                return (fc, readOnly, pageAlignedOffset, size) -> {
                    int iMode = readOnly ? 0 : 1;
                    long address = (Long)mapMethod.invoke((Object)fc, iMode, pageAlignedOffset, size, false);
                    UnmapFun unmapFun = () -> unmap0.accept(address, size);
                    return new MapSection(address, unmapFun);
                };
            }
        }

        public static class Java11
        implements Finder<Map0Fun> {
            @Override
            public Map0Fun tryFind() throws NoSuchMethodException, ClassNotFoundException {
                Class<?> fileChannelImpl = MmapMemory.class.getClassLoader().loadClass("sun.nio.ch.FileChannelImpl");
                Method mapMethod = fileChannelImpl.getDeclaredMethod("map0", Integer.TYPE, Long.TYPE, Long.TYPE);
                mapMethod.setAccessible(true);
                BiConsumer<Long, Long> unmap0 = Map0Fun.tryFindUnmapper();
                return (fc, readOnly, pageAlignedOffset, size) -> {
                    int iMode = readOnly ? 0 : 1;
                    long address = (Long)mapMethod.invoke((Object)fc, iMode, pageAlignedOffset, size);
                    UnmapFun unmapFun = () -> unmap0.accept(address, size);
                    return new MapSection(address, unmapFun);
                };
            }
        }

        public static class ChronicleCore
        implements Finder<Map0Fun> {
            @Override
            public Map0Fun tryFind() {
                OS.mapAlignment();
                return (fc, readOnly, pageAlignedOffset, size) -> {
                    if (size == 0L) {
                        return MapSection.EMPTY;
                    }
                    FileChannel.MapMode mapMode = readOnly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
                    long alignedSize = OS.pageAlign((long)size);
                    long address = OS.map((FileChannel)fc, (FileChannel.MapMode)mapMode, (long)pageAlignedOffset, (long)alignedSize);
                    return new MapSection(address, () -> {
                        try {
                            OS.unmap((long)address, (long)alignedSize);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    });
                };
            }
        }
    }

    static interface MapFun {
        public MapSection map(File var1, boolean var2, long var3, long var5) throws IOException;

        public static MapFun find() throws ClassNotFoundException, NoSuchMethodException {
            ArrayList candidates = Lists.newArrayList((Object[])new Finder[]{new Map0Fun.ChronicleCore(), new Map0Fun.Java11(), new Map0Fun.Java17(), new Map0Fun.Java20()});
            for (Finder candidate : candidates) {
                try {
                    return (MapFun)candidate.tryFind();
                }
                catch (AssertionError | ClassNotFoundException | NoSuchMethodException object) {
                }
            }
            throw new NoSuchMethodException("Cannot find how to create memory map files in Java " + JavaVersion.VERSION);
        }
    }

    private static class MapSection {
        public static final MapSection EMPTY = new MapSection(0L, () -> {});
        private final long _address;
        private final UnmapFun _unmapFun;
        private static final LibC LIB_C;

        public MapSection(long address, UnmapFun unmapFun) {
            this._address = address;
            this._unmapFun = unmapFun;
        }

        public long getAddress() {
            return this._address;
        }

        public UnmapFun getUnmapFun() {
            return this._unmapFun;
        }

        protected void madvise(long size, int advice) {
            if (LIB_C != null) {
                int errno = LIB_C.posix_madvise(this._address, size, advice);
                switch (errno) {
                    case 0: {
                        break;
                    }
                    case 22: {
                        LOGGER.warn("posix_madvise failed with EINVAL, either addr is not aligned or advice was invalid");
                        break;
                    }
                    case 12: {
                        LOGGER.warn("posix_madvise failed with ENOMEM, indicating a bad address or size");
                        break;
                    }
                    default: {
                        LOGGER.warn("posix_madvise returned an unknown error code: {}", (Object)errno);
                    }
                }
            }
        }

        protected void madvise(long size) {
            int defaultAdvice = MmapMemoryConfig.getDefaultAdvice();
            if (defaultAdvice >= 0) {
                this.madvise(size, defaultAdvice);
            }
        }

        static {
            LibC libC = null;
            try {
                libC = (LibC)LibraryLoader.create(LibC.class).failImmediately().load("c");
            }
            catch (Throwable ignored) {
                LOGGER.warn("Could not load JNR C Library, madvise will not be used for mmap memory.");
            }
            LIB_C = libC;
        }
    }
}

