/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.memory.unsafe;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.EnumUtils;

public class MmapMemoryConfig {
    private static final MmapMemoryConfig INSTANCE = new MmapMemoryConfig();
    private int _defaultAdvice = -1;

    private MmapMemoryConfig() {
    }

    public static int getDefaultAdvice() {
        return MmapMemoryConfig.INSTANCE._defaultAdvice;
    }

    public static void setDefaultAdvice(int advice) {
        Preconditions.checkArgument((advice >= 0 && advice <= 4 ? 1 : 0) != 0, (String)"Default advice for mmap buffers must be posix_madvise compatible (0-4): %d", (int)advice);
        MmapMemoryConfig.INSTANCE._defaultAdvice = advice;
    }

    public static void setDefaultAdvice(String adviceString) {
        Preconditions.checkArgument((boolean)EnumUtils.isValidEnum(Advice.class, (String)adviceString), (String)"Default advice for mmap buffers must match a posix_madvise compatible option: %s", (Object)adviceString);
        MmapMemoryConfig.setDefaultAdvice(Advice.valueOf(adviceString).getAdvice());
    }

    static enum Advice {
        NORMAL(0),
        RANDOM(1),
        SEQUENTIAL(2),
        WILL_NEED(3),
        DONT_NEED(4);

        private final int _advice;

        private Advice(int advice) {
            this._advice = advice;
        }

        public int getAdvice() {
            return this._advice;
        }
    }
}

