/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.partition;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.segment.spi.partition.PartitionFunction;

public class Murmur3PartitionFunction
implements PartitionFunction {
    public static final byte INVALID_CHAR = 63;
    private static final String NAME = "Murmur3";
    private static final String SEED_KEY = "seed";
    private static final String VARIANT_KEY = "variant";
    private final int _numPartitions;
    private final int _seed;
    private final boolean _useX64;

    public Murmur3PartitionFunction(int numPartitions, Map<String, String> functionConfig) {
        Preconditions.checkArgument((numPartitions > 0 ? 1 : 0) != 0, (Object)"Number of partitions must be > 0");
        this._numPartitions = numPartitions;
        int seed = 0;
        boolean useX64 = false;
        if (functionConfig != null) {
            String variantString;
            String seedString = functionConfig.get(SEED_KEY);
            if (StringUtils.isNotEmpty((CharSequence)seedString)) {
                seed = Integer.parseInt(seedString);
            }
            if (StringUtils.isNotEmpty((CharSequence)(variantString = functionConfig.get(VARIANT_KEY)))) {
                if (variantString.equals("x64_32")) {
                    useX64 = true;
                } else {
                    Preconditions.checkArgument((boolean)variantString.equals("x86_32"), (Object)"Murmur3 variant must be either x86_32 or x64_32");
                }
            }
        }
        this._seed = seed;
        this._useX64 = useX64;
    }

    @Override
    public int getPartition(String value) {
        int hash = this._useX64 ? Murmur3PartitionFunction.murmur3Hash32BitsX64(value, this._seed) : Murmur3PartitionFunction.murmur3Hash32BitsX86(value.getBytes(StandardCharsets.UTF_8), this._seed);
        return (hash & Integer.MAX_VALUE) % this._numPartitions;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getNumPartitions() {
        return this._numPartitions;
    }

    public String toString() {
        return NAME;
    }

    @VisibleForTesting
    static int murmur3Hash32BitsX86(byte[] data, int seed) {
        return Hashing.murmur3_32_fixed((int)seed).hashBytes(data).asInt();
    }

    private static void bmix(State state) {
        state._k1 *= state._c1;
        state._k1 = state._k1 << 23 | state._k1 >>> 41;
        state._k1 *= state._c2;
        state._h1 ^= state._k1;
        state._h1 += state._h2;
        state._h2 = state._h2 << 41 | state._h2 >>> 23;
        state._k2 *= state._c2;
        state._k2 = state._k2 << 23 | state._k2 >>> 41;
        state._k2 *= state._c1;
        state._h2 ^= state._k2;
        state._h2 += state._h1;
        state._h1 = state._h1 * 3L + 1390208809L;
        state._h2 = state._h2 * 3L + 944331445L;
        state._c1 = state._c1 * 5L + 2071795100L;
        state._c2 = state._c2 * 5L + 1808688022L;
    }

    private static long fmix(long k) {
        k ^= k >>> 33;
        k *= -49064778989728563L;
        k ^= k >>> 33;
        k *= -4265267296055464877L;
        k ^= k >>> 33;
        return k;
    }

    @VisibleForTesting
    static int murmur3Hash32BitsX64(String s, int seed) {
        State state = new State();
        state._h1 = 0x9368E53C2F6AF274L ^ (long)seed;
        state._h2 = 0x586DCD208F7CD3FDL ^ (long)seed;
        state._c1 = -8663945395140668459L;
        state._c2 = 5545529020109919103L;
        int byteLen = 0;
        int stringLen = s.length();
        for (int i = 0; i < stringLen; ++i) {
            byte b3;
            byte b2;
            byte b1;
            int cp;
            int c1 = s.charAt(i);
            if (!Character.isSurrogate((char)c1)) {
                cp = c1;
            } else if (Character.isHighSurrogate((char)c1)) {
                if (i + 1 < stringLen) {
                    char c2 = s.charAt(i + 1);
                    if (Character.isLowSurrogate(c2)) {
                        ++i;
                        cp = Character.toCodePoint((char)c1, c2);
                    } else {
                        cp = 63;
                    }
                } else {
                    cp = 63;
                }
            } else {
                cp = 63;
            }
            if (cp <= 127) {
                Murmur3PartitionFunction.addByte(state, (byte)cp, byteLen++);
                continue;
            }
            if (cp <= 2047) {
                b1 = (byte)(0xC0 | 0x1F & cp >> 6);
                b2 = (byte)(0x80 | 0x3F & cp);
                Murmur3PartitionFunction.addByte(state, b1, byteLen++);
                Murmur3PartitionFunction.addByte(state, b2, byteLen++);
                continue;
            }
            if (cp <= 65535) {
                b1 = (byte)(0xE0 | 0xF & cp >> 12);
                b2 = (byte)(0x80 | 0x3F & cp >> 6);
                b3 = (byte)(0x80 | 0x3F & cp);
                Murmur3PartitionFunction.addByte(state, b1, byteLen++);
                Murmur3PartitionFunction.addByte(state, b2, byteLen++);
                Murmur3PartitionFunction.addByte(state, b3, byteLen++);
                continue;
            }
            b1 = (byte)(0xF0 | 7 & cp >> 18);
            b2 = (byte)(0x80 | 0x3F & cp >> 12);
            b3 = (byte)(0x80 | 0x3F & cp >> 6);
            byte b4 = (byte)(0x80 | 0x3F & cp);
            Murmur3PartitionFunction.addByte(state, b1, byteLen++);
            Murmur3PartitionFunction.addByte(state, b2, byteLen++);
            Murmur3PartitionFunction.addByte(state, b3, byteLen++);
            Murmur3PartitionFunction.addByte(state, b4, byteLen++);
        }
        long savedK1 = state._k1;
        long savedK2 = state._k2;
        state._k1 = 0L;
        state._k2 = 0L;
        switch (byteLen & 0xF) {
            case 15: {
                state._k2 ^= (long)((byte)(savedK2 >> 48)) << 48;
            }
            case 14: {
                state._k2 ^= (long)((byte)(savedK2 >> 40)) << 40;
            }
            case 13: {
                state._k2 ^= (long)((byte)(savedK2 >> 32)) << 32;
            }
            case 12: {
                state._k2 ^= (long)((byte)(savedK2 >> 24)) << 24;
            }
            case 11: {
                state._k2 ^= (long)((byte)(savedK2 >> 16)) << 16;
            }
            case 10: {
                state._k2 ^= (long)((byte)(savedK2 >> 8)) << 8;
            }
            case 9: {
                state._k2 ^= (long)((byte)savedK2);
            }
            case 8: {
                state._k1 ^= (long)((byte)(savedK1 >> 56)) << 56;
            }
            case 7: {
                state._k1 ^= (long)((byte)(savedK1 >> 48)) << 48;
            }
            case 6: {
                state._k1 ^= (long)((byte)(savedK1 >> 40)) << 40;
            }
            case 5: {
                state._k1 ^= (long)((byte)(savedK1 >> 32)) << 32;
            }
            case 4: {
                state._k1 ^= (long)((byte)(savedK1 >> 24)) << 24;
            }
            case 3: {
                state._k1 ^= (long)((byte)(savedK1 >> 16)) << 16;
            }
            case 2: {
                state._k1 ^= (long)((byte)(savedK1 >> 8)) << 8;
            }
            case 1: {
                state._k1 ^= (long)((byte)savedK1);
                Murmur3PartitionFunction.bmix(state);
            }
        }
        state._h2 ^= (long)byteLen;
        state._h1 += state._h2;
        state._h2 += state._h1;
        state._h1 = Murmur3PartitionFunction.fmix(state._h1);
        state._h2 = Murmur3PartitionFunction.fmix(state._h2);
        state._h1 += state._h2;
        state._h2 += state._h1;
        return (int)(state._h1 >> 32);
    }

    private static void addByte(State state, byte b, int len) {
        int shift = (len & 7) * 8;
        long bb = ((long)b & 0xFFL) << shift;
        if ((len & 8) == 0) {
            state._k1 |= bb;
        } else {
            state._k2 |= bb;
            if ((len & 0xF) == 15) {
                Murmur3PartitionFunction.bmix(state);
                state._k1 = 0L;
                state._k2 = 0L;
            }
        }
    }

    private static class State {
        long _h1;
        long _h2;
        long _k1;
        long _k2;
        long _c1;
        long _c2;

        private State() {
        }
    }
}

