/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.store;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.creator.SegmentVersion;

public class SegmentDirectoryPaths {
    public static final String V3_SUBDIRECTORY_NAME = "v3";

    private SegmentDirectoryPaths() {
    }

    public static File segmentDirectoryFor(File indexDir, SegmentVersion segmentVersion) {
        switch (segmentVersion) {
            case v1: 
            case v2: {
                return indexDir;
            }
            case v3: {
                return new File(indexDir, V3_SUBDIRECTORY_NAME);
            }
        }
        throw new UnsupportedOperationException("Unsupported segment version: " + segmentVersion + " while trying to get segment directory from: " + indexDir);
    }

    public static File findSegmentDirectory(File indexDir) {
        Preconditions.checkArgument((boolean)indexDir.isDirectory(), (String)"Path: %s is not a directory", (Object)indexDir);
        File v3SegmentDir = SegmentDirectoryPaths.segmentDirectoryFor(indexDir, SegmentVersion.v3);
        if (v3SegmentDir.isDirectory()) {
            return v3SegmentDir;
        }
        return indexDir;
    }

    public static boolean isV3Directory(File path) {
        return path.toString().endsWith(V3_SUBDIRECTORY_NAME);
    }

    @Nullable
    public static File findMetadataFile(File indexDir) {
        return SegmentDirectoryPaths.findFormatFile(indexDir, "metadata.properties");
    }

    @Nullable
    public static File findCreationMetaFile(File indexDir) {
        return SegmentDirectoryPaths.findFormatFile(indexDir, "creation.meta");
    }

    @Nullable
    public static File findTextIndexIndexFile(File indexDir, String column) {
        String luceneIndexDirectory = column + ".lucene.v912.index";
        File indexFormatFile = SegmentDirectoryPaths.findFormatFile(indexDir, luceneIndexDirectory);
        if (indexFormatFile == null) {
            luceneIndexDirectory = column + ".lucene.v99.index";
            indexFormatFile = SegmentDirectoryPaths.findFormatFile(indexDir, luceneIndexDirectory);
        }
        if (indexFormatFile == null) {
            luceneIndexDirectory = column + ".lucene.v9.index";
            indexFormatFile = SegmentDirectoryPaths.findFormatFile(indexDir, luceneIndexDirectory);
        }
        if (indexFormatFile == null) {
            luceneIndexDirectory = column + ".lucene.index";
            indexFormatFile = SegmentDirectoryPaths.findFormatFile(indexDir, luceneIndexDirectory);
        }
        return indexFormatFile;
    }

    @Nullable
    public static File findNativeTextIndexIndexFile(File indexDir, String column) {
        String nativeIndexDirectory = column + ".nativetext.idx";
        return SegmentDirectoryPaths.findFormatFile(indexDir, nativeIndexDirectory);
    }

    public static File findFSTIndexIndexFile(File indexDir, String column) {
        String luceneIndexDirectory = column + ".lucene.v912.fst";
        File formatFile = SegmentDirectoryPaths.findFormatFile(indexDir, luceneIndexDirectory);
        if (formatFile == null) {
            luceneIndexDirectory = column + ".lucene.v99.fst";
            formatFile = SegmentDirectoryPaths.findFormatFile(indexDir, luceneIndexDirectory);
        }
        if (formatFile == null) {
            luceneIndexDirectory = column + ".lucene.v9.fst";
            formatFile = SegmentDirectoryPaths.findFormatFile(indexDir, luceneIndexDirectory);
        }
        if (formatFile == null) {
            luceneIndexDirectory = column + ".lucene.fst";
            formatFile = SegmentDirectoryPaths.findFormatFile(indexDir, luceneIndexDirectory);
        }
        return formatFile;
    }

    @Nullable
    @VisibleForTesting
    public static File findTextIndexDocIdMappingFile(File indexDir, String column) {
        String file = column + ".lucene.mapping";
        return SegmentDirectoryPaths.findFormatFile(indexDir, file);
    }

    @Nullable
    @VisibleForTesting
    public static File findVectorIndexIndexFile(File segmentIndexDir, String column) {
        String vectorIndexDirectory = column + ".vector.v912.hnsw.index";
        File formatFile = SegmentDirectoryPaths.findFormatFile(segmentIndexDir, vectorIndexDirectory);
        if (formatFile == null) {
            vectorIndexDirectory = column + ".vector.v99.hnsw.index";
            formatFile = SegmentDirectoryPaths.findFormatFile(segmentIndexDir, vectorIndexDirectory);
        }
        if (formatFile == null) {
            vectorIndexDirectory = column + ".vector.hnsw.index";
            formatFile = SegmentDirectoryPaths.findFormatFile(segmentIndexDir, vectorIndexDirectory);
        }
        return formatFile;
    }

    @Nullable
    private static File findFormatFile(File indexDir, String fileName) {
        Preconditions.checkArgument((boolean)indexDir.isDirectory(), (String)"Path: %s is not a directory", (Object)indexDir);
        File v3Dir = SegmentDirectoryPaths.segmentDirectoryFor(indexDir, SegmentVersion.v3);
        File v3File = new File(v3Dir, fileName);
        if (v3File.exists()) {
            return v3File;
        }
        File v1File = new File(indexDir, fileName);
        if (v1File.exists()) {
            return v1File;
        }
        return null;
    }
}

