/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.customobject;

import java.util.Comparator;
import javax.annotation.Nonnull;
import org.apache.datasketches.theta.SetOperationBuilder;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Union;
import org.apache.pinot.segment.local.customobject.CustomObjectAccumulator;

public class ThetaSketchAccumulator
extends CustomObjectAccumulator<Sketch> {
    private SetOperationBuilder _setOperationBuilder = new SetOperationBuilder();
    private Union _union;

    public ThetaSketchAccumulator() {
    }

    public ThetaSketchAccumulator(SetOperationBuilder setOperationBuilder, int threshold) {
        super(threshold);
        this._setOperationBuilder = setOperationBuilder;
    }

    public void setSetOperationBuilder(SetOperationBuilder setOperationBuilder) {
        this._setOperationBuilder = setOperationBuilder;
    }

    @Override
    @Nonnull
    public Sketch getResult() {
        return this.unionAll();
    }

    private Sketch unionAll() {
        if (this._union == null) {
            this._union = this._setOperationBuilder.buildUnion();
        }
        if (this.isEmpty()) {
            return this._union.getResult(false, null);
        }
        if (this.getNumInputs() == 1) {
            return (Sketch)this._accumulator.get(0);
        }
        this._accumulator.sort(Comparator.comparingDouble(Sketch::getTheta));
        for (Sketch accumulatedSketch : this._accumulator) {
            this._union.union(accumulatedSketch);
        }
        this._accumulator.clear();
        return this._union.getResult(false, null);
    }
}

