/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.dedup;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.segment.local.data.manager.TableDataManager;
import org.apache.pinot.segment.local.dedup.DedupContext;
import org.apache.pinot.segment.local.dedup.PartitionDedupMetadataManager;
import org.apache.pinot.segment.local.dedup.TableDedupMetadataManager;
import org.apache.pinot.spi.config.table.DedupConfig;
import org.apache.pinot.spi.config.table.HashFunction;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTableDedupMetadataManager
implements TableDedupMetadataManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseTableDedupMetadataManager.class);
    protected final Map<Integer, PartitionDedupMetadataManager> _partitionMetadataManagerMap = new ConcurrentHashMap<Integer, PartitionDedupMetadataManager>();
    protected String _tableNameWithType;
    protected DedupContext _dedupContext;
    private boolean _enablePreload;

    @Override
    public void init(TableConfig tableConfig, Schema schema, TableDataManager tableDataManager, ServerMetrics serverMetrics) {
        this._tableNameWithType = tableConfig.getTableName();
        List primaryKeyColumns = schema.getPrimaryKeyColumns();
        Preconditions.checkArgument((!CollectionUtils.isEmpty((Collection)primaryKeyColumns) ? 1 : 0) != 0, (String)"Primary key columns must be configured for dedup enabled table: %s", (Object)this._tableNameWithType);
        DedupConfig dedupConfig = tableConfig.getDedupConfig();
        Preconditions.checkArgument((dedupConfig != null ? 1 : 0) != 0, (String)"Dedup must be enabled for table: %s", (Object)this._tableNameWithType);
        double metadataTTL = dedupConfig.getMetadataTTL();
        String dedupTimeColumn = dedupConfig.getDedupTimeColumn();
        if (dedupTimeColumn == null) {
            dedupTimeColumn = tableConfig.getValidationConfig().getTimeColumnName();
        }
        if (metadataTTL > 0.0) {
            Preconditions.checkArgument((dedupTimeColumn != null ? 1 : 0) != 0, (String)"When metadataTTL is configured, metadata time column or time column must be configured for dedup enabled table: %s", (Object)this._tableNameWithType);
        }
        this._enablePreload = dedupConfig.isEnablePreload() && tableDataManager.getSegmentPreloadExecutor() != null;
        HashFunction hashFunction = dedupConfig.getHashFunction();
        File tableIndexDir = tableDataManager.getTableDataDir();
        DedupContext.Builder dedupContextBuider = new DedupContext.Builder();
        dedupContextBuider.setTableConfig(tableConfig).setSchema(schema).setPrimaryKeyColumns(primaryKeyColumns).setHashFunction(hashFunction).setEnablePreload(this._enablePreload).setMetadataTTL(metadataTTL).setDedupTimeColumn(dedupTimeColumn).setTableIndexDir(tableIndexDir).setTableDataManager(tableDataManager);
        this._dedupContext = dedupContextBuider.build();
        LOGGER.info("Initialized {} for table: {} with primary key columns: {}, hash function: {}, enable preload: {}, metadata TTL: {}, dedup time column: {}, table index dir: {}", new Object[]{this.getClass().getSimpleName(), this._tableNameWithType, primaryKeyColumns, hashFunction, this._enablePreload, metadataTTL, dedupTimeColumn, tableIndexDir});
        this.initCustomVariables();
    }

    @Override
    public PartitionDedupMetadataManager getOrCreatePartitionManager(int partitionId) {
        return this._partitionMetadataManagerMap.computeIfAbsent(partitionId, this::createPartitionDedupMetadataManager);
    }

    protected abstract PartitionDedupMetadataManager createPartitionDedupMetadataManager(Integer var1);

    protected void initCustomVariables() {
    }

    @Override
    public boolean isEnablePreload() {
        return this._enablePreload;
    }

    @Override
    public void stop() {
        for (PartitionDedupMetadataManager metadataManager : this._partitionMetadataManagerMap.values()) {
            metadataManager.stop();
        }
    }

    @Override
    public void close() throws IOException {
        for (PartitionDedupMetadataManager metadataManager : this._partitionMetadataManagerMap.values()) {
            metadataManager.close();
        }
    }
}

