/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.dedup;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.segment.local.dedup.BasePartitionDedupMetadataManager;
import org.apache.pinot.segment.local.dedup.DedupContext;
import org.apache.pinot.segment.local.dedup.DedupRecordInfo;
import org.apache.pinot.segment.local.utils.HashUtils;
import org.apache.pinot.segment.spi.ImmutableSegment;
import org.apache.pinot.segment.spi.IndexSegment;

class ConcurrentMapPartitionDedupMetadataManager
extends BasePartitionDedupMetadataManager {
    @VisibleForTesting
    final ConcurrentHashMap<Object, Pair<IndexSegment, Double>> _primaryKeyToSegmentAndTimeMap = new ConcurrentHashMap();

    protected ConcurrentMapPartitionDedupMetadataManager(String tableNameWithType, int partitionId, DedupContext dedupContext) {
        super(tableNameWithType, partitionId, dedupContext);
    }

    @Override
    protected void doPreloadSegment(ImmutableSegment segment, Iterator<DedupRecordInfo> dedupRecordInfoIterator) {
        while (dedupRecordInfoIterator.hasNext()) {
            DedupRecordInfo dedupRecordInfo = dedupRecordInfoIterator.next();
            double dedupTime = dedupRecordInfo.getDedupTime();
            this._primaryKeyToSegmentAndTimeMap.put(HashUtils.hashPrimaryKey(dedupRecordInfo.getPrimaryKey(), this._hashFunction), (Pair<IndexSegment, Double>)Pair.of((Object)segment, (Object)dedupTime));
        }
    }

    @Override
    protected void doAddOrReplaceSegment(IndexSegment oldSegment, IndexSegment newSegment, Iterator<DedupRecordInfo> dedupRecordInfoIteratorOfNewSegment) {
        String segmentName = newSegment.getSegmentName();
        while (dedupRecordInfoIteratorOfNewSegment.hasNext()) {
            DedupRecordInfo dedupRecordInfo = dedupRecordInfoIteratorOfNewSegment.next();
            double dedupTime = dedupRecordInfo.getDedupTime();
            this._primaryKeyToSegmentAndTimeMap.compute(HashUtils.hashPrimaryKey(dedupRecordInfo.getPrimaryKey(), this._hashFunction), (primaryKey, segmentAndTime) -> {
                if (segmentAndTime == null || this.isOutOfMetadataTTL((Double)segmentAndTime.getRight())) {
                    return Pair.of((Object)newSegment, (Object)dedupTime);
                }
                if (oldSegment == null) {
                    this._logger.warn("When adding a new segment: record in segment: {} with primary key: {} and dedup time: {} already exists in segment: {} with dedup time: {}", new Object[]{segmentName, dedupRecordInfo.getPrimaryKey(), dedupTime, ((IndexSegment)segmentAndTime.getLeft()).getSegmentName(), segmentAndTime.getRight()});
                } else if (segmentAndTime.getLeft() != oldSegment) {
                    this._logger.warn("When replacing a segment: record in segment: {} with primary key: {} and dedup time: {} exists in segment: {} with dedup time: {} (but not the segment: {} to replace)", new Object[]{segmentName, dedupRecordInfo.getPrimaryKey(), dedupTime, ((IndexSegment)segmentAndTime.getLeft()).getSegmentName(), segmentAndTime.getRight(), oldSegment.getSegmentName()});
                }
                if ((Double)segmentAndTime.getRight() <= dedupTime) {
                    return Pair.of((Object)newSegment, (Object)dedupTime);
                }
                return segmentAndTime;
            });
        }
    }

    @Override
    protected void doRemoveSegment(IndexSegment segment, Iterator<DedupRecordInfo> dedupRecordInfoIterator) {
        while (dedupRecordInfoIterator.hasNext()) {
            DedupRecordInfo dedupRecordInfo = dedupRecordInfoIterator.next();
            this._primaryKeyToSegmentAndTimeMap.computeIfPresent(HashUtils.hashPrimaryKey(dedupRecordInfo.getPrimaryKey(), this._hashFunction), (primaryKey, segmentAndTime) -> {
                if (segmentAndTime.getLeft() == segment) {
                    return null;
                }
                return segmentAndTime;
            });
        }
    }

    @Override
    protected void doRemoveExpiredPrimaryKeys() {
        double smallestTimeToKeep = this._largestSeenTime.get() - this._metadataTTL;
        this._primaryKeyToSegmentAndTimeMap.entrySet().removeIf(entry -> (Double)((Pair)entry.getValue()).getRight() < smallestTimeToKeep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkRecordPresentOrUpdate(DedupRecordInfo dedupRecordInfo, IndexSegment indexSegment) {
        if (!this.startOperation()) {
            this._logger.info("Skip adding record to {} because metadata manager is already stopped", (Object)indexSegment.getSegmentName());
            return true;
        }
        try {
            if (this._metadataTTL > 0.0) {
                this._largestSeenTime.getAndUpdate(time -> Math.max(time, dedupRecordInfo.getDedupTime()));
            }
            AtomicBoolean present = new AtomicBoolean(false);
            this._primaryKeyToSegmentAndTimeMap.compute(HashUtils.hashPrimaryKey(dedupRecordInfo.getPrimaryKey(), this._hashFunction), (primaryKey, segmentAndTime) -> {
                if (segmentAndTime == null || this.isOutOfMetadataTTL((Double)segmentAndTime.getRight())) {
                    return Pair.of((Object)indexSegment, (Object)dedupRecordInfo.getDedupTime());
                }
                present.set(true);
                return segmentAndTime;
            });
            if (!present.get()) {
                this.updatePrimaryKeyGauge();
            }
            boolean bl = present.get();
            return bl;
        }
        finally {
            this.finishOperation();
        }
    }

    @Override
    protected long getNumPrimaryKeys() {
        return this._primaryKeyToSegmentAndTimeMap.size();
    }

    @Override
    protected void doClose() throws IOException {
        this._primaryKeyToSegmentAndTimeMap.clear();
    }
}

