/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.io.compression;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.pinot.segment.spi.compression.ChunkDecompressor;

class GzipDecompressor
implements ChunkDecompressor {
    private final Inflater _decompressor = new Inflater();

    public int decompress(ByteBuffer compressedInput, ByteBuffer decompressedOutput) throws IOException {
        this._decompressor.reset();
        this._decompressor.setInput(compressedInput);
        try {
            this._decompressor.inflate(decompressedOutput);
        }
        catch (DataFormatException e) {
            throw new IOException(e);
        }
        decompressedOutput.flip();
        return (int)this._decompressor.getBytesWritten();
    }

    public int decompressedLength(ByteBuffer compressedInput) {
        int offset = compressedInput.limit() - 4;
        return offset > -1 ? compressedInput.getInt(offset) : -1;
    }

    public void close() throws IOException {
        this._decompressor.end();
    }
}

