/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.io.writer.impl;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import org.apache.pinot.segment.local.io.util.FixedBitIntReaderWriter;
import org.apache.pinot.segment.local.io.util.FixedByteValueReaderWriter;
import org.apache.pinot.segment.local.io.util.PinotDataBitSet;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;

public class FixedBitMVForwardIndexWriter
implements Closeable {
    private static final int SIZE_OF_INT = 4;
    private static final int NUM_COLS_IN_HEADER = 1;
    private static final int PREFERRED_NUM_VALUES_PER_CHUNK = 2048;
    private PinotDataBuffer _indexDataBuffer;
    private PinotDataBuffer _chunkOffsetsBuffer;
    private PinotDataBuffer _bitsetBuffer;
    private PinotDataBuffer _rawDataBuffer;
    private FixedByteValueReaderWriter _chunkOffsetsWriter;
    private PinotDataBitSet _customBitSet;
    private FixedBitIntReaderWriter _rawDataWriter;
    private int _numChunks;
    private int _prevRowStartIndex = 0;
    private int _prevRowLength = 0;
    private int _chunkOffsetHeaderSize;
    private int _bitsetSize;
    private long _rawDataSize;
    private long _totalSize;
    private int _docsPerChunk;
    private int _nextDocId = 0;

    public FixedBitMVForwardIndexWriter(File file, int numDocs, int totalNumValues, int numBitsPerValue) throws IOException {
        float averageValuesPerDoc = totalNumValues / numDocs;
        this._docsPerChunk = (int)Math.ceil(2048.0f / averageValuesPerDoc);
        this._numChunks = (numDocs + this._docsPerChunk - 1) / this._docsPerChunk;
        this._chunkOffsetHeaderSize = this._numChunks * 4 * 1;
        this._bitsetSize = (totalNumValues + 7) / 8;
        this._rawDataSize = ((long)totalNumValues * (long)numBitsPerValue + 7L) / 8L;
        this._totalSize = (long)(this._chunkOffsetHeaderSize + this._bitsetSize) + this._rawDataSize;
        Preconditions.checkState((this._totalSize > 0L && this._totalSize < Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Total size can not exceed 2GB for file: ", (Object)file.toString());
        this._indexDataBuffer = PinotDataBuffer.mapFile((File)file, (boolean)false, (long)0L, (long)this._totalSize, (ByteOrder)ByteOrder.BIG_ENDIAN, (String)this.getClass().getSimpleName());
        this._chunkOffsetsBuffer = this._indexDataBuffer.view(0L, (long)this._chunkOffsetHeaderSize);
        int bitsetEndPos = this._chunkOffsetHeaderSize + this._bitsetSize;
        this._bitsetBuffer = this._indexDataBuffer.view((long)this._chunkOffsetHeaderSize, (long)bitsetEndPos);
        this._rawDataBuffer = this._indexDataBuffer.view((long)bitsetEndPos, (long)bitsetEndPos + this._rawDataSize);
        this._chunkOffsetsWriter = new FixedByteValueReaderWriter(this._chunkOffsetsBuffer);
        this._customBitSet = new PinotDataBitSet(this._bitsetBuffer);
        this._rawDataWriter = new FixedBitIntReaderWriter(this._rawDataBuffer, totalNumValues, numBitsPerValue);
    }

    public int getChunkOffsetHeaderSize() {
        return this._chunkOffsetHeaderSize;
    }

    public int getBitsetSize() {
        return this._bitsetSize;
    }

    public long getRawDataSize() {
        return this._rawDataSize;
    }

    public long getTotalSize() {
        return this._totalSize;
    }

    public int getNumChunks() {
        return this._numChunks;
    }

    public int getRowsPerChunk() {
        return this._docsPerChunk;
    }

    @Override
    public void close() throws IOException {
        this._customBitSet.close();
        this._chunkOffsetsWriter.close();
        this._rawDataWriter.close();
        this._indexDataBuffer.close();
        this._chunkOffsetsBuffer = null;
        this._bitsetBuffer = null;
        this._rawDataBuffer = null;
        this._customBitSet = null;
        this._chunkOffsetsWriter = null;
        this._rawDataWriter = null;
    }

    private int updateHeader(int length) {
        int docId;
        int newStartIndex = this._prevRowStartIndex + this._prevRowLength;
        if ((docId = this._nextDocId++) % this._docsPerChunk == 0) {
            int chunkId = docId / this._docsPerChunk;
            this._chunkOffsetsWriter.writeInt(chunkId, newStartIndex);
        }
        this._customBitSet.setBit(newStartIndex);
        this._prevRowStartIndex = newStartIndex;
        this._prevRowLength = length;
        return newStartIndex;
    }

    public void putDictIds(int[] dictIds) {
        this._rawDataWriter.writeInt(this.updateHeader(dictIds.length), dictIds.length, dictIds);
    }
}

