/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl.dictionary;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.math.BigDecimal;
import java.util.Arrays;
import org.apache.pinot.segment.local.realtime.impl.dictionary.BaseOnHeapMutableDictionary;
import org.apache.pinot.spi.data.FieldSpec;

public class BigDecimalOnHeapMutableDictionary
extends BaseOnHeapMutableDictionary {
    private volatile BigDecimal _min = null;
    private volatile BigDecimal _max = null;

    public int index(Object value) {
        BigDecimal bigDecimalValue = (BigDecimal)value;
        this.updateMinMax(bigDecimalValue);
        return this.indexValue(bigDecimalValue);
    }

    public int[] index(Object[] values) {
        int numValues = values.length;
        int[] dictIds = new int[numValues];
        for (int i = 0; i < numValues; ++i) {
            BigDecimal bigDecimalValue = (BigDecimal)values[i];
            this.updateMinMax(bigDecimalValue);
            dictIds[i] = this.indexValue(bigDecimalValue);
        }
        return dictIds;
    }

    public int compare(int dictId1, int dictId2) {
        return this.getBigDecimalValue(dictId1).compareTo(this.getBigDecimalValue(dictId2));
    }

    public IntSet getDictIdsInRange(String lower, String upper, boolean includeLower, boolean includeUpper) {
        int numValues = this.length();
        if (numValues == 0) {
            return IntSets.EMPTY_SET;
        }
        IntOpenHashSet dictIds = new IntOpenHashSet();
        if (lower.equals("*")) {
            BigDecimal upperValue = new BigDecimal(upper);
            if (includeUpper) {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    BigDecimal value = this.getBigDecimalValue(dictId);
                    if (value.compareTo(upperValue) > 0) continue;
                    dictIds.add(dictId);
                }
            } else {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    BigDecimal value = this.getBigDecimalValue(dictId);
                    if (value.compareTo(upperValue) >= 0) continue;
                    dictIds.add(dictId);
                }
            }
        } else if (upper.equals("*")) {
            BigDecimal lowerValue = new BigDecimal(lower);
            if (includeLower) {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    BigDecimal value = this.getBigDecimalValue(dictId);
                    if (value.compareTo(lowerValue) < 0) continue;
                    dictIds.add(dictId);
                }
            } else {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    BigDecimal value = this.getBigDecimalValue(dictId);
                    if (value.compareTo(lowerValue) <= 0) continue;
                    dictIds.add(dictId);
                }
            }
        } else {
            BigDecimal lowerValue = new BigDecimal(lower);
            BigDecimal upperValue = new BigDecimal(upper);
            if (includeLower && includeUpper) {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    BigDecimal value = this.getBigDecimalValue(dictId);
                    if (value.compareTo(lowerValue) < 0 || value.compareTo(upperValue) > 0) continue;
                    dictIds.add(dictId);
                }
            } else if (includeLower) {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    BigDecimal value = this.getBigDecimalValue(dictId);
                    if (value.compareTo(lowerValue) < 0 || value.compareTo(upperValue) >= 0) continue;
                    dictIds.add(dictId);
                }
            } else if (includeUpper) {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    BigDecimal value = this.getBigDecimalValue(dictId);
                    if (value.compareTo(lowerValue) <= 0 || value.compareTo(upperValue) > 0) continue;
                    dictIds.add(dictId);
                }
            } else {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    BigDecimal value = this.getBigDecimalValue(dictId);
                    if (value.compareTo(lowerValue) <= 0 || value.compareTo(upperValue) >= 0) continue;
                    dictIds.add(dictId);
                }
            }
        }
        return dictIds;
    }

    public BigDecimal getMinVal() {
        return this._min;
    }

    public BigDecimal getMaxVal() {
        return this._max;
    }

    public BigDecimal[] getSortedValues() {
        int numValues = this.length();
        Object[] sortedValues = new BigDecimal[numValues];
        for (int dictId = 0; dictId < numValues; ++dictId) {
            sortedValues[dictId] = this.getBigDecimalValue(dictId);
        }
        Arrays.sort(sortedValues);
        return sortedValues;
    }

    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.BIG_DECIMAL;
    }

    public int indexOf(String stringValue) {
        return this.getDictId(new BigDecimal(stringValue));
    }

    public int indexOf(BigDecimal bigDecimalValue) {
        return this.getDictId(bigDecimalValue);
    }

    public int getIntValue(int dictId) {
        return this.getBigDecimalValue(dictId).intValue();
    }

    public long getLongValue(int dictId) {
        return this.getBigDecimalValue(dictId).longValue();
    }

    public float getFloatValue(int dictId) {
        return this.getBigDecimalValue(dictId).floatValue();
    }

    public double getDoubleValue(int dictId) {
        return this.getBigDecimalValue(dictId).doubleValue();
    }

    public BigDecimal getBigDecimalValue(int dictId) {
        return (BigDecimal)this.get(dictId);
    }

    public String getStringValue(int dictId) {
        return this.getBigDecimalValue(dictId).toPlainString();
    }

    public byte[] getBytesValue(int dictId) {
        return this.getBytesValue(dictId);
    }

    private void updateMinMax(BigDecimal value) {
        if (this._min == null) {
            this._min = value;
            this._max = value;
        } else {
            if (value.compareTo(this._min) < 0) {
                this._min = value;
            }
            if (value.compareTo(this._max) > 0) {
                this._max = value;
            }
        }
    }
}

