/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl.dictionary;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.math.BigDecimal;
import org.apache.pinot.segment.spi.index.mutable.MutableDictionary;
import org.apache.pinot.spi.data.FieldSpec;

public class SameValueMutableDictionary
implements MutableDictionary {
    private final Object _actualValue;
    private final Object[] _actualValues;
    private final MutableDictionary _delegate;

    public SameValueMutableDictionary(Object value, MutableDictionary delegate) {
        this._actualValue = value;
        this._actualValues = new Object[]{value};
        this._delegate = delegate;
    }

    public int index(Object value) {
        return this._delegate.index(this._actualValue);
    }

    public int[] index(Object[] values) {
        return this._delegate.index(this._actualValues);
    }

    public FieldSpec.DataType getValueType() {
        return this._delegate.getValueType();
    }

    public int length() {
        return this._delegate.length();
    }

    public int indexOf(String stringValue) {
        return this._delegate.index((Object)stringValue);
    }

    public IntSet getDictIdsInRange(String lower, String upper, boolean includeLower, boolean includeUpper) {
        return this._delegate.getDictIdsInRange(lower, upper, includeLower, includeUpper);
    }

    public int compare(int dictId1, int dictId2) {
        return this._delegate.compare(dictId1, dictId2);
    }

    public String getMinVal() {
        return this._actualValue.toString();
    }

    public String getMaxVal() {
        return this._actualValue.toString();
    }

    public Object getSortedValues() {
        return this._delegate.getSortedValues();
    }

    public Object get(int dictId) {
        return this._actualValue;
    }

    public int getIntValue(int dictId) {
        return Integer.parseInt(this._actualValue.toString());
    }

    public long getLongValue(int dictId) {
        return Long.parseLong(this._actualValue.toString());
    }

    public float getFloatValue(int dictId) {
        return Float.parseFloat(this._actualValue.toString());
    }

    public double getDoubleValue(int dictId) {
        return Double.parseDouble(this._actualValue.toString());
    }

    public BigDecimal getBigDecimalValue(int dictId) {
        return BigDecimal.valueOf(this.getDoubleValue(dictId));
    }

    public String getStringValue(int dictId) {
        return this._actualValue.toString();
    }

    public void close() throws IOException {
        this._delegate.close();
    }
}

