/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl.forward;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.pinot.segment.local.io.reader.impl.FixedByteSingleValueMultiColReader;
import org.apache.pinot.segment.local.io.writer.impl.FixedByteSingleValueMultiColWriter;
import org.apache.pinot.segment.spi.index.mutable.MutableForwardIndex;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.memory.PinotDataBufferMemoryManager;
import org.apache.pinot.spi.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedByteMVMutableForwardIndex
implements MutableForwardIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(FixedByteMVMutableForwardIndex.class);
    private static final int SIZE_OF_INT = 4;
    private static final int NUM_COLS_IN_HEADER = 3;
    private static final int INCREMENT_PERCENTAGE = 100;
    private static final int DEFAULT_THRESHOLD_FOR_NUM_OF_VALUES_PER_COLUMN = 450000000;
    private final List<FixedByteSingleValueMultiColWriter> _headerWriters = new ArrayList<FixedByteSingleValueMultiColWriter>();
    private final List<FixedByteSingleValueMultiColReader> _headerReaders = new CopyOnWriteArrayList<FixedByteSingleValueMultiColReader>();
    private final List<FixedByteSingleValueMultiColWriter> _dataWriters = new ArrayList<FixedByteSingleValueMultiColWriter>();
    private final List<FixedByteSingleValueMultiColReader> _dataReaders = new CopyOnWriteArrayList<FixedByteSingleValueMultiColReader>();
    private final int _headerSize;
    private final int _incrementalCapacity;
    private final int _columnSizeInBytes;
    private final int _maxNumberOfMultiValuesPerRow;
    private final int _rowCountPerChunk;
    private final PinotDataBufferMemoryManager _memoryManager;
    private final String _context;
    private final boolean _isDictionaryEncoded;
    private final FieldSpec.DataType _storedType;
    private FixedByteSingleValueMultiColWriter _curHeaderWriter;
    private FixedByteSingleValueMultiColWriter _currentDataWriter;
    private int _currentCapacity = 0;
    private int _prevRowStartIndex = 0;
    private int _prevRowLength = 0;
    private int _numValues = 0;

    public FixedByteMVMutableForwardIndex(int maxNumberOfMultiValuesPerRow, int avgMultiValueCount, int rowCountPerChunk, int columnSizeInBytes, PinotDataBufferMemoryManager memoryManager, String context, boolean isDictionaryEncoded, FieldSpec.DataType storedType) {
        this._memoryManager = memoryManager;
        this._context = context;
        int initialCapacity = Math.max(maxNumberOfMultiValuesPerRow, rowCountPerChunk * avgMultiValueCount);
        int incrementalCapacity = Math.max(maxNumberOfMultiValuesPerRow, (int)((float)initialCapacity * 1.0f * 100.0f / 100.0f));
        this._columnSizeInBytes = columnSizeInBytes;
        this._maxNumberOfMultiValuesPerRow = maxNumberOfMultiValuesPerRow;
        this._headerSize = rowCountPerChunk * 4 * 3;
        this._rowCountPerChunk = rowCountPerChunk;
        this.addHeaderBuffer();
        this._incrementalCapacity = incrementalCapacity;
        this.addDataBuffer(initialCapacity);
        this._isDictionaryEncoded = isDictionaryEncoded;
        this._storedType = storedType;
    }

    private void addHeaderBuffer() {
        LOGGER.info("Allocating header buffer of size {} for: {}", (Object)this._headerSize, (Object)this._context);
        PinotDataBuffer headerBuffer = this._memoryManager.allocate((long)this._headerSize, this._context);
        this._curHeaderWriter = new FixedByteSingleValueMultiColWriter(headerBuffer, 3, new int[]{4, 4, 4});
        this._headerWriters.add(this._curHeaderWriter);
        this._headerReaders.add(new FixedByteSingleValueMultiColReader(headerBuffer, this._rowCountPerChunk, new int[]{4, 4, 4}));
    }

    private void addDataBuffer(int rowCapacity) {
        try {
            long size = (long)rowCapacity * (long)this._columnSizeInBytes;
            LOGGER.info("Allocating data buffer of size {} for column {}", (Object)size, (Object)this._context);
            PinotDataBuffer dataBuffer = this._memoryManager.allocate(size, this._context);
            this._currentDataWriter = new FixedByteSingleValueMultiColWriter(dataBuffer, 1, new int[]{this._columnSizeInBytes});
            this._dataWriters.add(this._currentDataWriter);
            this._dataReaders.add(new FixedByteSingleValueMultiColReader(dataBuffer, rowCapacity, new int[]{this._columnSizeInBytes}));
            this._currentCapacity = rowCapacity;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while expanding the capacity by allocating additional buffer with capacity:" + rowCapacity, e);
        }
    }

    private void writeIntoHeader(int row, int dataWriterIndex, int startIndex, int length) {
        if (row >= this._headerWriters.size() * this._rowCountPerChunk) {
            this.addHeaderBuffer();
        }
        this._curHeaderWriter.setInt(this.getRowInCurrentHeader(row), 0, dataWriterIndex);
        this._curHeaderWriter.setInt(this.getRowInCurrentHeader(row), 1, startIndex);
        this._curHeaderWriter.setInt(this.getRowInCurrentHeader(row), 2, length);
    }

    private FixedByteSingleValueMultiColReader getCurrentReader(int row) {
        return this._headerReaders.get(row / this._rowCountPerChunk);
    }

    private int getRowInCurrentHeader(int row) {
        return row % this._rowCountPerChunk;
    }

    private int updateHeader(int row, int numValues) {
        assert (numValues <= this._maxNumberOfMultiValuesPerRow);
        this._numValues += numValues;
        int newStartIndex = this._prevRowStartIndex + this._prevRowLength;
        if (newStartIndex + numValues > this._currentCapacity) {
            this.addDataBuffer(this._incrementalCapacity);
            this._prevRowStartIndex = 0;
            this._prevRowLength = 0;
            newStartIndex = 0;
        }
        this.writeIntoHeader(row, this._dataWriters.size() - 1, newStartIndex, numValues);
        this._prevRowStartIndex = newStartIndex;
        this._prevRowLength = numValues;
        return newStartIndex;
    }

    public int getMaxChunkCapacity() {
        return this._incrementalCapacity;
    }

    public boolean isDictionaryEncoded() {
        return this._isDictionaryEncoded;
    }

    public boolean isSingleValue() {
        return false;
    }

    public FieldSpec.DataType getStoredType() {
        return this._storedType;
    }

    public int getLengthOfShortestElement() {
        return this._columnSizeInBytes;
    }

    public int getLengthOfLongestElement() {
        return this._columnSizeInBytes;
    }

    public int getDictIdMV(int docId, int[] dictIdBuffer) {
        FixedByteSingleValueMultiColReader headerReader = this.getCurrentReader(docId);
        int rowInCurrentHeader = this.getRowInCurrentHeader(docId);
        int bufferIndex = headerReader.getInt(rowInCurrentHeader, 0);
        int startIndex = headerReader.getInt(rowInCurrentHeader, 1);
        int length = headerReader.getInt(rowInCurrentHeader, 2);
        FixedByteSingleValueMultiColReader dataReader = this._dataReaders.get(bufferIndex);
        for (int i = 0; i < length; ++i) {
            dictIdBuffer[i] = dataReader.getInt(startIndex + i, 0);
        }
        return length;
    }

    public int[] getDictIdMV(int docId) {
        FixedByteSingleValueMultiColReader headerReader = this.getCurrentReader(docId);
        int rowInCurrentHeader = this.getRowInCurrentHeader(docId);
        int bufferIndex = headerReader.getInt(rowInCurrentHeader, 0);
        int startIndex = headerReader.getInt(rowInCurrentHeader, 1);
        int length = headerReader.getInt(rowInCurrentHeader, 2);
        FixedByteSingleValueMultiColReader dataReader = this._dataReaders.get(bufferIndex);
        int[] dictIdBuffer = new int[length];
        for (int i = 0; i < length; ++i) {
            dictIdBuffer[i] = dataReader.getInt(startIndex + i, 0);
        }
        return dictIdBuffer;
    }

    public int getIntMV(int docId, int[] valueBuffer) {
        return this.getDictIdMV(docId, valueBuffer);
    }

    public int[] getIntMV(int docId) {
        return this.getDictIdMV(docId);
    }

    public int getLongMV(int docId, long[] valueBuffer) {
        FixedByteSingleValueMultiColReader headerReader = this.getCurrentReader(docId);
        int rowInCurrentHeader = this.getRowInCurrentHeader(docId);
        int bufferIndex = headerReader.getInt(rowInCurrentHeader, 0);
        int startIndex = headerReader.getInt(rowInCurrentHeader, 1);
        int length = headerReader.getInt(rowInCurrentHeader, 2);
        FixedByteSingleValueMultiColReader dataReader = this._dataReaders.get(bufferIndex);
        for (int i = 0; i < length; ++i) {
            valueBuffer[i] = dataReader.getLong(startIndex + i, 0);
        }
        return length;
    }

    public long[] getLongMV(int docId) {
        FixedByteSingleValueMultiColReader headerReader = this.getCurrentReader(docId);
        int rowInCurrentHeader = this.getRowInCurrentHeader(docId);
        int bufferIndex = headerReader.getInt(rowInCurrentHeader, 0);
        int startIndex = headerReader.getInt(rowInCurrentHeader, 1);
        int length = headerReader.getInt(rowInCurrentHeader, 2);
        FixedByteSingleValueMultiColReader dataReader = this._dataReaders.get(bufferIndex);
        long[] valueBuffer = new long[length];
        for (int i = 0; i < length; ++i) {
            valueBuffer[i] = dataReader.getLong(startIndex + i, 0);
        }
        return valueBuffer;
    }

    public int getFloatMV(int docId, float[] valueBuffer) {
        FixedByteSingleValueMultiColReader headerReader = this.getCurrentReader(docId);
        int rowInCurrentHeader = this.getRowInCurrentHeader(docId);
        int bufferIndex = headerReader.getInt(rowInCurrentHeader, 0);
        int startIndex = headerReader.getInt(rowInCurrentHeader, 1);
        int length = headerReader.getInt(rowInCurrentHeader, 2);
        FixedByteSingleValueMultiColReader dataReader = this._dataReaders.get(bufferIndex);
        for (int i = 0; i < length; ++i) {
            valueBuffer[i] = dataReader.getFloat(startIndex + i, 0);
        }
        return length;
    }

    public float[] getFloatMV(int docId) {
        FixedByteSingleValueMultiColReader headerReader = this.getCurrentReader(docId);
        int rowInCurrentHeader = this.getRowInCurrentHeader(docId);
        int bufferIndex = headerReader.getInt(rowInCurrentHeader, 0);
        int startIndex = headerReader.getInt(rowInCurrentHeader, 1);
        int length = headerReader.getInt(rowInCurrentHeader, 2);
        FixedByteSingleValueMultiColReader dataReader = this._dataReaders.get(bufferIndex);
        float[] valueBuffer = new float[length];
        for (int i = 0; i < length; ++i) {
            valueBuffer[i] = dataReader.getFloat(startIndex + i, 0);
        }
        return valueBuffer;
    }

    public int getDoubleMV(int docId, double[] valueBuffer) {
        FixedByteSingleValueMultiColReader headerReader = this.getCurrentReader(docId);
        int rowInCurrentHeader = this.getRowInCurrentHeader(docId);
        int bufferIndex = headerReader.getInt(rowInCurrentHeader, 0);
        int startIndex = headerReader.getInt(rowInCurrentHeader, 1);
        int length = headerReader.getInt(rowInCurrentHeader, 2);
        FixedByteSingleValueMultiColReader dataReader = this._dataReaders.get(bufferIndex);
        for (int i = 0; i < length; ++i) {
            valueBuffer[i] = dataReader.getDouble(startIndex + i, 0);
        }
        return length;
    }

    public double[] getDoubleMV(int docId) {
        FixedByteSingleValueMultiColReader headerReader = this.getCurrentReader(docId);
        int rowInCurrentHeader = this.getRowInCurrentHeader(docId);
        int bufferIndex = headerReader.getInt(rowInCurrentHeader, 0);
        int startIndex = headerReader.getInt(rowInCurrentHeader, 1);
        int length = headerReader.getInt(rowInCurrentHeader, 2);
        FixedByteSingleValueMultiColReader dataReader = this._dataReaders.get(bufferIndex);
        double[] valueBuffer = new double[length];
        for (int i = 0; i < length; ++i) {
            valueBuffer[i] = dataReader.getDouble(startIndex + i, 0);
        }
        return valueBuffer;
    }

    public int getNumValuesMV(int docId) {
        FixedByteSingleValueMultiColReader headerReader = this.getCurrentReader(docId);
        int rowInCurrentHeader = this.getRowInCurrentHeader(docId);
        return headerReader.getInt(rowInCurrentHeader, 2);
    }

    public void setDictIdMV(int docId, int[] dictIds) {
        int newStartIndex = this.updateHeader(docId, dictIds.length);
        for (int i = 0; i < dictIds.length; ++i) {
            this._currentDataWriter.setInt(newStartIndex + i, 0, dictIds[i]);
        }
    }

    public void setIntMV(int docId, int[] values) {
        this.setDictIdMV(docId, values);
    }

    public void setLongMV(int docId, long[] values) {
        int newStartIndex = this.updateHeader(docId, values.length);
        for (int i = 0; i < values.length; ++i) {
            this._currentDataWriter.setLong(newStartIndex + i, 0, values[i]);
        }
    }

    public void setFloatMV(int docId, float[] values) {
        int newStartIndex = this.updateHeader(docId, values.length);
        for (int i = 0; i < values.length; ++i) {
            this._currentDataWriter.setFloat(newStartIndex + i, 0, values[i]);
        }
    }

    public void setDoubleMV(int docId, double[] values) {
        int newStartIndex = this.updateHeader(docId, values.length);
        for (int i = 0; i < values.length; ++i) {
            this._currentDataWriter.setDouble(newStartIndex + i, 0, values[i]);
        }
    }

    public boolean canAddMore() {
        return this._numValues < 450000000;
    }

    public void close() throws IOException {
        for (FixedByteSingleValueMultiColWriter writer : this._headerWriters) {
            writer.close();
        }
        for (FixedByteSingleValueMultiColReader reader : this._headerReaders) {
            reader.close();
        }
        for (FixedByteSingleValueMultiColWriter writer : this._dataWriters) {
            writer.close();
        }
        for (FixedByteSingleValueMultiColReader reader : this._dataReaders) {
            reader.close();
        }
    }
}

