/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl.forward;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.index.mutable.MutableForwardIndex;
import org.apache.pinot.spi.data.FieldSpec;

public class SameValueMutableForwardIndex
implements MutableForwardIndex {
    private final Object _actualValue;
    private final Object[] _actualValues;
    private final MutableForwardIndex _delegate;

    public SameValueMutableForwardIndex(Object actualValue, MutableForwardIndex delegate) {
        this._actualValue = actualValue;
        this._actualValues = new Object[]{actualValue};
        this._delegate = delegate;
    }

    public int getLengthOfShortestElement() {
        return this._actualValue.toString().length();
    }

    public int getLengthOfLongestElement() {
        return this._actualValue.toString().length();
    }

    public boolean isDictionaryEncoded() {
        return this._delegate.isDictionaryEncoded();
    }

    public boolean isSingleValue() {
        return this._delegate.isSingleValue();
    }

    public FieldSpec.DataType getStoredType() {
        return this._delegate.getStoredType();
    }

    public int getDictId(int docId) {
        return this._delegate.getDictId(docId);
    }

    public void readDictIds(int[] docIds, int length, int[] dictIdBuffer) {
        this._delegate.readDictIds(docIds, length, dictIdBuffer);
    }

    public int getInt(int docId) {
        return this._delegate.getInt(docId);
    }

    public long getLong(int docId) {
        return this._delegate.getLong(docId);
    }

    public float getFloat(int docId) {
        return this._delegate.getFloat(docId);
    }

    public double getDouble(int docId) {
        return this._delegate.getDouble(docId);
    }

    public String getString(int docId) {
        return this._actualValue.toString();
    }

    public byte[] getBytes(int docId) {
        return this._actualValue.toString().getBytes();
    }

    public void setDictId(int docId, int dictId) {
        this._delegate.setDictId(docId, dictId);
    }

    public void setInt(int docId, int value) {
        this._delegate.setInt(docId, value);
    }

    public void setLong(int docId, long value) {
        this._delegate.setLong(docId, value);
    }

    public void setFloat(int docId, float value) {
        this._delegate.setFloat(docId, value);
    }

    public void setDouble(int docId, double value) {
        this._delegate.setDouble(docId, value);
    }

    public void setString(int docId, String value) {
        this._delegate.setString(docId, value);
    }

    public void setBytes(int docId, byte[] value) {
        this._delegate.setBytes(docId, value);
    }

    public int getDictIdMV(int docId, int[] dictIdBuffer) {
        return this._delegate.getDictIdMV(docId, dictIdBuffer);
    }

    public int[] getDictIdMV(int docId) {
        return this._delegate.getDictIdMV(docId);
    }

    public int[] getIntMV(int docId) {
        return this._delegate.getIntMV(docId);
    }

    public long[] getLongMV(int docId) {
        return this._delegate.getLongMV(docId);
    }

    public float[] getFloatMV(int docId) {
        return this._delegate.getFloatMV(docId);
    }

    public double[] getDoubleMV(int docId) {
        return this._delegate.getDoubleMV(docId);
    }

    public String[] getStringMV(int docId) {
        return this._delegate.getStringMV(docId);
    }

    public byte[][] getBytesMV(int docId) {
        return this._delegate.getBytesMV(docId);
    }

    public int getNumValuesMV(int docId) {
        return this._delegate.getNumValuesMV(docId);
    }

    public void setDictIdMV(int docId, int[] dictIds) {
        this._delegate.setDictIdMV(docId, dictIds);
    }

    public void setIntMV(int docId, int[] values) {
        this._delegate.setIntMV(docId, values);
    }

    public void setLongMV(int docId, long[] values) {
        this._delegate.setLongMV(docId, values);
    }

    public void setFloatMV(int docId, float[] values) {
        this._delegate.setFloatMV(docId, values);
    }

    public void setDoubleMV(int docId, double[] values) {
        this._delegate.setDoubleMV(docId, values);
    }

    public void setStringMV(int docId, String[] values) {
        this._delegate.setStringMV(docId, values);
    }

    public void setBytesMV(int docId, byte[][] values) {
        this._delegate.setBytesMV(docId, values);
    }

    public void close() throws IOException {
        this._delegate.close();
    }

    public void add(@Nonnull Object value, int dictId, int docId) {
        this._delegate.add(this._actualValue, dictId, docId);
    }

    public void add(@Nonnull Object[] values, @Nullable int[] dictIds, int docId) {
        this._delegate.add(this._actualValues, dictIds, docId);
    }
}

