/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl.invertedindex;

import com.google.common.annotations.VisibleForTesting;
import java.time.Clock;
import java.util.function.Supplier;
import org.apache.lucene.search.ReferenceManager;
import org.apache.pinot.segment.local.realtime.impl.invertedindex.RealtimeLuceneIndexingDelayTracker;

public class RealtimeLuceneRefreshListener
implements ReferenceManager.RefreshListener {
    private final RealtimeLuceneIndexingDelayTracker _realtimeLuceneIndexingDelayTracker;
    private final int _partition;
    private final String _tableName;
    private final String _segmentName;
    private final String _columnName;
    private final Supplier<Integer> _numDocsSupplier;
    private final Supplier<Integer> _numDocsDelaySupplier;
    private final Supplier<Long> _timeMsDelaySupplier;
    private long _lastRefreshTimeMs;
    private int _lastRefreshNumDocs;
    private int _numDocsBeforeRefresh;
    private Clock _clock;

    public RealtimeLuceneRefreshListener(String tableName, String segmentName, String columnName, int partition, Supplier<Integer> numDocsSupplier) {
        this(tableName, segmentName, columnName, partition, numDocsSupplier, Clock.systemUTC());
    }

    @VisibleForTesting
    public RealtimeLuceneRefreshListener(String tableName, String segmentName, String columnName, int partition, Supplier<Integer> numDocsSupplier, Clock clock) {
        this._partition = partition;
        this._tableName = tableName;
        this._segmentName = segmentName;
        this._columnName = columnName;
        this._numDocsSupplier = numDocsSupplier;
        this._clock = clock;
        this._lastRefreshTimeMs = this._clock.millis();
        this._lastRefreshNumDocs = this._numDocsSupplier.get();
        this._numDocsDelaySupplier = this.initNumDocsDelaySupplier();
        this._timeMsDelaySupplier = this.initTimeMsDelaySupplier();
        this._realtimeLuceneIndexingDelayTracker = RealtimeLuceneIndexingDelayTracker.getInstance();
        this._realtimeLuceneIndexingDelayTracker.registerDelaySuppliers(this._tableName, this._segmentName, this._columnName, this._partition, this._numDocsDelaySupplier, this._timeMsDelaySupplier);
    }

    public void beforeRefresh() {
        this._numDocsBeforeRefresh = this._numDocsSupplier.get();
    }

    public void afterRefresh(boolean didRefresh) {
        if (didRefresh || this._lastRefreshNumDocs == this._numDocsBeforeRefresh) {
            this._lastRefreshTimeMs = this._clock.millis();
            this._lastRefreshNumDocs = this._numDocsBeforeRefresh;
        }
    }

    private Supplier<Integer> initNumDocsDelaySupplier() {
        return () -> this._numDocsSupplier.get() - this._lastRefreshNumDocs;
    }

    private Supplier<Long> initTimeMsDelaySupplier() {
        return () -> {
            if (this._numDocsDelaySupplier.get() == 0) {
                this._lastRefreshTimeMs = this._clock.millis();
            }
            return this._clock.millis() - this._lastRefreshTimeMs;
        };
    }

    public void close() {
        this._realtimeLuceneIndexingDelayTracker.clear(this._tableName, this._segmentName, this._columnName, this._partition);
    }

    @VisibleForTesting
    public Supplier<Integer> getNumDocsDelaySupplier() {
        return this._numDocsDelaySupplier;
    }

    @VisibleForTesting
    public Supplier<Long> getTimeMsDelaySupplier() {
        return this._timeMsDelaySupplier;
    }

    @VisibleForTesting
    public void setClock(Clock clock) {
        this._clock = clock;
    }

    @VisibleForTesting
    public Clock getClock() {
        return this._clock;
    }
}

