/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.recordtransformer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.segment.local.function.FunctionEvaluator;
import org.apache.pinot.segment.local.function.FunctionEvaluatorFactory;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.ingestion.TransformConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.recordtransformer.RecordTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionTransformer
implements RecordTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExpressionTransformer.class);
    @VisibleForTesting
    final LinkedHashMap<String, FunctionEvaluator> _expressionEvaluators = new LinkedHashMap();
    private final boolean _continueOnError;

    public ExpressionTransformer(TableConfig tableConfig, Schema schema) {
        HashMap<String, FunctionEvaluator> expressionEvaluators = new HashMap<String, FunctionEvaluator>();
        boolean bl = this._continueOnError = tableConfig.getIngestionConfig() != null && tableConfig.getIngestionConfig().isContinueOnError();
        if (tableConfig.getIngestionConfig() != null && tableConfig.getIngestionConfig().getTransformConfigs() != null) {
            for (TransformConfig transformConfig : tableConfig.getIngestionConfig().getTransformConfigs()) {
                FunctionEvaluator previous = expressionEvaluators.put(transformConfig.getColumnName(), FunctionEvaluatorFactory.getExpressionEvaluator(transformConfig.getTransformFunction()));
                Preconditions.checkState((previous == null ? 1 : 0) != 0, (String)"Cannot set more than one ingestion transform function on column: %s.", (Object)transformConfig.getColumnName());
            }
        }
        for (FieldSpec fieldSpec : schema.getAllFieldSpecs()) {
            FunctionEvaluator functionEvaluator;
            String fieldName = fieldSpec.getName();
            if (fieldSpec.isVirtualColumn() || expressionEvaluators.containsKey(fieldName) || (functionEvaluator = FunctionEvaluatorFactory.getExpressionEvaluator(fieldSpec)) == null) continue;
            expressionEvaluators.put(fieldName, functionEvaluator);
        }
        HashSet<String> discoveredNames = new HashSet<String>();
        for (Map.Entry entry : expressionEvaluators.entrySet()) {
            String columnName = (String)entry.getKey();
            if (this._expressionEvaluators.containsKey(columnName)) continue;
            this.topologicalSort(columnName, expressionEvaluators, discoveredNames);
        }
    }

    private void topologicalSort(String column, Map<String, FunctionEvaluator> expressionEvaluators, Set<String> discoveredNames) {
        FunctionEvaluator functionEvaluator = expressionEvaluators.get(column);
        if (functionEvaluator == null) {
            return;
        }
        if (discoveredNames.add(column)) {
            List<String> arguments = functionEvaluator.getArguments();
            for (String arg : arguments) {
                if (this._expressionEvaluators.containsKey(arg)) continue;
                this.topologicalSort(arg, expressionEvaluators, discoveredNames);
            }
        } else {
            throw new IllegalStateException("Expression cycle found for column '" + column + "' in Ingestion Transform Function definitions.");
        }
        this._expressionEvaluators.put(column, functionEvaluator);
        discoveredNames.remove(column);
    }

    public boolean isNoOp() {
        return this._expressionEvaluators.isEmpty();
    }

    public Set<String> getInputColumns() {
        if (this._expressionEvaluators.isEmpty()) {
            return Set.of();
        }
        HashSet<String> inputColumns = new HashSet<String>();
        for (Map.Entry<String, FunctionEvaluator> entry : this._expressionEvaluators.entrySet()) {
            inputColumns.addAll(entry.getValue().getArguments());
            inputColumns.add(entry.getKey());
        }
        return inputColumns;
    }

    public GenericRow transform(GenericRow record) {
        for (Map.Entry<String, FunctionEvaluator> entry : this._expressionEvaluators.entrySet()) {
            String column = entry.getKey();
            FunctionEvaluator transformFunctionEvaluator = entry.getValue();
            Object existingValue = record.getValue(column);
            if (existingValue == null) {
                try {
                    record.putValue(column, transformFunctionEvaluator.evaluate(record));
                }
                catch (Exception e) {
                    if (!this._continueOnError) {
                        throw new RuntimeException("Caught exception while evaluation transform function for column: " + column, e);
                    }
                    LOGGER.debug("Caught exception while evaluation transform function for column: {}", (Object)column, (Object)e);
                    record.putValue("$INCOMPLETE_RECORD_KEY$", (Object)true);
                }
                continue;
            }
            if (!existingValue.getClass().isArray() && !(existingValue instanceof Collections) && !(existingValue instanceof Map)) continue;
            try {
                Object transformedValue = transformFunctionEvaluator.evaluate(record);
                if (this.isTypeCompatible(existingValue, transformedValue)) continue;
                record.putValue(column, transformedValue);
            }
            catch (Exception e) {
                LOGGER.debug("Caught exception while evaluation transform function for column: {}", (Object)column, (Object)e);
            }
        }
        return record;
    }

    private boolean isTypeCompatible(Object existingValue, Object transformedValue) {
        if (transformedValue.getClass() == existingValue.getClass()) {
            return true;
        }
        if (transformedValue instanceof Collections && existingValue instanceof Collections) {
            return true;
        }
        if (transformedValue instanceof Map && existingValue instanceof Map) {
            return true;
        }
        return transformedValue.getClass().isArray() && existingValue.getClass().isArray();
    }
}

