/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.recordtransformer.enricher.function;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.auto.service.AutoService;
import java.io.IOException;
import org.apache.pinot.segment.local.function.FunctionEvaluatorFactory;
import org.apache.pinot.segment.local.recordtransformer.enricher.function.CustomFunctionEnricher;
import org.apache.pinot.segment.local.recordtransformer.enricher.function.CustomFunctionEnricherConfig;
import org.apache.pinot.spi.recordtransformer.enricher.RecordEnricher;
import org.apache.pinot.spi.recordtransformer.enricher.RecordEnricherFactory;
import org.apache.pinot.spi.recordtransformer.enricher.RecordEnricherValidationConfig;
import org.apache.pinot.spi.utils.JsonUtils;

@AutoService(value={RecordEnricherFactory.class})
public class CustomFunctionEnricherFactory
implements RecordEnricherFactory {
    private static final String TYPE = "generateColumn";

    public String getEnricherType() {
        return TYPE;
    }

    public RecordEnricher createEnricher(JsonNode enricherProps) throws IOException {
        return new CustomFunctionEnricher(enricherProps);
    }

    public void validateEnrichmentConfig(JsonNode enricherProps, RecordEnricherValidationConfig validationConfig) {
        try {
            CustomFunctionEnricherConfig config = (CustomFunctionEnricherConfig)JsonUtils.jsonNodeToObject((JsonNode)enricherProps, CustomFunctionEnricherConfig.class);
            if (!validationConfig.isGroovyDisabled()) {
                return;
            }
            for (String function : config.getFieldToFunctionMap().values()) {
                if (!FunctionEvaluatorFactory.isGroovyExpression(function)) continue;
                throw new IllegalArgumentException("Groovy expression is not allowed for enrichment");
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to parse custom function enricher config", e);
        }
    }
}

