/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator;

import com.google.common.collect.ImmutableList;
import java.util.Random;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.utils.JsonUtils;

public class Fixtures {
    public static final int MAX_ROWS_IN_SEGMENT = 250000;
    public static final long MAX_TIME_FOR_SEGMENT_CLOSE_MS = 64368000L;
    public static final String TOPIC_NAME = "someTopic";
    public static final String TABLE_CONFIG_JSON_TEMPLATE = "{  \"metadata\":{},  \"segmentsConfig\":{    \"replicasPerPartition\":\"3\",    \"replication\":\"3\",    \"replicationNumber\":3,    \"retentionTimeUnit\":\"DAYS\",    \"retentionTimeValue\":\"3\",    \"schemaName\":\"testSchema\",    \"segmentAssignmentStrategy\":\"BalanceNumSegmentAssignmentStrategy\",    \"segmentPushFrequency\":\"daily\",    \"segmentPushType\":\"APPEND\",    \"timeColumnName\":\"minutesSinceEpoch\",    \"timeType\":\"MINUTES\"  },  \"tableIndexConfig\":{    \"invertedIndexColumns\":[],    \"lazyLoad\":\"false\",    \"loadMode\":\"HEAP\",    \"segmentFormatVersion\":null,    \"sortedColumn\":[],    \"streamConfigs\":{      \"realtime.segment.flush.threshold.rows\":\"250000\",      \"realtime.segment.flush.threshold.time\":\"64368000\",      \"stream.fakeStream.broker.list\":\"broker:7777\",      \"stream.fakeStream.consumer.prop.auto.offset.reset\":\"smallest\",      \"stream.fakeStream.consumer.type\":\"simple\",      \"stream.fakeStream.consumer.factory.class.name\":\"%s\",      \"stream.fakeStream.decoder.class.name\":\"%s\",      \"stream.fakeStream.decoder.prop.schema.registry.rest.url\":\"http://1.2.3.4:1766/schemas\",      \"stream.fakeStream.decoder.prop.schema.registry.schema.name\":\"UnknownSchema\",      \"stream.fakeStream.hlc.zk.connect.string\":\"zoo:2181/kafka-queuing\",      \"stream.fakeStream.topic.name\":\"someTopic\",      \"stream.fakeStream.zk.broker.url\":\"kafka-broker:2181/kafka-queuing\",      \"streamType\":\"fakeStream\"    }  },  \"tableName\":\"Coffee_REALTIME\",  \"tableType\":\"realtime\",  \"tenants\":{    \"broker\":\"shared\",    \"server\":\"server-1\"  },  \"upsertConfig\":{    \"mode\":\"FULL\"  }}";
    public static final String SCHEMA_JSON = "{  \"schemaName\":\"testSchema\",  \"metricFieldSpecs\":[{\"name\":\"m\",\"dataType\":\"LONG\"}],  \"dimensionFieldSpecs\":[{\"name\":\"d\",\"dataType\":\"STRING\",\"singleValueField\":true}],  \"timeFieldSpec\":{    \"incomingGranularitySpec\":{      \"dataType\":\"LONG\",      \"timeType\":\"MINUTES\",      \"name\":\"minutesSinceEpoch\"    },    \"defaultNullValue\":12345  },  \"primaryKeyColumns\": [\"event_id\"]}";

    private Fixtures() {
    }

    public static TableConfig createTableConfig(String consumerFactoryClass, String decoderFactoryClass) throws Exception {
        return (TableConfig)JsonUtils.stringToObject((String)String.format(TABLE_CONFIG_JSON_TEMPLATE, consumerFactoryClass, decoderFactoryClass), TableConfig.class);
    }

    public static Schema createSchema() throws Exception {
        return Schema.fromString((String)SCHEMA_JSON);
    }

    public static GenericRow createSingleRow(long randomSeed) {
        Random rand = new Random(randomSeed);
        int colValue = rand.nextInt(Integer.MAX_VALUE);
        GenericRow retVal = new GenericRow();
        retVal.putValue("m", (Object)colValue);
        int nextVal = rand.nextInt(Integer.MAX_VALUE);
        retVal.putValue("d", (Object)(nextVal + "_d_" + nextVal));
        retVal.putValue("event_id", (Object)rand.nextInt(Integer.MAX_VALUE));
        return retVal;
    }

    public static GenericRow createInvalidSingleRow(long randomSeed) {
        Random rand = new Random(randomSeed);
        int colValue = rand.nextInt(Integer.MAX_VALUE);
        GenericRow retVal = new GenericRow();
        retVal.putValue("m", (Object)(colValue + "_d_" + colValue));
        int nextVal = rand.nextInt(Integer.MAX_VALUE);
        retVal.putValue("d", (Object)(nextVal + "_d_" + nextVal));
        retVal.putValue("event_id", (Object)rand.nextInt(Integer.MAX_VALUE));
        return retVal;
    }

    public static GenericRow createMultipleRow(long randomSeed) {
        Random rand = new Random(randomSeed);
        GenericRow firstRow = Fixtures.createSingleRow(randomSeed);
        GenericRow secondRow = Fixtures.createSingleRow(rand.nextInt(Integer.MAX_VALUE));
        GenericRow thirdRow = Fixtures.createSingleRow(rand.nextInt(Integer.MAX_VALUE));
        GenericRow retVal = new GenericRow();
        retVal.putValue("$MULTIPLE_RECORDS_KEY$", (Object)ImmutableList.of((Object)firstRow, (Object)secondRow, (Object)thirdRow));
        return retVal;
    }

    public static GenericRow createMultipleRowPartialFailure(long randomSeed) {
        Random rand = new Random(randomSeed);
        GenericRow firstRow = Fixtures.createSingleRow(randomSeed);
        GenericRow secondRow = Fixtures.createInvalidSingleRow(rand.nextInt(Integer.MAX_VALUE));
        GenericRow thirdRow = Fixtures.createSingleRow(rand.nextInt(Integer.MAX_VALUE));
        GenericRow retVal = new GenericRow();
        retVal.putValue("$MULTIPLE_RECORDS_KEY$", (Object)ImmutableList.of((Object)firstRow, (Object)secondRow, (Object)thirdRow));
        return retVal;
    }
}

