/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.fwd;

import com.yscope.clp.compressorfrontend.EncodedMessage;
import com.yscope.clp.compressorfrontend.MessageEncoder;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.StandardOpenOption;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.segment.local.io.util.PinotDataBitSet;
import org.apache.pinot.segment.local.io.writer.impl.FixedBitMVForwardIndexWriter;
import org.apache.pinot.segment.local.io.writer.impl.FixedBitSVForwardIndexWriter;
import org.apache.pinot.segment.local.segment.creator.impl.SegmentDictionaryCreator;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.MultiValueFixedByteRawIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.stats.CLPStatsProvider;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.creator.ColumnStatistics;
import org.apache.pinot.segment.spi.index.creator.ForwardIndexCreator;
import org.apache.pinot.spi.data.FieldSpec;

public class CLPForwardIndexCreatorV1
implements ForwardIndexCreator {
    public static final byte[] MAGIC_BYTES = "CLP.v1".getBytes(StandardCharsets.UTF_8);
    private final String _column;
    private final int _numDocs;
    private final File _intermediateFilesDir;
    private final FileChannel _dataFile;
    private final ByteBuffer _fileBuffer;
    private final EncodedMessage _clpEncodedMessage;
    private final MessageEncoder _clpMessageEncoder;
    private final CLPStatsProvider.CLPStats _clpStats;
    private final SegmentDictionaryCreator _logTypeDictCreator;
    private final SegmentDictionaryCreator _dictVarsDictCreator;
    private final FixedBitSVForwardIndexWriter _logTypeFwdIndexWriter;
    private final FixedBitMVForwardIndexWriter _dictVarsFwdIndexWriter;
    private final MultiValueFixedByteRawIndexCreator _encodedVarsFwdIndexWriter;
    private final File _logTypeDictFile;
    private final File _dictVarsDictFile;
    private final File _logTypeFwdIndexFile;
    private final File _dictVarsFwdIndexFile;
    private final File _encodedVarsFwdIndexFile;

    public CLPForwardIndexCreatorV1(File baseIndexDir, String column, int numDocs, ColumnStatistics columnStatistics) throws IOException {
        this._column = column;
        this._numDocs = numDocs;
        this._intermediateFilesDir = new File(baseIndexDir, column + ".sv.raw.fwd.clp.tmp");
        if (this._intermediateFilesDir.exists()) {
            FileUtils.cleanDirectory((File)this._intermediateFilesDir);
        } else {
            FileUtils.forceMkdir((File)this._intermediateFilesDir);
        }
        this._dataFile = new RandomAccessFile(new File(baseIndexDir, column + ".sv.raw.fwd"), "rw").getChannel();
        this._fileBuffer = this._dataFile.map(FileChannel.MapMode.READ_WRITE, 0L, Integer.MAX_VALUE);
        CLPStatsProvider statsCollector = (CLPStatsProvider)columnStatistics;
        this._clpStats = statsCollector.getCLPStats();
        this._logTypeDictFile = new File(this._intermediateFilesDir, this._column + "_clp_logtype.dict");
        this._logTypeDictCreator = new SegmentDictionaryCreator(this._column + "_clp_logtype.dict", FieldSpec.DataType.STRING, this._logTypeDictFile, true);
        this._logTypeDictCreator.build(this._clpStats.getSortedLogTypeValues());
        this._dictVarsDictFile = new File(this._intermediateFilesDir, this._column + "_clp_dictvars.dict");
        this._dictVarsDictCreator = new SegmentDictionaryCreator(this._column + "_clp_dictvars.dict", FieldSpec.DataType.STRING, this._dictVarsDictFile, true);
        this._dictVarsDictCreator.build(this._clpStats.getSortedDictVarValues());
        this._logTypeFwdIndexFile = new File(this._intermediateFilesDir, column + "_clp_logtype.fwd");
        this._logTypeFwdIndexWriter = new FixedBitSVForwardIndexWriter(this._logTypeFwdIndexFile, numDocs, PinotDataBitSet.getNumBitsPerValue(this._clpStats.getSortedLogTypeValues().length - 1));
        this._dictVarsFwdIndexFile = new File(this._intermediateFilesDir, column + "_clp_dictvars.fwd");
        this._dictVarsFwdIndexWriter = new FixedBitMVForwardIndexWriter(this._dictVarsFwdIndexFile, numDocs, this._clpStats.getTotalNumberOfDictVars(), PinotDataBitSet.getNumBitsPerValue(this._clpStats.getSortedDictVarValues().length - 1));
        this._encodedVarsFwdIndexFile = new File(this._intermediateFilesDir, column + "_clp_encodedvars.fwd");
        this._encodedVarsFwdIndexWriter = new MultiValueFixedByteRawIndexCreator(this._encodedVarsFwdIndexFile, ChunkCompressionType.LZ4, numDocs, FieldSpec.DataType.LONG, this._clpStats.getMaxNumberOfEncodedVars(), false, 4);
        this._clpStats.clear();
        this._clpEncodedMessage = new EncodedMessage();
        this._clpMessageEncoder = new MessageEncoder("com.yscope.clp.VariablesSchemaV2", "com.yscope.clp.VariableEncodingMethodsV1");
    }

    public boolean isDictionaryEncoded() {
        return false;
    }

    public boolean isSingleValue() {
        return true;
    }

    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.STRING;
    }

    public void putBigDecimal(BigDecimal value) {
        throw new UnsupportedOperationException("Non string types are not supported");
    }

    public void putString(String value) {
        Long[] encodedVars;
        String[] dictVars;
        String logtype;
        try {
            this._clpMessageEncoder.encodeMessage(value, this._clpEncodedMessage);
            logtype = this._clpEncodedMessage.getLogTypeAsString();
            dictVars = this._clpEncodedMessage.getDictionaryVarsAsStrings();
            encodedVars = this._clpEncodedMessage.getEncodedVarsAsBoxedLongs();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to encode message: " + value, e);
        }
        if (logtype == null) {
            logtype = "null";
        }
        if (dictVars == null) {
            dictVars = new String[]{"null"};
        }
        if (encodedVars == null) {
            encodedVars = new Long[]{FieldSpec.DEFAULT_DIMENSION_NULL_VALUE_OF_LONG};
        }
        this.addCLPFields(logtype, dictVars, encodedVars);
    }

    private void addCLPFields(String logtype, String[] dictVars, Long[] encodedVars) {
        int logTypeDictId = this._logTypeDictCreator.indexOfSV(logtype);
        int[] dictVarDictIds = this._dictVarsDictCreator.indexOfMV(dictVars);
        this._logTypeFwdIndexWriter.putDictId(logTypeDictId);
        this._dictVarsFwdIndexWriter.putDictIds(dictVarDictIds);
        long[] encodedVarsUnboxed = new long[encodedVars.length];
        for (int i = 0; i < encodedVars.length; ++i) {
            encodedVarsUnboxed[i] = encodedVars[i];
        }
        this._encodedVarsFwdIndexWriter.putLongMV(encodedVarsUnboxed);
    }

    public void seal() throws IOException {
        this._logTypeDictCreator.seal();
        this._logTypeDictCreator.close();
        this._dictVarsDictCreator.seal();
        this._dictVarsDictCreator.close();
        this._logTypeFwdIndexWriter.close();
        this._dictVarsFwdIndexWriter.close();
        this._encodedVarsFwdIndexWriter.close();
        long totalSize = 0L;
        this._fileBuffer.put(MAGIC_BYTES);
        totalSize += (long)MAGIC_BYTES.length;
        this._fileBuffer.putInt(1);
        totalSize += 4L;
        this._fileBuffer.putInt(this._clpStats.getTotalNumberOfDictVars());
        totalSize += 4L;
        this._fileBuffer.putInt(this._logTypeDictCreator.getNumBytesPerEntry());
        totalSize += 4L;
        this._fileBuffer.putInt(this._dictVarsDictCreator.getNumBytesPerEntry());
        totalSize += 4L;
        this._fileBuffer.putInt((int)this._logTypeDictFile.length());
        totalSize += 4L;
        this._fileBuffer.putInt((int)this._dictVarsDictFile.length());
        totalSize += 4L;
        this._fileBuffer.putInt((int)this._logTypeFwdIndexFile.length());
        totalSize += 4L;
        this._fileBuffer.putInt((int)this._dictVarsFwdIndexFile.length());
        totalSize += 4L;
        this._fileBuffer.putInt((int)this._encodedVarsFwdIndexFile.length());
        totalSize += 4L;
        this.copyFileIntoBuffer(this._logTypeDictFile);
        totalSize += this._logTypeDictFile.length();
        this.copyFileIntoBuffer(this._dictVarsDictFile);
        totalSize += this._dictVarsDictFile.length();
        this.copyFileIntoBuffer(this._logTypeFwdIndexFile);
        totalSize += this._logTypeFwdIndexFile.length();
        this.copyFileIntoBuffer(this._dictVarsFwdIndexFile);
        totalSize += this._dictVarsFwdIndexFile.length();
        this.copyFileIntoBuffer(this._encodedVarsFwdIndexFile);
        this._dataFile.truncate(totalSize += this._encodedVarsFwdIndexFile.length());
    }

    private void copyFileIntoBuffer(File file) throws IOException {
        try (FileChannel from = FileChannel.open(file.toPath(), StandardOpenOption.READ);){
            this._fileBuffer.put(from.map(FileChannel.MapMode.READ_ONLY, 0L, file.length()));
        }
    }

    public void close() throws IOException {
        this._dataFile.close();
        FileUtils.deleteDirectory((File)this._intermediateFilesDir);
    }
}

