/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.inv;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import org.apache.pinot.segment.local.segment.creator.impl.inv.MmapFileWriter;
import org.apache.pinot.segment.local.utils.FPOrdering;
import org.apache.pinot.segment.spi.index.creator.CombinedInvertedIndexCreator;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.RangeBitmap;

public class BitSlicedRangeIndexCreator
implements CombinedInvertedIndexCreator {
    public static final int VERSION = 2;
    private final RangeBitmap.Appender _appender;
    private final File _rangeIndexFile;
    private final long _minValue;
    private final FieldSpec.DataType _valueType;

    private BitSlicedRangeIndexCreator(File indexDir, FieldSpec fieldSpec, long minValue, long maxValue, FieldSpec.DataType valueType) {
        Preconditions.checkArgument((boolean)fieldSpec.isSingleValueField(), (Object)"MV columns not supported");
        this._rangeIndexFile = new File(indexDir, fieldSpec.getName() + ".bitmap.range");
        this._appender = RangeBitmap.appender((long)maxValue);
        this._minValue = minValue;
        this._valueType = valueType;
    }

    public BitSlicedRangeIndexCreator(File indexDir, FieldSpec fieldSpec, int cardinality) {
        this(indexDir, fieldSpec, 0L, cardinality - 1, fieldSpec.getDataType());
    }

    public BitSlicedRangeIndexCreator(File indexDir, FieldSpec fieldSpec, Comparable<?> minValue, Comparable<?> maxValue) {
        this(indexDir, fieldSpec, BitSlicedRangeIndexCreator.minValue(fieldSpec, minValue), BitSlicedRangeIndexCreator.maxValue(fieldSpec, minValue, maxValue), fieldSpec.getDataType());
    }

    public FieldSpec.DataType getDataType() {
        return this._valueType;
    }

    public void add(int value) {
        this._appender.add((long)value - this._minValue);
    }

    public void add(int[] values, int length) {
        throw new UnsupportedOperationException("MV not supported");
    }

    public void add(long value) {
        this._appender.add(value - this._minValue);
    }

    public void add(long[] values, int length) {
        throw new UnsupportedOperationException("MV not supported");
    }

    public void add(float value) {
        this._appender.add(FPOrdering.ordinalOf(value));
    }

    public void add(float[] values, int length) {
        throw new UnsupportedOperationException("MV not supported");
    }

    public void add(double value) {
        this._appender.add(FPOrdering.ordinalOf(value));
    }

    public void add(double[] values, int length) {
        throw new UnsupportedOperationException("MV not supported");
    }

    public void seal() throws IOException {
        int headerSize = 12;
        int serializedSize = this._appender.serializedSizeInBytes();
        try (MmapFileWriter writer = new MmapFileWriter(this._rangeIndexFile, headerSize + serializedSize);){
            writer.write(buf -> {
                buf.putInt(2);
                buf.putLong(this._minValue);
                this._appender.serialize(buf);
            });
        }
        this._appender.clear();
    }

    public void close() throws IOException {
    }

    private static long maxValue(FieldSpec fieldSpec, Comparable<?> minValue, Comparable<?> maxValue) {
        FieldSpec.DataType storedType = fieldSpec.getDataType().getStoredType();
        if (storedType == FieldSpec.DataType.INT || storedType == FieldSpec.DataType.LONG) {
            return ((Number)((Object)maxValue)).longValue() - ((Number)((Object)minValue)).longValue();
        }
        if (storedType == FieldSpec.DataType.FLOAT) {
            return 0xFFFFFFFFL;
        }
        if (storedType == FieldSpec.DataType.DOUBLE) {
            return -1L;
        }
        throw new IllegalArgumentException("Unsupported data type: " + fieldSpec.getDataType());
    }

    private static long minValue(FieldSpec fieldSpec, Comparable<?> minValue) {
        FieldSpec.DataType storedType = fieldSpec.getDataType().getStoredType();
        if (storedType == FieldSpec.DataType.INT || storedType == FieldSpec.DataType.LONG) {
            return ((Number)((Object)minValue)).longValue();
        }
        return 0L;
    }
}

