/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.stats;

import com.google.common.annotations.VisibleForTesting;
import com.yscope.clp.compressorfrontend.EncodedMessage;
import com.yscope.clp.compressorfrontend.MessageEncoder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Set;
import org.apache.pinot.segment.local.segment.creator.impl.stats.AbstractColumnStatisticsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.CLPStatsProvider;
import org.apache.pinot.segment.spi.creator.StatsCollectorConfig;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.data.FieldSpec;

public class StringColumnPreIndexStatsCollector
extends AbstractColumnStatisticsCollector
implements CLPStatsProvider {
    private Set<String> _values = new ObjectOpenHashSet(1000);
    private int _minLength = Integer.MAX_VALUE;
    private int _maxLength = 0;
    private int _maxRowLength = 0;
    private String[] _sortedValues;
    private boolean _sealed = false;
    private CLPStatsCollector _clpStatsCollector;

    public StringColumnPreIndexStatsCollector(String column, StatsCollectorConfig statsCollectorConfig) {
        super(column, statsCollectorConfig);
        if (this._fieldConfig != null && this._fieldConfig.getCompressionCodec() == FieldConfig.CompressionCodec.CLP) {
            this._clpStatsCollector = new CLPStatsCollector();
        }
    }

    @Override
    public void collect(Object entry) {
        assert (!this._sealed);
        if (entry instanceof Object[]) {
            Object[] values = (Object[])entry;
            int rowLength = 0;
            for (Object obj : values) {
                String value = (String)obj;
                this._values.add(value);
                if (this._clpStatsCollector != null) {
                    this._clpStatsCollector.collect(value);
                }
                int length = value.getBytes(StandardCharsets.UTF_8).length;
                this._minLength = Math.min(this._minLength, length);
                this._maxLength = Math.max(this._maxLength, length);
                rowLength += length;
            }
            this._maxNumberOfMultiValues = Math.max(this._maxNumberOfMultiValues, values.length);
            this._maxRowLength = Math.max(this._maxRowLength, rowLength);
            this.updateTotalNumberOfEntries(values);
        } else {
            String value = (String)entry;
            this.addressSorted((Comparable)((Object)value));
            if (this._clpStatsCollector != null) {
                this._clpStatsCollector.collect(value);
            }
            if (this._values.add(value)) {
                if (this.isPartitionEnabled()) {
                    this.updatePartition(value);
                }
                int valueLength = value.getBytes(StandardCharsets.UTF_8).length;
                this._minLength = Math.min(this._minLength, valueLength);
                this._maxRowLength = this._maxLength = Math.max(this._maxLength, valueLength);
            }
            ++this._totalNumberOfEntries;
        }
    }

    @Override
    public CLPStatsProvider.CLPStats getCLPStats() {
        if (this._sealed) {
            return this._clpStatsCollector.getCLPStats();
        }
        throw new IllegalStateException("The collector must be sealed before calling getCLPStats");
    }

    public String getMinValue() {
        if (this._sealed) {
            return this._sortedValues[0];
        }
        throw new IllegalStateException("you must seal the collector first before asking for min value");
    }

    public String getMaxValue() {
        if (this._sealed) {
            return this._sortedValues[this._sortedValues.length - 1];
        }
        throw new IllegalStateException("you must seal the collector first before asking for max value");
    }

    public Object[] getUniqueValuesSet() {
        if (this._sealed) {
            return this._sortedValues;
        }
        throw new IllegalStateException("you must seal the collector first before asking for unique values set");
    }

    @Override
    public int getLengthOfLargestElement() {
        return this._maxLength;
    }

    public int getMaxRowLengthInBytes() {
        return this._maxRowLength;
    }

    public int getCardinality() {
        return this._sealed ? this._sortedValues.length : this._values.size();
    }

    @Override
    public void seal() {
        if (!this._sealed) {
            this._sortedValues = this._values.toArray(new String[0]);
            this._values = null;
            Arrays.sort(this._sortedValues);
            if (this._clpStatsCollector != null) {
                this._clpStatsCollector.seal();
            }
            this._sealed = true;
        }
    }

    @VisibleForTesting
    public static class CLPStatsCollector {
        private final EncodedMessage _clpEncodedMessage;
        private final MessageEncoder _clpMessageEncoder;
        int _totalNumberOfDictVars = 0;
        int _totalNumberOfEncodedVars = 0;
        int _maxNumberOfEncodedVars = 0;
        private Set<String> _logTypes = new ObjectOpenHashSet(1000);
        private Set<String> _dictVars = new ObjectOpenHashSet(1000);
        private CLPStatsProvider.CLPStats _clpStats;

        public CLPStatsCollector() {
            this._clpEncodedMessage = new EncodedMessage();
            this._clpMessageEncoder = new MessageEncoder("com.yscope.clp.VariablesSchemaV2", "com.yscope.clp.VariableEncodingMethodsV1");
        }

        public void collect(String value) {
            Long[] encodedVars;
            String[] dictVars;
            String logType;
            try {
                this._clpMessageEncoder.encodeMessage(value, this._clpEncodedMessage);
                logType = this._clpEncodedMessage.getLogTypeAsString();
                dictVars = this._clpEncodedMessage.getDictionaryVarsAsStrings();
                encodedVars = this._clpEncodedMessage.getEncodedVarsAsBoxedLongs();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to encode message: " + value, e);
            }
            if (logType == null) {
                logType = "null";
            }
            if (dictVars == null) {
                dictVars = new String[]{"null"};
            }
            if (encodedVars == null) {
                encodedVars = new Long[]{FieldSpec.DEFAULT_DIMENSION_NULL_VALUE_OF_LONG};
            }
            this._logTypes.add(logType);
            this._dictVars.addAll(Arrays.asList(dictVars));
            this._totalNumberOfDictVars += dictVars.length;
            this._totalNumberOfEncodedVars += encodedVars.length;
            this._maxNumberOfEncodedVars = Math.max(this._maxNumberOfEncodedVars, encodedVars.length);
        }

        public void seal() {
            Object[] sortedLogTypeValues = this._logTypes.toArray(new String[0]);
            this._logTypes = null;
            Arrays.sort(sortedLogTypeValues);
            Object[] sortedDictVarValues = this._dictVars.toArray(new String[0]);
            this._dictVars = null;
            Arrays.sort(sortedDictVarValues);
            this._clpStats = new CLPStatsProvider.CLPStats((String[])sortedLogTypeValues, (String[])sortedDictVarValues, this._totalNumberOfDictVars, this._totalNumberOfEncodedVars, this._maxNumberOfEncodedVars);
        }

        public CLPStatsProvider.CLPStats getCLPStats() {
            return this._clpStats;
        }
    }
}

