/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.vector;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.pinot.segment.local.segment.creator.impl.vector.XKnnFloatVectorField;
import org.apache.pinot.segment.local.segment.store.VectorIndexUtils;
import org.apache.pinot.segment.spi.index.creator.VectorIndexConfig;
import org.apache.pinot.segment.spi.index.creator.VectorIndexCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HnswVectorIndexCreator
implements VectorIndexCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(HnswVectorIndexCreator.class);
    public static final String VECTOR_INDEX_DOC_ID_COLUMN_NAME = "DocID";
    private final Directory _indexDirectory;
    private final IndexWriter _indexWriter;
    private final String _vectorColumn;
    private final VectorSimilarityFunction _vectorSimilarityFunction;
    private final int _vectorDimension;
    private int _nextDocId = 0;

    public HnswVectorIndexCreator(String column, File segmentIndexDir, VectorIndexConfig vectorIndexConfig) {
        this._vectorColumn = column;
        this._vectorDimension = vectorIndexConfig.getVectorDimension();
        this._vectorSimilarityFunction = VectorIndexUtils.toSimilarityFunction(vectorIndexConfig.getVectorDistanceFunction());
        try {
            File indexFile = new File(segmentIndexDir, this._vectorColumn + ".vector.v912.hnsw.index");
            this._indexDirectory = FSDirectory.open((Path)indexFile.toPath());
            LOGGER.info("Creating HNSW index for column: {} at path: {} with {} for segment: {}", new Object[]{column, indexFile.getAbsolutePath(), vectorIndexConfig.getProperties(), segmentIndexDir.getAbsolutePath()});
            this._indexWriter = new IndexWriter(this._indexDirectory, VectorIndexUtils.getIndexWriterConfig(vectorIndexConfig));
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while instantiating the HnswVectorIndexCreator for column: " + column, e);
        }
    }

    public void add(@Nonnull Object[] values, @Nullable int[] dictIds) {
        float[] floatValues = new float[this._vectorDimension];
        for (int i = 0; i < values.length; ++i) {
            floatValues[i] = ((Float)values[i]).floatValue();
        }
        this.add(floatValues);
    }

    public void add(float[] document) {
        Document docToIndex = new Document();
        XKnnFloatVectorField xKnnFloatVectorField = new XKnnFloatVectorField(this._vectorColumn, document, this._vectorSimilarityFunction);
        docToIndex.add((IndexableField)xKnnFloatVectorField);
        docToIndex.add((IndexableField)new StoredField(VECTOR_INDEX_DOC_ID_COLUMN_NAME, this._nextDocId++));
        try {
            this._indexWriter.addDocument((Iterable)docToIndex);
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while adding a new document to the HNSW index for column: " + this._vectorColumn, e);
        }
    }

    public void seal() {
        try {
            LOGGER.info("Sealing HNSW index for column: {}", (Object)this._vectorColumn);
            this._indexWriter.forceMerge(1);
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while sealing the HNSW index for column: " + this._vectorColumn, e);
        }
    }

    public void close() throws IOException {
        try {
            this._indexWriter.close();
            this._indexDirectory.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while closing the HNSW index for column: " + this._vectorColumn, e);
        }
    }
}

