/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.dictionary;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pinot.spi.utils.FALFInterner;

public class DictionaryInternerHolder {
    private static final DictionaryInternerHolder INSTANCE = new DictionaryInternerHolder();
    private Map<String, FALFInterner<String>> _strInternerInfoMap = new ConcurrentHashMap<String, FALFInterner<String>>();
    private Map<String, FALFInterner<byte[]>> _byteInternerInfoMap = new ConcurrentHashMap<String, FALFInterner<byte[]>>();

    private DictionaryInternerHolder() {
    }

    public static DictionaryInternerHolder getInstance() {
        return INSTANCE;
    }

    public FALFInterner<String> getStrInterner(String columnIdentifier, int capacity) {
        return this._strInternerInfoMap.computeIfAbsent(columnIdentifier, k -> new FALFInterner(capacity));
    }

    public FALFInterner<byte[]> getByteInterner(String columnIdentifier, int capacity) {
        return this._byteInternerInfoMap.computeIfAbsent(columnIdentifier, k -> new FALFInterner(capacity, Arrays::hashCode));
    }

    public String createIdentifier(String tableName, String colName) {
        return tableName + ":" + colName;
    }
}

