/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.segment.local.segment.creator.impl.SegmentDictionaryCreator;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.MultiValueVarByteRawIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.stats.AbstractColumnStatisticsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.BigDecimalColumnPreIndexStatsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.BytesColumnPredIndexStatsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.DoubleColumnPreIndexStatsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.FloatColumnPreIndexStatsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.IntColumnPreIndexStatsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.LongColumnPreIndexStatsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.MapColumnPreIndexStatsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.StringColumnPreIndexStatsCollector;
import org.apache.pinot.segment.local.segment.index.dictionary.DictionaryIndexType;
import org.apache.pinot.segment.local.segment.index.forward.ForwardIndexType;
import org.apache.pinot.segment.local.segment.index.loader.BaseIndexHandler;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.LoaderUtils;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentColumnReader;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.V1Constants;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.compression.DictIdCompressionType;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.creator.StatsCollectorConfig;
import org.apache.pinot.segment.spi.index.DictionaryIndexConfig;
import org.apache.pinot.segment.spi.index.FieldIndexConfigs;
import org.apache.pinot.segment.spi.index.FieldIndexConfigsUtil;
import org.apache.pinot.segment.spi.index.ForwardIndexConfig;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.RangeIndexConfig;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.creator.ForwardIndexCreator;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.segment.spi.utils.SegmentMetadataUtils;
import org.apache.pinot.spi.config.table.IndexConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardIndexHandler
extends BaseIndexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ForwardIndexHandler.class);
    private static final List<IndexType<?, ?, ?>> DICTIONARY_BASED_INDEXES_TO_REWRITE = Arrays.asList(StandardIndexes.range(), StandardIndexes.fst(), StandardIndexes.inverted());
    private final Schema _schema;

    @VisibleForTesting
    public ForwardIndexHandler(SegmentDirectory segmentDirectory, IndexLoadingConfig indexLoadingConfig, Schema schema) {
        this(segmentDirectory, indexLoadingConfig.getFieldIndexConfigByColName(), schema, indexLoadingConfig.getTableConfig());
    }

    public ForwardIndexHandler(SegmentDirectory segmentDirectory, Map<String, FieldIndexConfigs> fieldIndexConfigs, Schema schema, @Nullable TableConfig tableConfig) {
        super(segmentDirectory, fieldIndexConfigs, tableConfig);
        this._schema = schema;
    }

    public boolean needUpdateIndices(SegmentDirectory.Reader segmentReader) throws Exception {
        Map<String, List<Operation>> columnOperationsMap = this.computeOperations(segmentReader);
        return !columnOperationsMap.isEmpty();
    }

    public void updateIndices(SegmentDirectory.Writer segmentWriter) throws Exception {
        Map<String, List<Operation>> columnOperationsMap = this.computeOperations((SegmentDirectory.Reader)segmentWriter);
        if (columnOperationsMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, List<Operation>> entry : columnOperationsMap.entrySet()) {
            String column = entry.getKey();
            List<Operation> operations = entry.getValue();
            block8: for (Operation operation : operations) {
                switch (operation) {
                    case DISABLE_FORWARD_INDEX: {
                        this._tmpForwardIndexColumns.add(column);
                        continue block8;
                    }
                    case ENABLE_FORWARD_INDEX: {
                        ColumnMetadata columnMetadata = this.createForwardIndexIfNeeded(segmentWriter, column, false);
                        if (columnMetadata.hasDictionary()) {
                            if (segmentWriter.hasIndexFor(column, StandardIndexes.dictionary())) continue block8;
                            throw new IllegalStateException(String.format("Dictionary should still exist after rebuilding forward index for dictionary column: %s", column));
                        }
                        if (!segmentWriter.hasIndexFor(column, StandardIndexes.dictionary())) continue block8;
                        throw new IllegalStateException(String.format("Dictionary should not exist after rebuilding forward index for raw column: %s", column));
                    }
                    case DISABLE_DICTIONARY: {
                        Set newForwardIndexDisabledColumns = FieldIndexConfigsUtil.columnsWithIndexDisabled(this._fieldIndexConfigs.keySet(), (IndexType)StandardIndexes.forward(), (Map)this._fieldIndexConfigs);
                        if (newForwardIndexDisabledColumns.contains(column)) {
                            this.removeDictionaryFromForwardIndexDisabledColumn(column, segmentWriter);
                            if (!segmentWriter.hasIndexFor(column, StandardIndexes.dictionary())) continue block8;
                            throw new IllegalStateException(String.format("Dictionary should not exist after disabling dictionary for column: %s", column));
                        }
                        this.disableDictionaryAndCreateRawForwardIndex(column, segmentWriter);
                        continue block8;
                    }
                    case ENABLE_DICTIONARY: {
                        this.createDictBasedForwardIndex(column, segmentWriter);
                        if (segmentWriter.hasIndexFor(column, StandardIndexes.forward())) continue block8;
                        throw new IllegalStateException(String.format("Forward index was not created for column: %s", column));
                    }
                    case CHANGE_INDEX_COMPRESSION_TYPE: {
                        this.rewriteForwardIndexForCompressionChange(column, segmentWriter);
                        continue block8;
                    }
                }
                throw new IllegalStateException("Unsupported operation for column " + column);
            }
        }
    }

    @VisibleForTesting
    Map<String, List<Operation>> computeOperations(SegmentDirectory.Reader segmentReader) throws Exception {
        HashMap<String, List<Operation>> columnOperationsMap = new HashMap<String, List<Operation>>();
        if (this._segmentDirectory.getSegmentMetadata().getVersion().compareTo((Enum)SegmentVersion.v3) < 0) {
            return columnOperationsMap;
        }
        NavigableSet existingAllColumns = this._segmentDirectory.getSegmentMetadata().getAllColumns();
        Set existingDictColumns = this._segmentDirectory.getColumnsWithIndex(StandardIndexes.dictionary());
        Set existingForwardIndexColumns = this._segmentDirectory.getColumnsWithIndex(StandardIndexes.forward());
        String segmentName = this._segmentDirectory.getSegmentMetadata().getName();
        for (String column : existingAllColumns) {
            ColumnMetadata columnMetadata;
            if (this._schema != null && !this._schema.hasColumn(column)) {
                LOGGER.info("Column: {} of segment: {} is not in schema, skipping updating forward index", (Object)column, (Object)segmentName);
                continue;
            }
            boolean existingHasDict = existingDictColumns.contains(column);
            boolean existingHasFwd = existingForwardIndexColumns.contains(column);
            FieldIndexConfigs newConf = (FieldIndexConfigs)this._fieldIndexConfigs.get(column);
            boolean newIsFwd = ((ForwardIndexConfig)newConf.getConfig(StandardIndexes.forward())).isEnabled();
            boolean newIsDict = ((DictionaryIndexConfig)newConf.getConfig(StandardIndexes.dictionary())).isEnabled();
            boolean newIsRange = ((RangeIndexConfig)newConf.getConfig(StandardIndexes.range())).isEnabled();
            if (existingHasFwd && !newIsFwd) {
                columnMetadata = this._segmentDirectory.getSegmentMetadata().getColumnMetadataFor(column);
                if (columnMetadata.isSorted()) {
                    LOGGER.warn("Trying to disable the forward index for a sorted column: {} of segment: {}, ignoring", (Object)column, (Object)segmentName);
                    continue;
                }
                if (existingHasDict) {
                    if (!newIsDict) {
                        Preconditions.checkState((!newIsRange ? 1 : 0) != 0, (Object)String.format("Must disable range index (enabled) to disable the dictionary and forward index for column: %s of segment: %s or refresh / back-fill the forward index", column, segmentName));
                        columnOperationsMap.put(column, Arrays.asList(Operation.DISABLE_FORWARD_INDEX, Operation.DISABLE_DICTIONARY));
                        continue;
                    }
                    columnOperationsMap.put(column, Collections.singletonList(Operation.DISABLE_FORWARD_INDEX));
                    continue;
                }
                if (!newIsDict) {
                    columnOperationsMap.put(column, Collections.singletonList(Operation.DISABLE_FORWARD_INDEX));
                    continue;
                }
                columnOperationsMap.put(column, Arrays.asList(Operation.DISABLE_FORWARD_INDEX, Operation.ENABLE_DICTIONARY));
                continue;
            }
            if (!existingHasFwd && newIsFwd) {
                columnMetadata = this._segmentDirectory.getSegmentMetadata().getColumnMetadataFor(column);
                if (columnMetadata != null && columnMetadata.isSorted()) {
                    LOGGER.warn("Trying to enable the forward index for a sorted column: {} of segment: {}, ignoring", (Object)column, (Object)segmentName);
                    continue;
                }
                Set existingInvertedIndexColumns = segmentReader.toSegmentDirectory().getColumnsWithIndex(StandardIndexes.inverted());
                if (!existingHasDict || !existingInvertedIndexColumns.contains(column)) {
                    LOGGER.warn("Trying to enable the forward index for a column: {} of segment: {} missing either the dictionary ({}) and / or the inverted index ({}) is not possible. Either a refresh or back-fill is required to get the forward index, ignoring", new Object[]{column, segmentName, existingHasDict ? "enabled" : "disabled", existingInvertedIndexColumns.contains(column) ? "enabled" : "disabled"});
                    continue;
                }
                columnOperationsMap.put(column, Collections.singletonList(Operation.ENABLE_FORWARD_INDEX));
                continue;
            }
            if (!existingHasFwd) {
                Preconditions.checkState((existingHasDict || !newIsDict ? 1 : 0) != 0, (Object)String.format("Cannot regenerate the dictionary for column: %s of segment: %s with forward index disabled. Please refresh or back-fill the data to add back the forward index", column, segmentName));
                if (!existingHasDict || newIsDict) continue;
                Preconditions.checkState((!newIsRange ? 1 : 0) != 0, (Object)String.format("Must disable range index (enabled) to disable the dictionary for a forwardIndexDisabled column: %s of segment: %s or refresh / back-fill the forward index", column, segmentName));
                columnOperationsMap.put(column, Collections.singletonList(Operation.DISABLE_DICTIONARY));
                continue;
            }
            if (!existingHasDict && newIsDict) {
                if (this._schema == null || this._tableConfig == null) {
                    LOGGER.warn("Cannot enable dictionary for column: {} of segment: {} as schema or tableConfig is null.", (Object)column, (Object)segmentName);
                    continue;
                }
                ColumnMetadata existingColumnMetadata = this._segmentDirectory.getSegmentMetadata().getColumnMetadataFor(column);
                if (existingColumnMetadata.getFieldSpec().getFieldType() == FieldSpec.FieldType.COMPLEX || !DictionaryIndexType.ignoreDictionaryOverride(this._tableConfig.getIndexingConfig().isOptimizeDictionary(), this._tableConfig.getIndexingConfig().isOptimizeDictionaryForMetrics(), this._tableConfig.getIndexingConfig().getNoDictionarySizeRatioThreshold(), this._tableConfig.getIndexingConfig().getNoDictionaryCardinalityRatioThreshold(), existingColumnMetadata.getFieldSpec(), (FieldIndexConfigs)this._fieldIndexConfigs.get(column), existingColumnMetadata.getCardinality(), existingColumnMetadata.getTotalNumberOfEntries())) continue;
                columnOperationsMap.put(column, Collections.singletonList(Operation.ENABLE_DICTIONARY));
                continue;
            }
            if (existingHasDict && !newIsDict) {
                if (!this.shouldDisableDictionary(column, this._segmentDirectory.getSegmentMetadata().getColumnMetadataFor(column))) continue;
                columnOperationsMap.put(column, Collections.singletonList(Operation.DISABLE_DICTIONARY));
                continue;
            }
            if (!existingHasDict) {
                if (!this.shouldChangeRawCompressionType(column, segmentReader)) continue;
                columnOperationsMap.put(column, Collections.singletonList(Operation.CHANGE_INDEX_COMPRESSION_TYPE));
                continue;
            }
            if (!this.shouldChangeDictIdCompressionType(column, segmentReader)) continue;
            columnOperationsMap.put(column, Collections.singletonList(Operation.CHANGE_INDEX_COMPRESSION_TYPE));
        }
        if (!columnOperationsMap.isEmpty()) {
            LOGGER.info("Need to apply columnOperations: {} for forward index for segment: {}", columnOperationsMap, (Object)segmentName);
        }
        return columnOperationsMap;
    }

    private void removeDictionaryFromForwardIndexDisabledColumn(String column, SegmentDirectory.Writer segmentWriter) throws Exception {
        segmentWriter.removeIndex(column, StandardIndexes.dictionary());
        String segmentName = this._segmentDirectory.getSegmentMetadata().getName();
        LOGGER.info("Removed dictionary for noForwardIndex column. Updating metadata properties for segment={} and column={}", (Object)segmentName, (Object)column);
        HashMap<String, String> metadataProperties = new HashMap<String, String>();
        metadataProperties.put(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"hasDictionary"), String.valueOf(false));
        metadataProperties.put(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"lengthOfEachEntry"), String.valueOf(0));
        SegmentMetadataUtils.updateMetadataProperties((SegmentDirectory)this._segmentDirectory, metadataProperties);
        ForwardIndexHandler.removeDictRelatedIndexes(column, segmentWriter);
    }

    private boolean shouldDisableDictionary(String column, ColumnMetadata existingColumnMetadata) {
        if (this._schema == null || this._tableConfig == null) {
            LOGGER.warn("Cannot disable dictionary for column={} as schema or tableConfig is null.", (Object)column);
            return false;
        }
        if (existingColumnMetadata.isAutoGenerated() && existingColumnMetadata.getCardinality() == 1) {
            LOGGER.warn("Cannot disable dictionary for auto-generated column={} with cardinality=1.", (Object)column);
            return false;
        }
        if (existingColumnMetadata.isSorted()) {
            LOGGER.warn("Cannot disable dictionary for column={} as it is sorted.", (Object)column);
            return false;
        }
        if (this.hasIndex(column, StandardIndexes.inverted()) || this.hasIndex(column, StandardIndexes.fst())) {
            LOGGER.warn("Cannot disable dictionary as column={} has FST index or inverted index or both.", (Object)column);
            return false;
        }
        return true;
    }

    private boolean shouldChangeRawCompressionType(String column, SegmentDirectory.Reader segmentReader) throws Exception {
        ChunkCompressionType existingCompressionType;
        ColumnMetadata existingColMetadata = this._segmentDirectory.getSegmentMetadata().getColumnMetadataFor(column);
        try (ForwardIndexReader<?> fwdIndexReader = ForwardIndexType.read(segmentReader, existingColMetadata);){
            existingCompressionType = fwdIndexReader.getCompressionType();
            Preconditions.checkState((existingCompressionType != null ? 1 : 0) != 0, (Object)("Existing compressionType cannot be null for raw forward index column=" + column));
        }
        ChunkCompressionType newCompressionType = ((ForwardIndexConfig)((FieldIndexConfigs)this._fieldIndexConfigs.get(column)).getConfig(StandardIndexes.forward())).getChunkCompressionType();
        return newCompressionType != null && existingCompressionType != newCompressionType;
    }

    private boolean shouldChangeDictIdCompressionType(String column, SegmentDirectory.Reader segmentReader) throws Exception {
        DictIdCompressionType existingCompressionType;
        ColumnMetadata existingColMetadata = this._segmentDirectory.getSegmentMetadata().getColumnMetadataFor(column);
        try (ForwardIndexReader<?> fwdIndexReader = ForwardIndexType.read(segmentReader, existingColMetadata);){
            existingCompressionType = fwdIndexReader.getDictIdCompressionType();
        }
        DictIdCompressionType newCompressionType = ((ForwardIndexConfig)((FieldIndexConfigs)this._fieldIndexConfigs.get(column)).getConfig(StandardIndexes.forward())).getDictIdCompressionType();
        if (newCompressionType != null && !newCompressionType.isApplicable(existingColMetadata.isSingleValue())) {
            newCompressionType = null;
        }
        return existingCompressionType != newCompressionType;
    }

    private void rewriteForwardIndexForCompressionChange(String column, SegmentDirectory.Writer segmentWriter) throws Exception {
        ColumnMetadata existingColMetadata = this._segmentDirectory.getSegmentMetadata().getColumnMetadataFor(column);
        boolean isSingleValue = existingColMetadata.isSingleValue();
        boolean hasDictionary = existingColMetadata.hasDictionary();
        File indexDir = this._segmentDirectory.getSegmentMetadata().getIndexDir();
        String segmentName = this._segmentDirectory.getSegmentMetadata().getName();
        File inProgress = new File(indexDir, column + ".fwd.inprogress");
        String fileExtension = isSingleValue ? (hasDictionary ? ".sv.unsorted.fwd" : ".sv.raw.fwd") : (hasDictionary ? ".mv.fwd" : ".mv.raw.fwd");
        File fwdIndexFile = new File(indexDir, column + fileExtension);
        if (!inProgress.exists()) {
            FileUtils.touch((File)inProgress);
        } else {
            FileUtils.deleteQuietly((File)fwdIndexFile);
        }
        LOGGER.info("Creating new forward index for segment={} and column={}", (Object)segmentName, (Object)column);
        this.rewriteForwardIndexForCompressionChange(column, existingColMetadata, indexDir, segmentWriter);
        segmentWriter.removeIndex(column, StandardIndexes.forward());
        LoaderUtils.writeIndexToV3Format(segmentWriter, column, fwdIndexFile, StandardIndexes.forward());
        FileUtils.deleteQuietly((File)inProgress);
        LOGGER.info("Created forward index for segment: {}, column: {}", (Object)segmentName, (Object)column);
    }

    private void rewriteForwardIndexForCompressionChange(String column, ColumnMetadata columnMetadata, File indexDir, SegmentDirectory.Writer segmentWriter) throws Exception {
        try (ForwardIndexReader<?> reader = ForwardIndexType.read((SegmentDirectory.Reader)segmentWriter, columnMetadata);){
            IndexCreationContext.Builder builder = IndexCreationContext.builder().withIndexDir(indexDir).withColumnMetadata(columnMetadata);
            if (!reader.isDictionaryEncoded() && !columnMetadata.getDataType().getStoredType().isFixedWidth()) {
                int lengthOfLongestEntry = reader.getLengthOfLongestEntry();
                if (lengthOfLongestEntry < 0) {
                    lengthOfLongestEntry = this.getMaxRowLength(columnMetadata, reader, null);
                }
                if (columnMetadata.isSingleValue()) {
                    builder.withLengthOfLongestEntry(lengthOfLongestEntry);
                } else {
                    int maxNumValuesPerEntry = columnMetadata.getMaxNumberOfMultiValues();
                    int maxRowLengthInBytes = MultiValueVarByteRawIndexCreator.getMaxRowDataLengthInBytes(lengthOfLongestEntry, maxNumValuesPerEntry);
                    builder.withMaxRowLengthInBytes(maxRowLengthInBytes);
                }
            }
            IndexCreationContext.Common context = builder.build();
            ForwardIndexConfig config = (ForwardIndexConfig)((FieldIndexConfigs)this._fieldIndexConfigs.get(column)).getConfig(StandardIndexes.forward());
            try (ForwardIndexCreator creator = (ForwardIndexCreator)StandardIndexes.forward().createIndexCreator((IndexCreationContext)context, (IndexConfig)config);){
                if (!reader.getStoredType().equals((Object)creator.getValueType())) {
                    String failureMsg = "Unsupported operation to change datatype for column=" + column + " from " + reader.getStoredType().toString() + " to " + creator.getValueType().toString();
                    throw new UnsupportedOperationException(failureMsg);
                }
                int numDocs = columnMetadata.getTotalDocs();
                this.forwardIndexRewriteHelper(column, columnMetadata, reader, creator, numDocs, null, null);
            }
        }
    }

    private void forwardIndexRewriteHelper(String column, ColumnMetadata existingColumnMetadata, ForwardIndexReader<?> reader, ForwardIndexCreator creator, int numDocs, @Nullable SegmentDictionaryCreator dictionaryCreator, @Nullable Dictionary dictionaryReader) {
        if (dictionaryReader == null && dictionaryCreator == null) {
            if (reader.isDictionaryEncoded()) {
                Preconditions.checkState((boolean)creator.isDictionaryEncoded(), (String)"Cannot change dictionary based forward index to raw forward index without providing dictionary reader for column: %s", (Object)column);
                this.forwardIndexReadDictWriteDictHelper(reader, creator, numDocs);
            } else {
                Preconditions.checkState((!creator.isDictionaryEncoded() ? 1 : 0) != 0, (String)"Cannot change raw forward index to dictionary based forward index without providing dictionary creator for column: %s", (Object)column);
                this.forwardIndexReadRawWriteRawHelper(column, existingColumnMetadata, reader, creator, numDocs);
            }
        } else if (dictionaryCreator == null) {
            this.forwardIndexReadDictWriteRawHelper(column, existingColumnMetadata, reader, creator, numDocs, dictionaryReader);
        } else if (dictionaryReader == null) {
            this.forwardIndexReadRawWriteDictHelper(column, existingColumnMetadata, reader, creator, numDocs, dictionaryCreator);
        } else {
            throw new IllegalStateException("One of dictionary reader or creator should be null for column: %s" + column);
        }
    }

    private <C extends ForwardIndexReaderContext> void forwardIndexReadDictWriteDictHelper(ForwardIndexReader<C> reader, ForwardIndexCreator creator, int numDocs) {
        ForwardIndexReaderContext readerContext = reader.createContext();
        if (reader.isSingleValue()) {
            for (int i = 0; i < numDocs; ++i) {
                creator.putDictId(reader.getDictId(i, readerContext));
            }
        } else {
            for (int i = 0; i < numDocs; ++i) {
                creator.putDictIdMV(reader.getDictIdMV(i, readerContext));
            }
        }
    }

    private <C extends ForwardIndexReaderContext> void forwardIndexReadRawWriteRawHelper(String column, ColumnMetadata existingColumnMetadata, ForwardIndexReader<C> reader, ForwardIndexCreator creator, int numDocs) {
        ForwardIndexReaderContext readerContext = reader.createContext();
        boolean isSVColumn = reader.isSingleValue();
        switch (reader.getStoredType()) {
            case INT: {
                for (int i = 0; i < numDocs; ++i) {
                    if (isSVColumn) {
                        int val = reader.getInt(i, readerContext);
                        creator.putInt(val);
                        continue;
                    }
                    int[] ints = reader.getIntMV(i, readerContext);
                    creator.putIntMV(ints);
                }
                break;
            }
            case LONG: {
                for (int i = 0; i < numDocs; ++i) {
                    if (isSVColumn) {
                        long val = reader.getLong(i, readerContext);
                        creator.putLong(val);
                        continue;
                    }
                    long[] longs = reader.getLongMV(i, readerContext);
                    creator.putLongMV(longs);
                }
                break;
            }
            case FLOAT: {
                for (int i = 0; i < numDocs; ++i) {
                    if (isSVColumn) {
                        float val = reader.getFloat(i, readerContext);
                        creator.putFloat(val);
                        continue;
                    }
                    float[] floats = reader.getFloatMV(i, readerContext);
                    creator.putFloatMV(floats);
                }
                break;
            }
            case DOUBLE: {
                for (int i = 0; i < numDocs; ++i) {
                    if (isSVColumn) {
                        double val = reader.getDouble(i, readerContext);
                        creator.putDouble(val);
                        continue;
                    }
                    double[] doubles = reader.getDoubleMV(i, readerContext);
                    creator.putDoubleMV(doubles);
                }
                break;
            }
            case STRING: {
                for (int i = 0; i < numDocs; ++i) {
                    if (isSVColumn) {
                        String val = reader.getString(i, readerContext);
                        creator.putString(val);
                        continue;
                    }
                    String[] strings = reader.getStringMV(i, readerContext);
                    creator.putStringMV(strings);
                }
                break;
            }
            case BYTES: {
                for (int i = 0; i < numDocs; ++i) {
                    if (isSVColumn) {
                        byte[] val = reader.getBytes(i, readerContext);
                        creator.putBytes(val);
                        continue;
                    }
                    byte[][] bytesArray = reader.getBytesMV(i, readerContext);
                    creator.putBytesMV(bytesArray);
                }
                break;
            }
            case BIG_DECIMAL: {
                Preconditions.checkState((boolean)isSVColumn, (Object)"BigDecimal is not supported for MV columns");
                for (int i = 0; i < numDocs; ++i) {
                    BigDecimal val = reader.getBigDecimal(i, readerContext);
                    creator.putBigDecimal(val);
                }
                break;
            }
            case MAP: {
                for (int i = 0; i < numDocs; ++i) {
                    if (!isSVColumn) {
                        throw new IllegalStateException("Map is not supported for MV columns");
                    }
                    byte[] val = reader.getBytes(i, readerContext);
                    creator.putBytes(val);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported storedType=" + reader.getStoredType() + " for column=" + column);
            }
        }
    }

    private <C extends ForwardIndexReaderContext> void forwardIndexReadDictWriteRawHelper(String column, ColumnMetadata existingColumnMetadata, ForwardIndexReader<C> reader, ForwardIndexCreator creator, int numDocs, Dictionary dictionaryReader) {
        ForwardIndexReaderContext readerContext = reader.createContext();
        boolean isSVColumn = reader.isSingleValue();
        FieldSpec.DataType storedType = dictionaryReader.getValueType().getStoredType();
        switch (storedType) {
            case INT: {
                for (int i = 0; i < numDocs; ++i) {
                    if (isSVColumn) {
                        int dictId = reader.getDictId(i, readerContext);
                        int val = dictionaryReader.getIntValue(dictId);
                        creator.putInt(val);
                        continue;
                    }
                    int[] dictIds = reader.getDictIdMV(i, readerContext);
                    int[] ints = new int[dictIds.length];
                    dictionaryReader.readIntValues(dictIds, dictIds.length, ints);
                    creator.putIntMV(ints);
                }
                break;
            }
            case LONG: {
                for (int i = 0; i < numDocs; ++i) {
                    if (isSVColumn) {
                        int dictId = reader.getDictId(i, readerContext);
                        long val = dictionaryReader.getLongValue(dictId);
                        creator.putLong(val);
                        continue;
                    }
                    int[] dictIds = reader.getDictIdMV(i, readerContext);
                    long[] longs = new long[dictIds.length];
                    dictionaryReader.readLongValues(dictIds, dictIds.length, longs);
                    creator.putLongMV(longs);
                }
                break;
            }
            case FLOAT: {
                for (int i = 0; i < numDocs; ++i) {
                    if (isSVColumn) {
                        int dictId = reader.getDictId(i, readerContext);
                        float val = dictionaryReader.getFloatValue(dictId);
                        creator.putFloat(val);
                        continue;
                    }
                    int[] dictIds = reader.getDictIdMV(i, readerContext);
                    float[] floats = new float[dictIds.length];
                    dictionaryReader.readFloatValues(dictIds, dictIds.length, floats);
                    creator.putFloatMV(floats);
                }
                break;
            }
            case DOUBLE: {
                for (int i = 0; i < numDocs; ++i) {
                    if (isSVColumn) {
                        int dictId = reader.getDictId(i, readerContext);
                        double val = dictionaryReader.getDoubleValue(dictId);
                        creator.putDouble(val);
                        continue;
                    }
                    int[] dictIds = reader.getDictIdMV(i, readerContext);
                    double[] doubles = new double[dictIds.length];
                    dictionaryReader.readDoubleValues(dictIds, dictIds.length, doubles);
                    creator.putDoubleMV(doubles);
                }
                break;
            }
            case BYTES: {
                for (int i = 0; i < numDocs; ++i) {
                    if (isSVColumn) {
                        int dictId = reader.getDictId(i, readerContext);
                        byte[] val = dictionaryReader.getBytesValue(dictId);
                        creator.putBytes(val);
                        continue;
                    }
                    int[] dictIds = reader.getDictIdMV(i, readerContext);
                    byte[][] bytes = new byte[dictIds.length][];
                    dictionaryReader.readBytesValues(dictIds, dictIds.length, (byte[][])bytes);
                    creator.putBytesMV((byte[][])bytes);
                }
                break;
            }
            case STRING: {
                for (int i = 0; i < numDocs; ++i) {
                    if (isSVColumn) {
                        int dictId = reader.getDictId(i, readerContext);
                        String val = dictionaryReader.getStringValue(dictId);
                        creator.putString(val);
                        continue;
                    }
                    int[] dictIds = reader.getDictIdMV(i, readerContext);
                    String[] strings = new String[dictIds.length];
                    dictionaryReader.readStringValues(dictIds, dictIds.length, strings);
                    creator.putStringMV(strings);
                }
                break;
            }
            case BIG_DECIMAL: {
                Preconditions.checkState((boolean)isSVColumn, (Object)"BigDecimal is not supported for MV columns");
                for (int i = 0; i < numDocs; ++i) {
                    int dictId = reader.getDictId(i, readerContext);
                    BigDecimal val = dictionaryReader.getBigDecimalValue(dictId);
                    creator.putBigDecimal(val);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported storedType=" + storedType + " for column=" + column);
            }
        }
    }

    private void forwardIndexReadRawWriteDictHelper(String column, ColumnMetadata existingColumnMetadata, ForwardIndexReader<?> reader, ForwardIndexCreator creator, int numDocs, SegmentDictionaryCreator dictionaryCreator) {
        boolean isSVColumn = reader.isSingleValue();
        int maxNumValuesPerEntry = existingColumnMetadata.getMaxNumberOfMultiValues();
        PinotSegmentColumnReader columnReader = new PinotSegmentColumnReader(reader, null, null, maxNumValuesPerEntry);
        for (int i = 0; i < numDocs; ++i) {
            Object obj = columnReader.getValue(i);
            if (isSVColumn) {
                int dictId = dictionaryCreator.indexOfSV(obj);
                creator.putDictId(dictId);
                continue;
            }
            int[] dictIds = dictionaryCreator.indexOfMV(obj);
            creator.putDictIdMV(dictIds);
        }
    }

    private void createDictBasedForwardIndex(String column, SegmentDirectory.Writer segmentWriter) throws Exception {
        ColumnMetadata existingColMetadata = this._segmentDirectory.getSegmentMetadata().getColumnMetadataFor(column);
        boolean isSingleValue = existingColMetadata.isSingleValue();
        File indexDir = this._segmentDirectory.getSegmentMetadata().getIndexDir();
        String segmentName = this._segmentDirectory.getSegmentMetadata().getName();
        File inProgress = new File(indexDir, column + ".dict.inprogress");
        File dictionaryFile = new File(indexDir, column + ".dict");
        String fwdIndexFileExtension = isSingleValue ? (existingColMetadata.isSorted() ? ".sv.sorted.fwd" : ".sv.unsorted.fwd") : ".mv.fwd";
        File fwdIndexFile = new File(indexDir, column + fwdIndexFileExtension);
        if (!inProgress.exists()) {
            FileUtils.touch((File)inProgress);
        } else {
            FileUtils.deleteQuietly((File)fwdIndexFile);
            FileUtils.deleteQuietly((File)dictionaryFile);
        }
        LOGGER.info("Creating a new dictionary for segment={} and column={}", (Object)segmentName, (Object)column);
        AbstractColumnStatisticsCollector statsCollector = this.getStatsCollector(column, existingColMetadata.getDataType().getStoredType());
        SegmentDictionaryCreator dictionaryCreator = this.buildDictionary(column, existingColMetadata, segmentWriter, statsCollector);
        LoaderUtils.writeIndexToV3Format(segmentWriter, column, dictionaryFile, StandardIndexes.dictionary());
        LOGGER.info("Built dictionary. Rewriting dictionary enabled forward index for segment={} and column={}", (Object)segmentName, (Object)column);
        this.writeDictEnabledForwardIndex(column, existingColMetadata, segmentWriter, indexDir, dictionaryCreator);
        segmentWriter.removeIndex(column, StandardIndexes.forward());
        LoaderUtils.writeIndexToV3Format(segmentWriter, column, fwdIndexFile, StandardIndexes.forward());
        LOGGER.info("Created forwardIndex. Updating metadata properties for segment={} and column={}", (Object)segmentName, (Object)column);
        HashMap<String, String> metadataProperties = new HashMap<String, String>();
        metadataProperties.put(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"hasDictionary"), String.valueOf(true));
        metadataProperties.put(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"lengthOfEachEntry"), String.valueOf(dictionaryCreator.getNumBytesPerEntry()));
        metadataProperties.put(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"cardinality"), String.valueOf(statsCollector.getCardinality()));
        SegmentMetadataUtils.updateMetadataProperties((SegmentDirectory)this._segmentDirectory, metadataProperties);
        ForwardIndexHandler.removeDictRelatedIndexes(column, segmentWriter);
        FileUtils.deleteQuietly((File)inProgress);
        LOGGER.info("Created dictionary based forward index for segment: {}, column: {}", (Object)segmentName, (Object)column);
    }

    private SegmentDictionaryCreator buildDictionary(String column, ColumnMetadata existingColMetadata, SegmentDirectory.Writer segmentWriter, AbstractColumnStatisticsCollector statsCollector) throws Exception {
        int numDocs = existingColMetadata.getTotalDocs();
        try (ForwardIndexReader<?> reader = ForwardIndexType.read((SegmentDirectory.Reader)segmentWriter, existingColMetadata);){
            PinotSegmentColumnReader columnReader = new PinotSegmentColumnReader(reader, null, null, existingColMetadata.getMaxNumberOfMultiValues());
            for (int i = 0; i < numDocs; ++i) {
                Object obj = columnReader.getValue(i);
                statsCollector.collect(obj);
            }
            statsCollector.seal();
            DictionaryIndexConfig dictConf = (DictionaryIndexConfig)((FieldIndexConfigs)this._fieldIndexConfigs.get(column)).getConfig(StandardIndexes.dictionary());
            boolean optimizeDictionaryType = this._tableConfig.getIndexingConfig().isOptimizeDictionaryType();
            boolean useVarLength = dictConf.getUseVarLengthDictionary() || DictionaryIndexType.shouldUseVarLengthDictionary(reader.getStoredType(), statsCollector) || optimizeDictionaryType && DictionaryIndexType.optimizeTypeShouldUseVarLengthDictionary(reader.getStoredType(), statsCollector);
            SegmentDictionaryCreator dictionaryCreator = new SegmentDictionaryCreator(existingColMetadata.getFieldSpec(), this._segmentDirectory.getSegmentMetadata().getIndexDir(), useVarLength);
            dictionaryCreator.build(statsCollector.getUniqueValuesSet());
            SegmentDictionaryCreator segmentDictionaryCreator = dictionaryCreator;
            return segmentDictionaryCreator;
        }
    }

    private void writeDictEnabledForwardIndex(String column, ColumnMetadata existingColMetadata, SegmentDirectory.Writer segmentWriter, File indexDir, SegmentDictionaryCreator dictionaryCreator) throws Exception {
        try (ForwardIndexReader<?> reader = ForwardIndexType.read((SegmentDirectory.Reader)segmentWriter, existingColMetadata);){
            IndexCreationContext.Builder builder = IndexCreationContext.builder().withIndexDir(indexDir).withColumnMetadata(existingColMetadata);
            builder.withDictionary(true);
            IndexCreationContext.Common context = builder.build();
            ForwardIndexConfig config = (ForwardIndexConfig)((FieldIndexConfigs)this._fieldIndexConfigs.get(column)).getConfig(StandardIndexes.forward());
            try (ForwardIndexCreator creator = (ForwardIndexCreator)StandardIndexes.forward().createIndexCreator((IndexCreationContext)context, (IndexConfig)config);){
                int numDocs = existingColMetadata.getTotalDocs();
                this.forwardIndexRewriteHelper(column, existingColMetadata, reader, creator, numDocs, dictionaryCreator, null);
            }
        }
    }

    static void removeDictRelatedIndexes(String column, SegmentDirectory.Writer segmentWriter) {
        DICTIONARY_BASED_INDEXES_TO_REWRITE.forEach(index -> segmentWriter.removeIndex(column, index));
    }

    private void disableDictionaryAndCreateRawForwardIndex(String column, SegmentDirectory.Writer segmentWriter) throws Exception {
        ColumnMetadata existingColMetadata = this._segmentDirectory.getSegmentMetadata().getColumnMetadataFor(column);
        boolean isSingleValue = existingColMetadata.isSingleValue();
        File indexDir = this._segmentDirectory.getSegmentMetadata().getIndexDir();
        String segmentName = this._segmentDirectory.getSegmentMetadata().getName();
        File inProgress = new File(indexDir, column + ".fwd.inprogress");
        String fileExtension = isSingleValue ? ".sv.raw.fwd" : ".mv.raw.fwd";
        File fwdIndexFile = new File(indexDir, column + fileExtension);
        if (!inProgress.exists()) {
            FileUtils.touch((File)inProgress);
        } else {
            FileUtils.deleteQuietly((File)fwdIndexFile);
        }
        LOGGER.info("Creating raw forward index for segment={} and column={}", (Object)segmentName, (Object)column);
        this.rewriteDictToRawForwardIndex(existingColMetadata, segmentWriter, indexDir);
        segmentWriter.removeIndex(column, StandardIndexes.forward());
        segmentWriter.removeIndex(column, StandardIndexes.dictionary());
        LoaderUtils.writeIndexToV3Format(segmentWriter, column, fwdIndexFile, StandardIndexes.forward());
        LOGGER.info("Created raw forwardIndex. Updating metadata properties for segment={} and column={}", (Object)segmentName, (Object)column);
        HashMap<String, String> metadataProperties = new HashMap<String, String>();
        metadataProperties.put(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"hasDictionary"), String.valueOf(false));
        metadataProperties.put(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"lengthOfEachEntry"), String.valueOf(0));
        SegmentMetadataUtils.updateMetadataProperties((SegmentDirectory)this._segmentDirectory, metadataProperties);
        ForwardIndexHandler.removeDictRelatedIndexes(column, segmentWriter);
        FileUtils.deleteQuietly((File)inProgress);
        LOGGER.info("Created raw based forward index for segment: {}, column: {}", (Object)segmentName, (Object)column);
    }

    private void rewriteDictToRawForwardIndex(ColumnMetadata columnMetadata, SegmentDirectory.Writer segmentWriter, File indexDir) throws Exception {
        String column = columnMetadata.getColumnName();
        try (ForwardIndexReader<?> reader = ForwardIndexType.read((SegmentDirectory.Reader)segmentWriter, columnMetadata);){
            Dictionary dictionary = DictionaryIndexType.read((SegmentDirectory.Reader)segmentWriter, columnMetadata);
            IndexCreationContext.Builder builder = IndexCreationContext.builder().withIndexDir(indexDir).withColumnMetadata(columnMetadata);
            builder.withDictionary(false);
            if (!columnMetadata.getDataType().getStoredType().isFixedWidth()) {
                if (columnMetadata.isSingleValue()) {
                    builder.withLengthOfLongestEntry(columnMetadata.getColumnMaxLength());
                } else {
                    builder.withMaxRowLengthInBytes(this.getMaxRowLength(columnMetadata, reader, dictionary));
                }
            }
            IndexCreationContext.Common context = builder.build();
            ForwardIndexConfig config = (ForwardIndexConfig)((FieldIndexConfigs)this._fieldIndexConfigs.get(column)).getConfig(StandardIndexes.forward());
            try (ForwardIndexCreator creator = (ForwardIndexCreator)StandardIndexes.forward().createIndexCreator((IndexCreationContext)context, (IndexConfig)config);){
                this.forwardIndexRewriteHelper(column, columnMetadata, reader, creator, columnMetadata.getTotalDocs(), null, dictionary);
            }
        }
    }

    private int getMaxRowLength(ColumnMetadata columnMetadata, ForwardIndexReader<?> forwardIndex, @Nullable Dictionary dictionary) throws IOException {
        String column = columnMetadata.getColumnName();
        FieldSpec.DataType storedType = columnMetadata.getDataType().getStoredType();
        assert (!storedType.isFixedWidth());
        try (PinotSegmentColumnReader columnReader = new PinotSegmentColumnReader(forwardIndex, dictionary, null, columnMetadata.getMaxNumberOfMultiValues());){
            AbstractColumnStatisticsCollector statsCollector = this.getStatsCollector(column, storedType);
            int numDocs = columnMetadata.getTotalDocs();
            for (int i = 0; i < numDocs; ++i) {
                statsCollector.collect(columnReader.getValue(i));
            }
            int n = columnMetadata.isSingleValue() ? statsCollector.getLengthOfLargestElement() : statsCollector.getMaxRowLengthInBytes();
            return n;
        }
    }

    private AbstractColumnStatisticsCollector getStatsCollector(String column, FieldSpec.DataType storedType) {
        StatsCollectorConfig statsCollectorConfig = new StatsCollectorConfig(this._tableConfig, this._schema, null);
        switch (storedType) {
            case INT: {
                return new IntColumnPreIndexStatsCollector(column, statsCollectorConfig);
            }
            case LONG: {
                return new LongColumnPreIndexStatsCollector(column, statsCollectorConfig);
            }
            case FLOAT: {
                return new FloatColumnPreIndexStatsCollector(column, statsCollectorConfig);
            }
            case DOUBLE: {
                return new DoubleColumnPreIndexStatsCollector(column, statsCollectorConfig);
            }
            case BIG_DECIMAL: {
                return new BigDecimalColumnPreIndexStatsCollector(column, statsCollectorConfig);
            }
            case STRING: {
                return new StringColumnPreIndexStatsCollector(column, statsCollectorConfig);
            }
            case BYTES: {
                return new BytesColumnPredIndexStatsCollector(column, statsCollectorConfig);
            }
            case MAP: {
                return new MapColumnPreIndexStatsCollector(column, statsCollectorConfig);
            }
        }
        throw new IllegalStateException("Unsupported storedType=" + storedType + " for column=" + column);
    }

    private boolean hasIndex(String column, IndexType<?, ?, ?> indexType) {
        return ((FieldIndexConfigs)this._fieldIndexConfigs.get(column)).getConfig(indexType).isEnabled();
    }

    protected static enum Operation {
        DISABLE_FORWARD_INDEX,
        ENABLE_FORWARD_INDEX,
        DISABLE_DICTIONARY,
        ENABLE_DICTIONARY,
        CHANGE_INDEX_COMPRESSION_TYPE;

    }
}

