/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.utils.config.TableConfigUtils;
import org.apache.pinot.segment.local.segment.index.loader.columnminmaxvalue.ColumnMinMaxValueGeneratorMode;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.index.FieldIndexConfigs;
import org.apache.pinot.segment.spi.index.FieldIndexConfigsUtil;
import org.apache.pinot.spi.config.instance.InstanceDataManagerConfig;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.config.table.IndexingConfig;
import org.apache.pinot.spi.config.table.StarTreeIndexConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.DimensionFieldSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.utils.ReadMode;
import org.apache.pinot.spi.utils.TimestampIndexUtils;

public class IndexLoadingConfig {
    private static final int DEFAULT_REALTIME_AVG_MULTI_VALUE_COUNT = 2;
    public static final String READ_MODE_KEY = "readMode";
    private final InstanceDataManagerConfig _instanceDataManagerConfig;
    private final TableConfig _tableConfig;
    private final Schema _schema;
    private ReadMode _readMode = ReadMode.DEFAULT_MODE;
    private SegmentVersion _segmentVersion;
    private String _segmentTier;
    private Set<String> _knownColumns;
    private String _tableDataDir;
    private boolean _errorOnColumnBuildFailure;
    private String _instanceId;
    private boolean _isRealtimeOffHeapAllocation;
    private boolean _isDirectRealtimeOffHeapAllocation;
    private int _realtimeAvgMultiValueCount = 2;
    private String _segmentStoreURI;
    private String _segmentDirectoryLoader;
    private Map<String, Map<String, String>> _instanceTierConfigs;
    private List<String> _sortedColumns = Collections.emptyList();
    private ColumnMinMaxValueGeneratorMode _columnMinMaxValueGeneratorMode = ColumnMinMaxValueGeneratorMode.DEFAULT_MODE;
    private boolean _enableDynamicStarTreeCreation;
    private List<StarTreeIndexConfig> _starTreeIndexConfigs;
    private boolean _enableDefaultStarTree;
    private Map<String, FieldIndexConfigs> _indexConfigsByColName = new HashMap<String, FieldIndexConfigs>();
    private boolean _dirty = true;

    public IndexLoadingConfig(@Nullable InstanceDataManagerConfig instanceDataManagerConfig, @Nullable TableConfig tableConfig, @Nullable Schema schema) {
        this._instanceDataManagerConfig = instanceDataManagerConfig;
        this._tableConfig = tableConfig;
        this._schema = schema;
        this.init();
    }

    @VisibleForTesting
    public IndexLoadingConfig(InstanceDataManagerConfig instanceDataManagerConfig, TableConfig tableConfig) {
        this(instanceDataManagerConfig, tableConfig, null);
    }

    @VisibleForTesting
    public IndexLoadingConfig(TableConfig tableConfig, @Nullable Schema schema) {
        this(null, tableConfig, schema);
    }

    public IndexLoadingConfig() {
        this(null, null, null);
    }

    @Nullable
    public InstanceDataManagerConfig getInstanceDataManagerConfig() {
        return this._instanceDataManagerConfig;
    }

    @Nullable
    public TableConfig getTableConfig() {
        return this._tableConfig;
    }

    @Nullable
    public Schema getSchema() {
        return this._schema;
    }

    private void init() {
        if (this._instanceDataManagerConfig != null) {
            this.extractFromInstanceConfig();
        }
        if (this._tableConfig != null) {
            this.extractFromTableConfigAndSchema();
        }
    }

    private void extractFromInstanceConfig() {
        String instanceSegmentVersion;
        this._instanceId = this._instanceDataManagerConfig.getInstanceId();
        ReadMode instanceReadMode = this._instanceDataManagerConfig.getReadMode();
        if (instanceReadMode != null) {
            this._readMode = instanceReadMode;
        }
        if ((instanceSegmentVersion = this._instanceDataManagerConfig.getSegmentFormatVersion()) != null) {
            this._segmentVersion = SegmentVersion.valueOf((String)instanceSegmentVersion.toLowerCase());
        }
        this._isRealtimeOffHeapAllocation = this._instanceDataManagerConfig.isRealtimeOffHeapAllocation();
        this._isDirectRealtimeOffHeapAllocation = this._instanceDataManagerConfig.isDirectRealtimeOffHeapAllocation();
        String avgMultiValueCount = this._instanceDataManagerConfig.getAvgMultiValueCount();
        if (avgMultiValueCount != null) {
            this._realtimeAvgMultiValueCount = Integer.parseInt(avgMultiValueCount);
        }
        this._segmentStoreURI = this._instanceDataManagerConfig.getSegmentStoreUri();
        this._segmentDirectoryLoader = this._instanceDataManagerConfig.getSegmentDirectoryLoader();
        Map tierConfigs = this._instanceDataManagerConfig.getTierConfigs();
        this._instanceTierConfigs = tierConfigs != null ? tierConfigs : Map.of();
    }

    private void extractFromTableConfigAndSchema() {
        String columnMinMaxValueGeneratorMode;
        String tableSegmentVersion;
        List sortedColumns;
        IndexingConfig indexingConfig;
        String tableReadMode;
        if (this._schema != null) {
            TimestampIndexUtils.applyTimestampIndex((TableConfig)this._tableConfig, (Schema)this._schema);
        }
        if ((tableReadMode = (indexingConfig = this._tableConfig.getIndexingConfig()).getLoadMode()) != null) {
            this._readMode = ReadMode.getEnum((String)tableReadMode);
        }
        if ((sortedColumns = indexingConfig.getSortedColumn()) != null) {
            this._sortedColumns = sortedColumns;
        }
        if ((tableSegmentVersion = indexingConfig.getSegmentFormatVersion()) != null) {
            this._segmentVersion = SegmentVersion.valueOf((String)tableSegmentVersion.toLowerCase());
        }
        if ((columnMinMaxValueGeneratorMode = indexingConfig.getColumnMinMaxValueGeneratorMode()) != null) {
            this._columnMinMaxValueGeneratorMode = ColumnMinMaxValueGeneratorMode.valueOf(columnMinMaxValueGeneratorMode.toUpperCase());
        }
        this.refreshIndexConfigs();
    }

    public void refreshIndexConfigs() {
        if (this._tableConfig == null) {
            this._dirty = false;
            return;
        }
        TableConfig tableConfig = this.getTableConfigWithTierOverwrites();
        Schema schema = this.inferSchema();
        this._indexConfigsByColName = FieldIndexConfigsUtil.createIndexConfigsByColName((TableConfig)tableConfig, (Schema)schema);
        IndexingConfig indexingConfig = tableConfig.getIndexingConfig();
        this._enableDynamicStarTreeCreation = indexingConfig.isEnableDynamicStarTreeCreation();
        this._starTreeIndexConfigs = indexingConfig.getStarTreeIndexConfigs();
        this._enableDefaultStarTree = indexingConfig.isEnableDefaultStarTree();
        this._dirty = false;
    }

    private TableConfig getTableConfigWithTierOverwrites() {
        return this._segmentTier == null || this._tableConfig == null ? this._tableConfig : TableConfigUtils.overwriteTableConfigForTier((TableConfig)this._tableConfig, (String)this._segmentTier);
    }

    private Schema inferSchema() {
        if (this._schema != null) {
            return this._schema;
        }
        Schema schema = new Schema();
        for (String column : this.getAllKnownColumns()) {
            schema.addField((FieldSpec)new DimensionFieldSpec(column, FieldSpec.DataType.STRING, true));
        }
        return schema;
    }

    public ReadMode getReadMode() {
        return this._readMode;
    }

    public void setReadMode(ReadMode readMode) {
        this._readMode = readMode;
    }

    public List<String> getSortedColumns() {
        return this.unmodifiable(this._sortedColumns);
    }

    public boolean isEnableDynamicStarTreeCreation() {
        if (this._dirty) {
            this.refreshIndexConfigs();
        }
        return this._enableDynamicStarTreeCreation;
    }

    @Nullable
    public List<StarTreeIndexConfig> getStarTreeIndexConfigs() {
        if (this._dirty) {
            this.refreshIndexConfigs();
        }
        return this.unmodifiable(this._starTreeIndexConfigs);
    }

    public boolean isEnableDefaultStarTree() {
        if (this._dirty) {
            this.refreshIndexConfigs();
        }
        return this._enableDefaultStarTree;
    }

    @Nullable
    public SegmentVersion getSegmentVersion() {
        return this._segmentVersion;
    }

    public void setSegmentVersion(SegmentVersion segmentVersion) {
        this._segmentVersion = segmentVersion;
    }

    public boolean isRealtimeOffHeapAllocation() {
        return this._isRealtimeOffHeapAllocation;
    }

    public boolean isDirectRealtimeOffHeapAllocation() {
        return this._isDirectRealtimeOffHeapAllocation;
    }

    public ColumnMinMaxValueGeneratorMode getColumnMinMaxValueGeneratorMode() {
        return this._columnMinMaxValueGeneratorMode;
    }

    public String getSegmentStoreURI() {
        return this._segmentStoreURI;
    }

    public int getRealtimeAvgMultiValueCount() {
        return this._realtimeAvgMultiValueCount;
    }

    public String getSegmentDirectoryLoader() {
        return StringUtils.isNotBlank((CharSequence)this._segmentDirectoryLoader) ? this._segmentDirectoryLoader : "default";
    }

    public PinotConfiguration getSegmentDirectoryConfigs() {
        HashMap<String, ReadMode> props = new HashMap<String, ReadMode>();
        props.put(READ_MODE_KEY, this._readMode);
        return new PinotConfiguration(props);
    }

    public String getInstanceId() {
        return this._instanceId;
    }

    public String getSegmentTier() {
        return this._segmentTier;
    }

    public void setSegmentTier(String segmentTier) {
        this._segmentTier = segmentTier;
        this._dirty = true;
    }

    public String getTableDataDir() {
        return this._tableDataDir;
    }

    public void setTableDataDir(String tableDataDir) {
        this._tableDataDir = tableDataDir;
    }

    public boolean isErrorOnColumnBuildFailure() {
        return this._errorOnColumnBuildFailure;
    }

    public void setErrorOnColumnBuildFailure(boolean errorOnColumnBuildFailure) {
        this._errorOnColumnBuildFailure = errorOnColumnBuildFailure;
    }

    @Nullable
    public FieldIndexConfigs getFieldIndexConfig(String columnName) {
        if (this._indexConfigsByColName == null || this._dirty) {
            this.refreshIndexConfigs();
        }
        return this._indexConfigsByColName.get(columnName);
    }

    public Map<String, FieldIndexConfigs> getFieldIndexConfigByColName() {
        if (this._indexConfigsByColName == null || this._dirty) {
            this.refreshIndexConfigs();
        }
        return this.unmodifiable(this._indexConfigsByColName);
    }

    private Set<String> getAllKnownColumns() {
        assert (this._tableConfig != null && this._schema == null);
        if (this._knownColumns == null) {
            Set knownColumns = this._tableConfig.getIndexingConfig().getAllReferencedColumns();
            List fieldConfigs = this._tableConfig.getFieldConfigList();
            if (fieldConfigs != null) {
                for (FieldConfig fieldConfig : fieldConfigs) {
                    knownColumns.add(fieldConfig.getName());
                }
            }
            this._knownColumns = knownColumns;
        }
        return this._knownColumns;
    }

    public Map<String, Map<String, String>> getInstanceTierConfigs() {
        return this.unmodifiable(this._instanceTierConfigs);
    }

    private <E> List<E> unmodifiable(List<E> list) {
        return list == null ? null : Collections.unmodifiableList(list);
    }

    private <E> Set<E> unmodifiable(Set<E> set) {
        return set == null ? null : Collections.unmodifiableSet(set);
    }

    private <K, V> Map<K, V> unmodifiable(Map<K, V> map) {
        return map == null ? null : Collections.unmodifiableMap(map);
    }

    public void addKnownColumns(Set<String> columns) {
        if (this._knownColumns == null) {
            this._knownColumns = new HashSet<String>(columns);
        } else {
            this._knownColumns.addAll(columns);
        }
        this._dirty = true;
    }
}

