/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader.columnminmaxvalue;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.segment.local.segment.creator.impl.SegmentColumnarIndexCreator;
import org.apache.pinot.segment.local.segment.index.forward.ForwardIndexReaderFactory;
import org.apache.pinot.segment.local.segment.index.loader.columnminmaxvalue.ColumnMinMaxValueGeneratorMode;
import org.apache.pinot.segment.local.segment.index.readers.BigDecimalDictionary;
import org.apache.pinot.segment.local.segment.index.readers.BytesDictionary;
import org.apache.pinot.segment.local.segment.index.readers.DoubleDictionary;
import org.apache.pinot.segment.local.segment.index.readers.FloatDictionary;
import org.apache.pinot.segment.local.segment.index.readers.IntDictionary;
import org.apache.pinot.segment.local.segment.index.readers.LongDictionary;
import org.apache.pinot.segment.local.segment.index.readers.StringDictionary;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.segment.spi.utils.SegmentMetadataUtils;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.ByteArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnMinMaxValueGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ColumnMinMaxValueGenerator.class);
    private final SegmentMetadata _segmentMetadata;
    private final SegmentDirectory.Writer _segmentWriter;
    private final ColumnMinMaxValueGeneratorMode _columnMinMaxValueGeneratorMode;
    private PropertiesConfiguration _segmentProperties;
    private boolean _minMaxValueAdded;

    public ColumnMinMaxValueGenerator(SegmentMetadata segmentMetadata, SegmentDirectory.Writer segmentWriter, ColumnMinMaxValueGeneratorMode columnMinMaxValueGeneratorMode) {
        this._segmentMetadata = segmentMetadata;
        this._segmentWriter = segmentWriter;
        this._columnMinMaxValueGeneratorMode = columnMinMaxValueGeneratorMode;
    }

    public List<String> columnMinMaxValueUpdates() {
        ArrayList<String> columns = new ArrayList<String>();
        for (String column : this.getColumnsToAddMinMaxValue()) {
            if (!this.needAddColumnMinMaxValueForColumn(column)) continue;
            columns.add(column);
        }
        return columns;
    }

    public void addColumnMinMaxValue() throws Exception {
        Preconditions.checkState((this._columnMinMaxValueGeneratorMode != ColumnMinMaxValueGeneratorMode.NONE ? 1 : 0) != 0);
        this._segmentProperties = SegmentMetadataUtils.getPropertiesConfiguration((SegmentMetadata)this._segmentMetadata);
        for (String column : this.getColumnsToAddMinMaxValue()) {
            this.addColumnMinMaxValueForColumn(column);
        }
        if (this._minMaxValueAdded) {
            SegmentMetadataUtils.savePropertiesConfiguration((PropertiesConfiguration)this._segmentProperties, (File)this._segmentMetadata.getIndexDir());
        }
    }

    private List<String> getColumnsToAddMinMaxValue() {
        Schema schema = this._segmentMetadata.getSchema();
        ArrayList<String> columnsToAddMinMaxValue = new ArrayList<String>();
        switch (this._columnMinMaxValueGeneratorMode) {
            case ALL: {
                for (FieldSpec fieldSpec : schema.getAllFieldSpecs()) {
                    if (fieldSpec.isVirtualColumn()) continue;
                    columnsToAddMinMaxValue.add(fieldSpec.getName());
                }
                break;
            }
            case NON_METRIC: {
                for (FieldSpec fieldSpec : schema.getAllFieldSpecs()) {
                    if (fieldSpec.isVirtualColumn() || fieldSpec.getFieldType() == FieldSpec.FieldType.METRIC) continue;
                    columnsToAddMinMaxValue.add(fieldSpec.getName());
                }
                break;
            }
            case TIME: {
                for (FieldSpec fieldSpec : schema.getAllFieldSpecs()) {
                    if (fieldSpec.isVirtualColumn() || fieldSpec.getFieldType() != FieldSpec.FieldType.TIME && fieldSpec.getFieldType() != FieldSpec.FieldType.DATE_TIME) continue;
                    columnsToAddMinMaxValue.add(fieldSpec.getName());
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported generator mode: " + this._columnMinMaxValueGeneratorMode);
            }
        }
        return columnsToAddMinMaxValue;
    }

    private boolean needAddColumnMinMaxValueForColumn(String columnName) {
        return this.needAddColumnMinMaxValueForColumn(this._segmentMetadata.getColumnMetadataFor(columnName));
    }

    private boolean needAddColumnMinMaxValueForColumn(ColumnMetadata columnMetadata) {
        return columnMetadata.getMinValue() == null && columnMetadata.getMaxValue() == null && !columnMetadata.isMinMaxValueInvalid();
    }

    private void addColumnMinMaxValueForColumn(String columnName) {
        ColumnMetadata columnMetadata = this._segmentMetadata.getColumnMetadataFor(columnName);
        if (!this.needAddColumnMinMaxValueForColumn(columnMetadata)) {
            return;
        }
        try {
            if (columnMetadata.hasDictionary()) {
                this.addColumnMinMaxValueWithDictionary(columnMetadata);
            } else {
                this.addColumnMinMaxValueWithoutDictionary(columnMetadata);
            }
            this._minMaxValueAdded = true;
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while generating min/max value for column: {} in segment: {}, continuing without persisting them", new Object[]{columnName, this._segmentMetadata.getName(), e});
        }
    }

    private void addColumnMinMaxValueWithDictionary(ColumnMetadata columnMetadata) throws IOException {
        try (Dictionary dictionary = this.getDictionaryForColumn(columnMetadata);){
            SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnMetadata.getColumnName(), dictionary.getInternal(0), dictionary.getInternal(dictionary.length() - 1), columnMetadata.getDataType().getStoredType());
        }
    }

    private Dictionary getDictionaryForColumn(ColumnMetadata columnMetadata) throws IOException {
        String columnName = columnMetadata.getColumnName();
        FieldSpec.DataType dataType = columnMetadata.getDataType();
        PinotDataBuffer dictionaryBuffer = this._segmentWriter.getIndexFor(columnName, StandardIndexes.dictionary());
        int length = columnMetadata.getCardinality();
        switch (dataType.getStoredType()) {
            case INT: {
                return new IntDictionary(dictionaryBuffer, length);
            }
            case LONG: {
                return new LongDictionary(dictionaryBuffer, length);
            }
            case FLOAT: {
                return new FloatDictionary(dictionaryBuffer, length);
            }
            case DOUBLE: {
                return new DoubleDictionary(dictionaryBuffer, length);
            }
            case BIG_DECIMAL: {
                return new BigDecimalDictionary(dictionaryBuffer, length, columnMetadata.getColumnMaxLength());
            }
            case STRING: {
                return new StringDictionary(dictionaryBuffer, length, columnMetadata.getColumnMaxLength());
            }
            case BYTES: {
                return new BytesDictionary(dictionaryBuffer, length, columnMetadata.getColumnMaxLength());
            }
        }
        throw new IllegalStateException("Unsupported data type: " + dataType + " for column: " + columnName);
    }

    private void addColumnMinMaxValueWithoutDictionary(ColumnMetadata columnMetadata) throws IOException {
        String columnName = columnMetadata.getColumnName();
        FieldSpec.DataType dataType = columnMetadata.getDataType();
        FieldSpec.DataType storedType = dataType.getStoredType();
        boolean isSingleValue = columnMetadata.isSingleValue();
        PinotDataBuffer rawIndexBuffer = this._segmentWriter.getIndexFor(columnName, StandardIndexes.forward());
        try (ForwardIndexReader rawIndexReader = ForwardIndexReaderFactory.createRawIndexReader(rawIndexBuffer, storedType, isSingleValue);
             ForwardIndexReaderContext readerContext = rawIndexReader.createContext();){
            Number maxValue;
            Number minValue;
            int numDocs = columnMetadata.getTotalDocs();
            switch (storedType) {
                case INT: {
                    int min = Integer.MAX_VALUE;
                    int max = Integer.MIN_VALUE;
                    if (isSingleValue) {
                        for (int docId = 0; docId < numDocs; ++docId) {
                            int value = rawIndexReader.getInt(docId, readerContext);
                            min = Math.min(min, value);
                            max = Math.max(max, value);
                        }
                    } else {
                        for (int docId = 0; docId < numDocs; ++docId) {
                            int[] values;
                            for (int value : values = rawIndexReader.getIntMV(docId, readerContext)) {
                                min = Math.min(min, value);
                                max = Math.max(max, value);
                            }
                        }
                    }
                    minValue = min;
                    maxValue = max;
                    break;
                }
                case LONG: {
                    long min = Long.MAX_VALUE;
                    long max = Long.MIN_VALUE;
                    if (isSingleValue) {
                        for (int docId = 0; docId < numDocs; ++docId) {
                            long value = rawIndexReader.getLong(docId, readerContext);
                            min = Math.min(min, value);
                            max = Math.max(max, value);
                        }
                    } else {
                        for (int docId = 0; docId < numDocs; ++docId) {
                            long[] values;
                            for (long value : values = rawIndexReader.getLongMV(docId, readerContext)) {
                                min = Math.min(min, value);
                                max = Math.max(max, value);
                            }
                        }
                    }
                    minValue = min;
                    maxValue = max;
                    break;
                }
                case FLOAT: {
                    float min = Float.POSITIVE_INFINITY;
                    float max = Float.NEGATIVE_INFINITY;
                    if (isSingleValue) {
                        for (int docId = 0; docId < numDocs; ++docId) {
                            float value = rawIndexReader.getFloat(docId, readerContext);
                            min = Math.min(min, value);
                            max = Math.max(max, value);
                        }
                    } else {
                        for (int docId = 0; docId < numDocs; ++docId) {
                            float[] values;
                            for (float value : values = rawIndexReader.getFloatMV(docId, readerContext)) {
                                min = Math.min(min, value);
                                max = Math.max(max, value);
                            }
                        }
                    }
                    minValue = Float.valueOf(min);
                    maxValue = Float.valueOf(max);
                    break;
                }
                case DOUBLE: {
                    double min = Double.POSITIVE_INFINITY;
                    double max = Double.NEGATIVE_INFINITY;
                    if (isSingleValue) {
                        for (int docId = 0; docId < numDocs; ++docId) {
                            double value = rawIndexReader.getDouble(docId, readerContext);
                            min = Math.min(min, value);
                            max = Math.max(max, value);
                        }
                    } else {
                        for (int docId = 0; docId < numDocs; ++docId) {
                            double[] values;
                            for (double value : values = rawIndexReader.getDoubleMV(docId, readerContext)) {
                                min = Math.min(min, value);
                                max = Math.max(max, value);
                            }
                        }
                    }
                    minValue = min;
                    maxValue = max;
                    break;
                }
                case BIG_DECIMAL: {
                    Preconditions.checkState((boolean)isSingleValue, (String)"Unsupported multi-value BIG_DECIMAL column: %s", (Object)columnName);
                    BigDecimal min = null;
                    BigDecimal max = null;
                    for (int docId = 0; docId < numDocs; ++docId) {
                        BigDecimal value = rawIndexReader.getBigDecimal(docId, readerContext);
                        if (min == null || min.compareTo(value) > 0) {
                            min = value;
                        }
                        if (max != null && max.compareTo(value) >= 0) continue;
                        max = value;
                    }
                    minValue = min;
                    maxValue = max;
                    break;
                }
                case STRING: {
                    Object min = null;
                    Object max = null;
                    if (isSingleValue) {
                        for (int docId = 0; docId < numDocs; ++docId) {
                            String value = rawIndexReader.getString(docId, readerContext);
                            if (min == null || StringUtils.compare((String)min, (String)value) > 0) {
                                min = value;
                            }
                            if (max != null && StringUtils.compare((String)max, (String)value) >= 0) continue;
                            max = value;
                        }
                    } else {
                        for (int docId = 0; docId < numDocs; ++docId) {
                            String[] values;
                            for (String value : values = rawIndexReader.getStringMV(docId, readerContext)) {
                                if (min == null || StringUtils.compare((String)min, (String)value) > 0) {
                                    min = value;
                                }
                                if (max != null && StringUtils.compare((String)max, (String)value) >= 0) continue;
                                max = value;
                            }
                        }
                    }
                    minValue = min;
                    maxValue = max;
                    break;
                }
                case BYTES: {
                    byte[] min = null;
                    byte[] max = null;
                    if (isSingleValue) {
                        for (int docId = 0; docId < numDocs; ++docId) {
                            byte[] value = rawIndexReader.getBytes(docId, readerContext);
                            if (min == null || ByteArray.compare((byte[])value, (byte[])min) > 0) {
                                min = value;
                            }
                            if (max != null && ByteArray.compare((byte[])value, (byte[])max) >= 0) continue;
                            max = value;
                        }
                    } else {
                        for (int docId = 0; docId < numDocs; ++docId) {
                            byte[][] values;
                            for (byte[] value : values = rawIndexReader.getBytesMV(docId, readerContext)) {
                                if (min == null || ByteArray.compare((byte[])value, (byte[])min) > 0) {
                                    min = value;
                                }
                                if (max != null && ByteArray.compare((byte[])value, (byte[])max) >= 0) continue;
                                max = value;
                            }
                        }
                    }
                    minValue = new ByteArray(min);
                    maxValue = new ByteArray(max);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported data type: " + dataType + " for column: " + columnName);
                }
            }
            SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, minValue, maxValue, storedType);
        }
    }
}

