/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader.defaultcolumn;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.pinot.common.function.FunctionUtils;
import org.apache.pinot.common.utils.PinotDataType;
import org.apache.pinot.segment.local.function.FunctionEvaluator;
import org.apache.pinot.segment.local.function.FunctionEvaluatorFactory;
import org.apache.pinot.segment.local.segment.creator.impl.SegmentColumnarIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.SegmentDictionaryCreator;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.MultiValueUnsortedForwardIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.SingleValueSortedForwardIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.inv.OffHeapBitmapInvertedIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.nullvalue.NullValueVectorCreator;
import org.apache.pinot.segment.local.segment.creator.impl.stats.AbstractColumnStatisticsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.BytesColumnPredIndexStatsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.DoubleColumnPreIndexStatsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.FloatColumnPreIndexStatsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.IntColumnPreIndexStatsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.LongColumnPreIndexStatsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.StringColumnPreIndexStatsCollector;
import org.apache.pinot.segment.local.segment.index.dictionary.DictionaryIndexType;
import org.apache.pinot.segment.local.segment.index.forward.ForwardIndexCreatorFactory;
import org.apache.pinot.segment.local.segment.index.forward.ForwardIndexPlugin;
import org.apache.pinot.segment.local.segment.index.forward.ForwardIndexType;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.LoaderUtils;
import org.apache.pinot.segment.local.segment.index.loader.defaultcolumn.DefaultColumnHandler;
import org.apache.pinot.segment.local.segment.index.loader.defaultcolumn.DefaultColumnStatistics;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentColumnReader;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.segment.spi.creator.ColumnIndexCreationInfo;
import org.apache.pinot.segment.spi.creator.ColumnStatistics;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.creator.StatsCollectorConfig;
import org.apache.pinot.segment.spi.index.DictionaryIndexConfig;
import org.apache.pinot.segment.spi.index.FieldIndexConfigs;
import org.apache.pinot.segment.spi.index.ForwardIndexConfig;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.creator.ForwardIndexCreator;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.segment.spi.utils.SegmentMetadataUtils;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.ingestion.TransformConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.ByteArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDefaultColumnHandler
implements DefaultColumnHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseDefaultColumnHandler.class);
    protected final File _indexDir;
    protected final SegmentMetadata _segmentMetadata;
    protected final IndexLoadingConfig _indexLoadingConfig;
    protected final Schema _schema;
    protected final SegmentDirectory.Writer _segmentWriter;
    private PropertiesConfiguration _segmentProperties;

    protected BaseDefaultColumnHandler(File indexDir, SegmentMetadata segmentMetadata, IndexLoadingConfig indexLoadingConfig, Schema schema, SegmentDirectory.Writer segmentWriter) {
        this._indexDir = indexDir;
        this._segmentMetadata = segmentMetadata;
        this._indexLoadingConfig = indexLoadingConfig;
        this._schema = schema;
        this._segmentWriter = segmentWriter;
    }

    @Override
    public boolean needUpdateDefaultColumns() {
        Map<String, DefaultColumnAction> defaultColumnActionMap = this.computeDefaultColumnActionMap();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Need to update default columns with actionMap: {}", defaultColumnActionMap);
        }
        return !defaultColumnActionMap.isEmpty();
    }

    @Override
    public void updateDefaultColumns() throws Exception {
        Map<String, DefaultColumnAction> defaultColumnActionMap = this.computeDefaultColumnActionMap();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Update default columns with actionMap: {}", defaultColumnActionMap);
        }
        if (defaultColumnActionMap.isEmpty()) {
            return;
        }
        this._segmentProperties = SegmentMetadataUtils.getPropertiesConfiguration((SegmentMetadata)this._segmentMetadata);
        Iterator<Map.Entry<String, DefaultColumnAction>> entryIterator = defaultColumnActionMap.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<String, DefaultColumnAction> entry = entryIterator.next();
            if (this.updateDefaultColumn(entry.getKey(), entry.getValue())) continue;
            entryIterator.remove();
        }
        List<String> dimensionColumns = LoaderUtils.getStringListFromSegmentProperties("segment.dimension.column.names", this._segmentProperties);
        List<String> metricColumns = LoaderUtils.getStringListFromSegmentProperties("segment.metric.column.names", this._segmentProperties);
        List<String> dateTimeColumns = LoaderUtils.getStringListFromSegmentProperties("segment.datetime.column.names", this._segmentProperties);
        List<String> complexColumns = LoaderUtils.getStringListFromSegmentProperties("segment.complex.column.names", this._segmentProperties);
        for (Map.Entry<String, DefaultColumnAction> entry : defaultColumnActionMap.entrySet()) {
            String column = entry.getKey();
            DefaultColumnAction action = entry.getValue();
            switch (action) {
                case ADD_DIMENSION: {
                    dimensionColumns.add(column);
                    break;
                }
                case ADD_METRIC: {
                    metricColumns.add(column);
                    break;
                }
                case ADD_DATE_TIME: {
                    dateTimeColumns.add(column);
                    break;
                }
                case ADD_COMPLEX: {
                    complexColumns.add(column);
                    break;
                }
                case REMOVE_DIMENSION: {
                    dimensionColumns.remove(column);
                    break;
                }
                case REMOVE_METRIC: {
                    metricColumns.remove(column);
                    break;
                }
                case REMOVE_DATE_TIME: {
                    dateTimeColumns.remove(column);
                    break;
                }
                case REMOVE_COMPLEX: {
                    complexColumns.remove(column);
                    break;
                }
            }
        }
        this._segmentProperties.setProperty("segment.dimension.column.names", dimensionColumns);
        this._segmentProperties.setProperty("segment.metric.column.names", metricColumns);
        this._segmentProperties.setProperty("segment.datetime.column.names", dateTimeColumns);
        this._segmentProperties.setProperty("segment.complex.column.names", complexColumns);
        SegmentMetadataUtils.savePropertiesConfiguration((PropertiesConfiguration)this._segmentProperties, (File)this._segmentMetadata.getIndexDir());
    }

    @VisibleForTesting
    Map<String, DefaultColumnAction> computeDefaultColumnActionMap() {
        String column;
        HashMap<String, DefaultColumnAction> defaultColumnActionMap = new HashMap<String, DefaultColumnAction>();
        block6: for (FieldSpec fieldSpecInSchema : this._schema.getAllFieldSpecs()) {
            if (fieldSpecInSchema.isVirtualColumn()) continue;
            column = fieldSpecInSchema.getName();
            FieldSpec.FieldType fieldTypeInSchema = fieldSpecInSchema.getFieldType();
            ColumnMetadata columnMetadata = this._segmentMetadata.getColumnMetadataFor(column);
            if (columnMetadata != null) {
                if (!columnMetadata.isAutoGenerated()) continue;
                FieldSpec fieldSpecInMetadata = columnMetadata.getFieldSpec();
                FieldSpec.FieldType fieldTypeInMetadata = fieldSpecInMetadata.getFieldType();
                if (fieldTypeInMetadata != fieldTypeInSchema) {
                    String failureMessage = "Field type: " + fieldTypeInMetadata + " for auto-generated column: " + column + " does not match field type: " + fieldTypeInSchema + " in schema, throw exception to drop and re-download the segment.";
                    throw new RuntimeException(failureMessage);
                }
                FieldSpec.DataType dataTypeInMetadata = fieldSpecInMetadata.getDataType();
                FieldSpec.DataType dataTypeInSchema = fieldSpecInSchema.getDataType();
                boolean isSingleValueInMetadata = fieldSpecInMetadata.isSingleValueField();
                boolean isSingleValueInSchema = fieldSpecInSchema.isSingleValueField();
                String defaultValueInMetadata = fieldSpecInMetadata.getDefaultNullValueString();
                String defaultValueInSchema = fieldSpecInSchema.getDefaultNullValueString();
                if (fieldTypeInMetadata == FieldSpec.FieldType.DIMENSION) {
                    if (dataTypeInMetadata != dataTypeInSchema) {
                        defaultColumnActionMap.put(column, DefaultColumnAction.UPDATE_DIMENSION_DATA_TYPE);
                        continue;
                    }
                    if (!defaultValueInSchema.equals(defaultValueInMetadata)) {
                        defaultColumnActionMap.put(column, DefaultColumnAction.UPDATE_DIMENSION_DEFAULT_VALUE);
                        continue;
                    }
                    if (isSingleValueInMetadata == isSingleValueInSchema) continue;
                    defaultColumnActionMap.put(column, DefaultColumnAction.UPDATE_DIMENSION_NUMBER_OF_VALUES);
                    continue;
                }
                if (fieldTypeInMetadata == FieldSpec.FieldType.METRIC) {
                    if (dataTypeInMetadata != dataTypeInSchema) {
                        defaultColumnActionMap.put(column, DefaultColumnAction.UPDATE_METRIC_DATA_TYPE);
                        continue;
                    }
                    if (!defaultValueInSchema.equals(defaultValueInMetadata)) {
                        defaultColumnActionMap.put(column, DefaultColumnAction.UPDATE_METRIC_DEFAULT_VALUE);
                        continue;
                    }
                    if (isSingleValueInMetadata == isSingleValueInSchema) continue;
                    defaultColumnActionMap.put(column, DefaultColumnAction.UPDATE_METRIC_NUMBER_OF_VALUES);
                    continue;
                }
                if (fieldTypeInMetadata == FieldSpec.FieldType.DATE_TIME) {
                    if (dataTypeInMetadata != dataTypeInSchema) {
                        defaultColumnActionMap.put(column, DefaultColumnAction.UPDATE_DATE_TIME_DATA_TYPE);
                        continue;
                    }
                    if (defaultValueInSchema.equals(defaultValueInMetadata)) continue;
                    defaultColumnActionMap.put(column, DefaultColumnAction.UPDATE_DATE_TIME_DEFAULT_VALUE);
                    continue;
                }
                if (fieldTypeInMetadata != FieldSpec.FieldType.COMPLEX) continue;
                if (dataTypeInMetadata != dataTypeInSchema) {
                    defaultColumnActionMap.put(column, DefaultColumnAction.UPDATE_COMPLEX_DATA_TYPE);
                    continue;
                }
                if (defaultValueInSchema.equals(defaultValueInMetadata)) continue;
                defaultColumnActionMap.put(column, DefaultColumnAction.UPDATE_COMPLEX_DEFAULT_VALUE);
                continue;
            }
            switch (fieldTypeInSchema) {
                case DIMENSION: {
                    defaultColumnActionMap.put(column, DefaultColumnAction.ADD_DIMENSION);
                    continue block6;
                }
                case METRIC: {
                    defaultColumnActionMap.put(column, DefaultColumnAction.ADD_METRIC);
                    continue block6;
                }
                case DATE_TIME: {
                    defaultColumnActionMap.put(column, DefaultColumnAction.ADD_DATE_TIME);
                    continue block6;
                }
                case COMPLEX: {
                    defaultColumnActionMap.put(column, DefaultColumnAction.ADD_COMPLEX);
                    continue block6;
                }
            }
            LOGGER.warn("Skip adding default column for column: {} with field type: {}", (Object)column, (Object)fieldTypeInSchema);
        }
        for (ColumnMetadata columnMetadata : this._segmentMetadata.getColumnMetadataMap().values()) {
            column = columnMetadata.getColumnName();
            if (this._schema.hasColumn(column) || !columnMetadata.isAutoGenerated()) continue;
            FieldSpec.FieldType fieldTypeInMetadata = columnMetadata.getFieldSpec().getFieldType();
            if (fieldTypeInMetadata == FieldSpec.FieldType.DIMENSION) {
                defaultColumnActionMap.put(column, DefaultColumnAction.REMOVE_DIMENSION);
                continue;
            }
            if (fieldTypeInMetadata == FieldSpec.FieldType.METRIC) {
                defaultColumnActionMap.put(column, DefaultColumnAction.REMOVE_METRIC);
                continue;
            }
            if (fieldTypeInMetadata == FieldSpec.FieldType.DATE_TIME) {
                defaultColumnActionMap.put(column, DefaultColumnAction.REMOVE_DATE_TIME);
                continue;
            }
            if (fieldTypeInMetadata != FieldSpec.FieldType.COMPLEX) continue;
            defaultColumnActionMap.put(column, DefaultColumnAction.REMOVE_COMPLEX);
        }
        return defaultColumnActionMap;
    }

    protected abstract boolean updateDefaultColumn(String var1, DefaultColumnAction var2) throws Exception;

    protected void removeColumnIndices(String column) throws IOException {
        String segmentName = this._segmentMetadata.getName();
        LOGGER.info("Removing default column: {} from segment: {}", (Object)column, (Object)segmentName);
        this._segmentWriter.removeIndex(column, StandardIndexes.dictionary());
        this._segmentWriter.removeIndex(column, StandardIndexes.forward());
        SegmentColumnarIndexCreator.removeColumnMetadataInfo(this._segmentProperties, column);
        LOGGER.info("Removed default column: {} from segment: {}", (Object)column, (Object)segmentName);
    }

    protected boolean createColumnV1Indices(String column) throws Exception {
        TableConfig tableConfig = this._indexLoadingConfig.getTableConfig();
        boolean errorOnFailure = this._indexLoadingConfig.isErrorOnColumnBuildFailure();
        if (tableConfig != null && tableConfig.getIngestionConfig() != null && tableConfig.getIngestionConfig().getTransformConfigs() != null) {
            List transformConfigs = tableConfig.getIngestionConfig().getTransformConfigs();
            for (TransformConfig transformConfig : transformConfigs) {
                if (!transformConfig.getColumnName().equals(column)) continue;
                String transformFunction = transformConfig.getTransformFunction();
                FunctionEvaluator functionEvaluator = FunctionEvaluatorFactory.getExpressionEvaluator(transformFunction);
                List<String> arguments = functionEvaluator.getArguments();
                ArrayList<ColumnMetadata> argumentsMetadata = new ArrayList<ColumnMetadata>(arguments.size());
                for (String argument : arguments) {
                    ColumnMetadata columnMetadata = this._segmentMetadata.getColumnMetadataFor(argument);
                    if (columnMetadata == null) {
                        LOGGER.warn("Assigning default value to derived column: {} because argument: {} does not exist in the segment", (Object)column, (Object)argument);
                        this.createDefaultValueColumnV1Indices(column);
                        return true;
                    }
                    if (!this._segmentWriter.hasIndexFor(argument, StandardIndexes.forward())) {
                        throw new UnsupportedOperationException(String.format("Operation not supported! Cannot create a derived column %s because argument: %s does not have a forward index. Enable forward index and refresh/backfill the segments to create a derived column from source column %s", column, argument, argument));
                    }
                    argumentsMetadata.add(columnMetadata);
                }
                if (this.isForwardIndexDisabled(column)) {
                    LOGGER.warn("Skip creating forward index disabled derived column: {}", (Object)column);
                    if (errorOnFailure) {
                        throw new UnsupportedOperationException(String.format("Failed to create forward index disabled derived column: %s", column));
                    }
                    return false;
                }
                try {
                    this.createDerivedColumnV1Indices(column, functionEvaluator, argumentsMetadata, errorOnFailure);
                    return true;
                }
                catch (Exception e) {
                    LOGGER.error("Caught exception while creating derived column: {} with transform function: {}", new Object[]{column, transformFunction, e});
                    if (errorOnFailure) {
                        throw e;
                    }
                    return false;
                }
            }
        }
        this.createDefaultValueColumnV1Indices(column);
        return true;
    }

    protected boolean isForwardIndexDisabled(String column) {
        FieldIndexConfigs fieldIndexConfig = this._indexLoadingConfig.getFieldIndexConfig(column);
        return fieldIndexConfig != null && ((ForwardIndexConfig)fieldIndexConfig.getConfig(StandardIndexes.forward())).isDisabled();
    }

    private void createDefaultValueColumnV1Indices(String column) throws Exception {
        int docId;
        int[] dictIds;
        int dictionaryElementSize;
        Object[] sortedArray;
        FieldSpec fieldSpec = this._schema.getFieldSpecFor(column);
        int totalDocs = this._segmentMetadata.getTotalDocs();
        FieldSpec.DataType dataType = fieldSpec.getDataType();
        Object defaultValue = fieldSpec.getDefaultNullValue();
        boolean isSingleValue = fieldSpec.isSingleValueField();
        int maxNumberOfMultiValueElements = isSingleValue ? 0 : 1;
        switch (dataType.getStoredType()) {
            case INT: {
                Preconditions.checkState((boolean)(defaultValue instanceof Integer));
                sortedArray = new int[]{(Integer)defaultValue};
                break;
            }
            case LONG: {
                Preconditions.checkState((boolean)(defaultValue instanceof Long));
                sortedArray = new long[]{(Long)defaultValue};
                break;
            }
            case FLOAT: {
                Preconditions.checkState((boolean)(defaultValue instanceof Float));
                sortedArray = new float[]{((Float)defaultValue).floatValue()};
                break;
            }
            case DOUBLE: {
                Preconditions.checkState((boolean)(defaultValue instanceof Double));
                sortedArray = new double[]{(Double)defaultValue};
                break;
            }
            case BIG_DECIMAL: {
                Preconditions.checkState((boolean)(defaultValue instanceof BigDecimal));
                sortedArray = new BigDecimal[]{(BigDecimal)defaultValue};
                break;
            }
            case STRING: {
                Preconditions.checkState((boolean)(defaultValue instanceof String));
                sortedArray = new String[]{(String)defaultValue};
                break;
            }
            case BYTES: {
                Preconditions.checkState((boolean)(defaultValue instanceof byte[]));
                ByteArray bytesDefaultValue = new ByteArray((byte[])defaultValue);
                defaultValue = bytesDefaultValue;
                sortedArray = new ByteArray[]{bytesDefaultValue};
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type: " + dataType + " for column: " + column);
            }
        }
        DefaultColumnStatistics columnStatistics = new DefaultColumnStatistics(defaultValue, defaultValue, sortedArray, isSingleValue, totalDocs, maxNumberOfMultiValueElements);
        ColumnIndexCreationInfo columnIndexCreationInfo = new ColumnIndexCreationInfo((ColumnStatistics)columnStatistics, true, false, true, defaultValue);
        try (SegmentDictionaryCreator creator = new SegmentDictionaryCreator(fieldSpec, this._indexDir, false);){
            creator.build(sortedArray);
            dictionaryElementSize = creator.getNumBytesPerEntry();
        }
        if (isSingleValue) {
            try (SingleValueSortedForwardIndexCreator svFwdIndexCreator = new SingleValueSortedForwardIndexCreator(this._indexDir, fieldSpec.getName(), 1);){
                for (int docId2 = 0; docId2 < totalDocs; ++docId2) {
                    svFwdIndexCreator.putDictId(0);
                }
            }
        }
        boolean forwardIndexDisabled = this.isForwardIndexDisabled(column);
        if (forwardIndexDisabled) {
            try (OffHeapBitmapInvertedIndexCreator creator = new OffHeapBitmapInvertedIndexCreator(this._indexDir, fieldSpec, 1, totalDocs, totalDocs);){
                dictIds = new int[]{0};
                for (docId = 0; docId < totalDocs; ++docId) {
                    creator.add(dictIds, 1);
                }
                creator.seal();
            }
        }
        try (MultiValueUnsortedForwardIndexCreator mvFwdIndexCreator = new MultiValueUnsortedForwardIndexCreator(this._indexDir, fieldSpec.getName(), 1, totalDocs, totalDocs);){
            dictIds = new int[]{0};
            for (docId = 0; docId < totalDocs; ++docId) {
                mvFwdIndexCreator.putDictIdMV(dictIds);
            }
        }
        if (this.isNullable(fieldSpec) && !this._segmentWriter.hasIndexFor(column, StandardIndexes.nullValueVector())) {
            try (NullValueVectorCreator nullValueVectorCreator = new NullValueVectorCreator(this._indexDir, fieldSpec.getName());){
                for (int docId3 = 0; docId3 < totalDocs; ++docId3) {
                    nullValueVectorCreator.setNull(docId3);
                }
                nullValueVectorCreator.seal();
            }
        }
        SegmentColumnarIndexCreator.addColumnMetadataInfo(this._segmentProperties, column, columnIndexCreationInfo, totalDocs, fieldSpec, true, dictionaryElementSize);
    }

    private boolean isNullable(FieldSpec fieldSpec) {
        if (this._schema.isEnableColumnBasedNullHandling()) {
            return fieldSpec.isNullable();
        }
        return this._indexLoadingConfig.getTableConfig() != null && this._indexLoadingConfig.getTableConfig().getIndexingConfig() != null && this._indexLoadingConfig.getTableConfig().getIndexingConfig().isNullHandlingEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDerivedColumnV1Indices(String column, FunctionEvaluator functionEvaluator, List<ColumnMetadata> argumentsMetadata, boolean errorOnFailure) throws Exception {
        int numArguments = argumentsMetadata.size();
        ArrayList<ValueReader> valueReaders = new ArrayList<ValueReader>(numArguments);
        for (ColumnMetadata argumentMetadata : argumentsMetadata) {
            valueReaders.add(new ValueReader(argumentMetadata));
        }
        FieldSpec fieldSpec = this._schema.getFieldSpecFor(column);
        NullValueVectorCreator nullValueVectorCreator = null;
        if (this.isNullable(fieldSpec)) {
            nullValueVectorCreator = new NullValueVectorCreator(this._indexDir, fieldSpec.getName());
        }
        int functionEvaluateErrorCount = 0;
        Exception functionEvalError = null;
        Object[] inputValuesWithError = null;
        try {
            ColumnIndexCreationInfo indexCreationInfo;
            FieldIndexConfigs fieldIndexConfigs;
            Object[] inputValues = new Object[numArguments];
            int numDocs = this._segmentMetadata.getTotalDocs();
            Object[] outputValues = new Object[numDocs];
            PinotDataType outputValueType = null;
            for (int i = 0; i < numDocs; ++i) {
                for (int j = 0; j < numArguments; ++j) {
                    inputValues[j] = ((ValueReader)valueReaders.get(j)).getValue(i);
                }
                Object outputValue = null;
                try {
                    outputValue = functionEvaluator.evaluate(inputValues);
                }
                catch (Exception e) {
                    if (!errorOnFailure) {
                        LOGGER.debug("Encountered an exception while evaluating function {} for derived column {} with arguments: {}", new Object[]{functionEvaluator, column, Arrays.toString(inputValues), e});
                        ++functionEvaluateErrorCount;
                        if (functionEvalError == null) {
                            functionEvalError = e;
                            inputValuesWithError = Arrays.copyOf(inputValues, inputValues.length);
                        }
                    }
                    throw e;
                }
                if (outputValue == null) {
                    outputValue = fieldSpec.getDefaultNullValue();
                    if (nullValueVectorCreator != null) {
                        nullValueVectorCreator.setNull(i);
                    }
                } else if (outputValueType == null) {
                    Class<?> outputValueClass = outputValue.getClass();
                    outputValueType = FunctionUtils.getArgumentType(outputValueClass);
                    Preconditions.checkState((outputValueType != null ? 1 : 0) != 0, (String)"Unsupported output value class: %s", outputValueClass);
                }
                outputValues[i] = outputValue;
            }
            if (functionEvaluateErrorCount > 0) {
                LOGGER.warn("Caught {} exceptions while evaluating derived column: {} with function: {}. The first input value tuple that led to an error is: {}", new Object[]{functionEvaluateErrorCount, column, functionEvaluator, Arrays.toString(inputValuesWithError), functionEvalError});
            }
            if (nullValueVectorCreator != null) {
                nullValueVectorCreator.seal();
            }
            DictionaryIndexConfig dictionaryIndexConfig = (fieldIndexConfigs = this._indexLoadingConfig.getFieldIndexConfig(column)) != null ? (DictionaryIndexConfig)fieldIndexConfigs.getConfig(StandardIndexes.dictionary()) : DictionaryIndexConfig.DEFAULT;
            boolean createDictionary = dictionaryIndexConfig.isEnabled();
            StatsCollectorConfig statsCollectorConfig = new StatsCollectorConfig(this._indexLoadingConfig.getTableConfig(), this._schema, null);
            boolean isSingleValue = fieldSpec.isSingleValueField();
            switch (fieldSpec.getDataType().getStoredType()) {
                case INT: {
                    for (int i = 0; i < numDocs; ++i) {
                        outputValues[i] = this.getIntOutputValue(outputValues[i], isSingleValue, outputValueType, (Integer)fieldSpec.getDefaultNullValue(), createDictionary);
                    }
                    AbstractColumnStatisticsCollector statsCollector = new IntColumnPreIndexStatsCollector(column, statsCollectorConfig);
                    for (Object value : outputValues) {
                        ((IntColumnPreIndexStatsCollector)statsCollector).collect(value);
                    }
                    ((IntColumnPreIndexStatsCollector)statsCollector).seal();
                    indexCreationInfo = new ColumnIndexCreationInfo((ColumnStatistics)statsCollector, createDictionary, false, true, fieldSpec.getDefaultNullValue());
                    break;
                }
                case LONG: {
                    for (int i = 0; i < numDocs; ++i) {
                        outputValues[i] = this.getLongOutputValue(outputValues[i], isSingleValue, outputValueType, (Long)fieldSpec.getDefaultNullValue(), createDictionary);
                    }
                    AbstractColumnStatisticsCollector statsCollector = new LongColumnPreIndexStatsCollector(column, statsCollectorConfig);
                    for (Object value : outputValues) {
                        ((LongColumnPreIndexStatsCollector)statsCollector).collect(value);
                    }
                    ((LongColumnPreIndexStatsCollector)statsCollector).seal();
                    indexCreationInfo = new ColumnIndexCreationInfo((ColumnStatistics)statsCollector, createDictionary, false, true, fieldSpec.getDefaultNullValue());
                    break;
                }
                case FLOAT: {
                    for (int i = 0; i < numDocs; ++i) {
                        outputValues[i] = this.getFloatOutputValue(outputValues[i], isSingleValue, outputValueType, (Float)fieldSpec.getDefaultNullValue(), createDictionary);
                    }
                    AbstractColumnStatisticsCollector statsCollector = new FloatColumnPreIndexStatsCollector(column, statsCollectorConfig);
                    for (Object value : outputValues) {
                        ((FloatColumnPreIndexStatsCollector)statsCollector).collect(value);
                    }
                    ((FloatColumnPreIndexStatsCollector)statsCollector).seal();
                    indexCreationInfo = new ColumnIndexCreationInfo((ColumnStatistics)statsCollector, createDictionary, false, true, fieldSpec.getDefaultNullValue());
                    break;
                }
                case DOUBLE: {
                    for (int i = 0; i < numDocs; ++i) {
                        outputValues[i] = this.getDoubleOutputValue(outputValues[i], isSingleValue, outputValueType, (Double)fieldSpec.getDefaultNullValue(), createDictionary);
                    }
                    AbstractColumnStatisticsCollector statsCollector = new DoubleColumnPreIndexStatsCollector(column, statsCollectorConfig);
                    for (Object value : outputValues) {
                        ((DoubleColumnPreIndexStatsCollector)statsCollector).collect(value);
                    }
                    ((DoubleColumnPreIndexStatsCollector)statsCollector).seal();
                    indexCreationInfo = new ColumnIndexCreationInfo((ColumnStatistics)statsCollector, createDictionary, false, true, fieldSpec.getDefaultNullValue());
                    break;
                }
                case BIG_DECIMAL: {
                    for (int i = 0; i < numDocs; ++i) {
                        Preconditions.checkState((boolean)isSingleValue, (Object)"MV BIG_DECIMAL is not supported");
                        if (outputValueType == null || outputValues[i] instanceof BigDecimal) continue;
                        outputValues[i] = outputValueType.toBigDecimal(outputValues[i]);
                    }
                    AbstractColumnStatisticsCollector statsCollector = new DoubleColumnPreIndexStatsCollector(column, statsCollectorConfig);
                    for (Object value : outputValues) {
                        ((DoubleColumnPreIndexStatsCollector)statsCollector).collect(value);
                    }
                    ((DoubleColumnPreIndexStatsCollector)statsCollector).seal();
                    indexCreationInfo = new ColumnIndexCreationInfo((ColumnStatistics)statsCollector, createDictionary, false, true, fieldSpec.getDefaultNullValue());
                    break;
                }
                case STRING: {
                    for (int i = 0; i < numDocs; ++i) {
                        outputValues[i] = this.getStringOutputValue(outputValues[i], isSingleValue, outputValueType, (String)fieldSpec.getDefaultNullValue());
                    }
                    AbstractColumnStatisticsCollector statsCollector = new StringColumnPreIndexStatsCollector(column, statsCollectorConfig);
                    for (Object value : outputValues) {
                        ((StringColumnPreIndexStatsCollector)statsCollector).collect(value);
                    }
                    ((StringColumnPreIndexStatsCollector)statsCollector).seal();
                    indexCreationInfo = new ColumnIndexCreationInfo((ColumnStatistics)statsCollector, createDictionary, dictionaryIndexConfig.getUseVarLengthDictionary(), true, fieldSpec.getDefaultNullValue());
                    break;
                }
                case BYTES: {
                    for (int i = 0; i < numDocs; ++i) {
                        outputValues[i] = this.getBytesOutputValue(outputValues[i], isSingleValue, outputValueType, (byte[])fieldSpec.getDefaultNullValue());
                    }
                    AbstractColumnStatisticsCollector statsCollector = new BytesColumnPredIndexStatsCollector(column, statsCollectorConfig);
                    for (Object value : outputValues) {
                        ((BytesColumnPredIndexStatsCollector)statsCollector).collect(value);
                    }
                    ((BytesColumnPredIndexStatsCollector)statsCollector).seal();
                    boolean useVarLengthDictionary = !statsCollector.isFixedLength() ? true : dictionaryIndexConfig.getUseVarLengthDictionary();
                    indexCreationInfo = new ColumnIndexCreationInfo((ColumnStatistics)statsCollector, createDictionary, useVarLengthDictionary, true, (Object)new ByteArray((byte[])fieldSpec.getDefaultNullValue()));
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (createDictionary) {
                this.createDerivedColumnForwardIndexWithDictionary(column, fieldSpec, outputValues, indexCreationInfo);
            } else {
                this.createDerivedColumnForwardIndexWithoutDictionary(column, fieldSpec, outputValues, indexCreationInfo);
            }
        }
        finally {
            for (ValueReader valueReader : valueReaders) {
                valueReader.close();
            }
        }
    }

    private Object getIntOutputValue(Object outputValue, boolean isSingleValue, PinotDataType outputValueType, Integer defaultNullValue, boolean dictionary) {
        if (isSingleValue) {
            if (outputValue instanceof Integer) {
                return outputValue;
            }
            return outputValueType.toInt(outputValue);
        }
        if (dictionary) {
            if (outputValue instanceof Integer) {
                return new Integer[]{(Integer)outputValue};
            }
            Integer[] values = outputValueType.toIntegerArray(outputValue);
            if (values.length == 0) {
                values = new Integer[]{defaultNullValue};
            }
            return values;
        }
        if (outputValue instanceof Integer) {
            return new int[]{(Integer)outputValue};
        }
        int[] values = outputValueType.toPrimitiveIntArray(outputValue);
        if (values.length == 0) {
            values = new int[]{defaultNullValue};
        }
        return values;
    }

    private Object getLongOutputValue(Object outputValue, boolean isSingleValue, PinotDataType outputValueType, Long defaultNullValue, boolean dictionary) {
        if (isSingleValue) {
            if (outputValue instanceof Long) {
                return outputValue;
            }
            return outputValueType.toLong(outputValue);
        }
        if (dictionary) {
            if (outputValue instanceof Long) {
                return new Long[]{(Long)outputValue};
            }
            Long[] values = outputValueType.toLongArray(outputValue);
            if (values.length == 0) {
                values = new Long[]{defaultNullValue};
            }
            return values;
        }
        if (outputValue instanceof Long) {
            return new long[]{(Long)outputValue};
        }
        long[] values = outputValueType.toPrimitiveLongArray(outputValue);
        if (values.length == 0) {
            values = new long[]{defaultNullValue};
        }
        return values;
    }

    private Object getFloatOutputValue(Object outputValue, boolean isSingleValue, PinotDataType outputValueType, Float defaultNullValue, boolean dictionary) {
        if (isSingleValue) {
            if (outputValue instanceof Float) {
                return outputValue;
            }
            return Float.valueOf(outputValueType.toFloat(outputValue));
        }
        if (dictionary) {
            if (outputValue instanceof Float) {
                return new Float[]{(Float)outputValue};
            }
            Float[] values = outputValueType.toFloatArray(outputValue);
            if (values.length == 0) {
                values = new Float[]{defaultNullValue};
            }
            return values;
        }
        if (outputValue instanceof Float) {
            return new float[]{((Float)outputValue).floatValue()};
        }
        float[] values = outputValueType.toPrimitiveFloatArray(outputValue);
        if (values.length == 0) {
            values = new float[]{defaultNullValue.floatValue()};
        }
        return values;
    }

    private Object getDoubleOutputValue(Object outputValue, boolean isSingleValue, PinotDataType outputValueType, Double defaultNullValue, boolean dictionary) {
        if (isSingleValue) {
            if (outputValue instanceof Double) {
                return outputValue;
            }
            return outputValueType.toDouble(outputValue);
        }
        if (dictionary) {
            if (outputValue instanceof Double) {
                return new Double[]{(Double)outputValue};
            }
            Double[] values = outputValueType.toDoubleArray(outputValue);
            if (values.length == 0) {
                values = new Double[]{defaultNullValue};
            }
            return values;
        }
        if (outputValue instanceof Double) {
            return new double[]{(Double)outputValue};
        }
        double[] values = outputValueType.toPrimitiveDoubleArray(outputValue);
        if (values.length == 0) {
            values = new double[]{defaultNullValue};
        }
        return values;
    }

    private Object getStringOutputValue(Object outputValue, boolean isSingleValue, PinotDataType outputValueType, String defaultNullValue) {
        if (isSingleValue) {
            if (outputValue instanceof String) {
                return outputValue;
            }
            return outputValueType.toString(outputValue);
        }
        if (outputValue instanceof String) {
            return new String[]{(String)outputValue};
        }
        String[] values = outputValueType.toStringArray(outputValue);
        if (values.length == 0) {
            values = new String[]{defaultNullValue};
        }
        return values;
    }

    private Object getBytesOutputValue(Object outputValue, boolean isSingleValue, PinotDataType outputValueType, byte[] defaultNullValue) {
        if (isSingleValue) {
            if (outputValue instanceof byte[]) {
                return outputValue;
            }
            return outputValueType.toBytes(outputValue);
        }
        if (outputValue instanceof byte[]) {
            return new byte[][]{(byte[])outputValue};
        }
        Object values = outputValueType.toBytesArray(outputValue);
        if (((byte[][])values).length == 0) {
            values = new byte[][]{defaultNullValue};
        }
        return values;
    }

    private void createDerivedColumnForwardIndexWithDictionary(String column, FieldSpec fieldSpec, Object[] outputValues, ColumnIndexCreationInfo indexCreationInfo) throws Exception {
        try (SegmentDictionaryCreator dictionaryCreator = new SegmentDictionaryCreator(fieldSpec, this._indexDir, indexCreationInfo.isUseVarLengthDictionary());){
            dictionaryCreator.build(indexCreationInfo.getSortedUniqueElementsArray());
            int numDocs = outputValues.length;
            boolean isSingleValue = fieldSpec.isSingleValueField();
            try (ForwardIndexCreator forwardIndexCreator = this.getForwardIndexCreator(fieldSpec, indexCreationInfo, numDocs, column, true);){
                if (isSingleValue) {
                    for (Object outputValue : outputValues) {
                        forwardIndexCreator.putDictId(dictionaryCreator.indexOfSV(outputValue));
                    }
                } else {
                    for (Object outputValue : outputValues) {
                        forwardIndexCreator.putDictIdMV(dictionaryCreator.indexOfMV(outputValue));
                    }
                }
                SegmentColumnarIndexCreator.addColumnMetadataInfo(this._segmentProperties, column, indexCreationInfo, numDocs, fieldSpec, true, dictionaryCreator.getNumBytesPerEntry());
            }
        }
    }

    private void createDerivedColumnForwardIndexWithoutDictionary(String column, FieldSpec fieldSpec, Object[] outputValues, ColumnIndexCreationInfo indexCreationInfo) throws Exception {
        int numDocs = outputValues.length;
        boolean isSingleValue = fieldSpec.isSingleValueField();
        try (ForwardIndexCreator forwardIndexCreator = this.getForwardIndexCreator(fieldSpec, indexCreationInfo, numDocs, column, false);){
            if (isSingleValue) {
                block22: for (Object outputValue : outputValues) {
                    switch (fieldSpec.getDataType().getStoredType()) {
                        case INT: {
                            forwardIndexCreator.putInt(((Integer)outputValue).intValue());
                            continue block22;
                        }
                        case LONG: {
                            forwardIndexCreator.putLong(((Long)outputValue).longValue());
                            continue block22;
                        }
                        case FLOAT: {
                            forwardIndexCreator.putFloat(((Float)outputValue).floatValue());
                            continue block22;
                        }
                        case DOUBLE: {
                            forwardIndexCreator.putDouble(((Double)outputValue).doubleValue());
                            continue block22;
                        }
                        case BIG_DECIMAL: {
                            forwardIndexCreator.putBigDecimal((BigDecimal)outputValue);
                            continue block22;
                        }
                        case STRING: {
                            forwardIndexCreator.putString((String)outputValue);
                            continue block22;
                        }
                        case BYTES: {
                            forwardIndexCreator.putBytes((byte[])outputValue);
                            continue block22;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
            } else {
                block23: for (Object outputValue : outputValues) {
                    switch (fieldSpec.getDataType().getStoredType()) {
                        case INT: {
                            forwardIndexCreator.putIntMV((int[])outputValue);
                            continue block23;
                        }
                        case LONG: {
                            forwardIndexCreator.putLongMV((long[])outputValue);
                            continue block23;
                        }
                        case FLOAT: {
                            forwardIndexCreator.putFloatMV((float[])outputValue);
                            continue block23;
                        }
                        case DOUBLE: {
                            forwardIndexCreator.putDoubleMV((double[])outputValue);
                            continue block23;
                        }
                        case STRING: {
                            forwardIndexCreator.putStringMV((String[])outputValue);
                            continue block23;
                        }
                        case BYTES: {
                            forwardIndexCreator.putBytesMV((byte[][])outputValue);
                            continue block23;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
            }
        }
        SegmentColumnarIndexCreator.addColumnMetadataInfo(this._segmentProperties, column, indexCreationInfo, numDocs, fieldSpec, false, 0);
    }

    private ForwardIndexCreator getForwardIndexCreator(FieldSpec fieldSpec, ColumnIndexCreationInfo indexCreationInfo, int numDocs, String column, boolean hasDictionary) throws Exception {
        IndexCreationContext.Common indexCreationContext = IndexCreationContext.builder().withIndexDir(this._indexDir).withFieldSpec(fieldSpec).withColumnIndexCreationInfo(indexCreationInfo).withTotalDocs(numDocs).withDictionary(hasDictionary).build();
        ForwardIndexConfig forwardIndexConfig = null;
        FieldIndexConfigs fieldIndexConfig = this._indexLoadingConfig.getFieldIndexConfig(column);
        if (fieldIndexConfig != null) {
            forwardIndexConfig = (ForwardIndexConfig)fieldIndexConfig.getConfig((IndexType)new ForwardIndexPlugin().getIndexType());
        }
        if (forwardIndexConfig == null) {
            forwardIndexConfig = new ForwardIndexConfig(Boolean.valueOf(false), null, null, null, null, null);
        }
        return ForwardIndexCreatorFactory.createIndexCreator((IndexCreationContext)indexCreationContext, forwardIndexConfig);
    }

    private class ValueReader
    implements Closeable {
        final ForwardIndexReader _forwardIndexReader;
        final Dictionary _dictionary;
        final PinotSegmentColumnReader _columnReader;

        ValueReader(ColumnMetadata columnMetadata) throws IOException {
            this._forwardIndexReader = ForwardIndexType.read((SegmentDirectory.Reader)BaseDefaultColumnHandler.this._segmentWriter, columnMetadata);
            this._dictionary = columnMetadata.hasDictionary() ? DictionaryIndexType.read((SegmentDirectory.Reader)BaseDefaultColumnHandler.this._segmentWriter, columnMetadata) : null;
            this._columnReader = new PinotSegmentColumnReader(this._forwardIndexReader, this._dictionary, null, columnMetadata.getMaxNumberOfMultiValues());
        }

        Object getValue(int docId) {
            return this._columnReader.getValue(docId);
        }

        @Override
        public void close() throws IOException {
            this._columnReader.close();
            if (this._dictionary != null) {
                this._dictionary.close();
            }
            this._forwardIndexReader.close();
        }
    }

    protected static enum DefaultColumnAction {
        ADD_DIMENSION,
        ADD_METRIC,
        ADD_DATE_TIME,
        ADD_COMPLEX,
        REMOVE_DIMENSION,
        REMOVE_METRIC,
        REMOVE_DATE_TIME,
        REMOVE_COMPLEX,
        UPDATE_DIMENSION_DATA_TYPE,
        UPDATE_DIMENSION_DEFAULT_VALUE,
        UPDATE_DIMENSION_NUMBER_OF_VALUES,
        UPDATE_METRIC_DATA_TYPE,
        UPDATE_METRIC_DEFAULT_VALUE,
        UPDATE_METRIC_NUMBER_OF_VALUES,
        UPDATE_DATE_TIME_DATA_TYPE,
        UPDATE_DATE_TIME_DEFAULT_VALUE,
        UPDATE_COMPLEX_DATA_TYPE,
        UPDATE_COMPLEX_DEFAULT_VALUE;


        boolean isAddAction() {
            return this == ADD_DIMENSION || this == ADD_METRIC || this == ADD_DATE_TIME || this == ADD_COMPLEX;
        }

        boolean isUpdateAction() {
            return !this.isAddAction() && !this.isRemoveAction();
        }

        boolean isRemoveAction() {
            return this == REMOVE_DIMENSION || this == REMOVE_METRIC || this == REMOVE_DATE_TIME || this == REMOVE_COMPLEX;
        }
    }
}

