/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader.invertedindex;

import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.segment.local.segment.index.dictionary.DictionaryIndexType;
import org.apache.pinot.segment.local.segment.index.loader.BaseIndexHandler;
import org.apache.pinot.segment.local.segment.index.loader.LoaderUtils;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.index.FieldIndexConfigs;
import org.apache.pinot.segment.spi.index.FieldIndexConfigsUtil;
import org.apache.pinot.segment.spi.index.FstIndexConfig;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.creator.FSTIndexCreator;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.config.table.IndexConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSTIndexHandler
extends BaseIndexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(FSTIndexHandler.class);
    private final Set<String> _columnsToAddIdx;

    public FSTIndexHandler(SegmentDirectory segmentDirectory, Map<String, FieldIndexConfigs> fieldIndexConfigs, @Nullable TableConfig tableConfig) {
        super(segmentDirectory, fieldIndexConfigs, tableConfig);
        this._columnsToAddIdx = FieldIndexConfigsUtil.columnsWithIndexEnabled((IndexType)StandardIndexes.fst(), (Map)this._fieldIndexConfigs);
    }

    public boolean needUpdateIndices(SegmentDirectory.Reader segmentReader) {
        String segmentName = this._segmentDirectory.getSegmentMetadata().getName();
        HashSet<String> columnsToAddIdx = new HashSet<String>(this._columnsToAddIdx);
        Set existingColumns = segmentReader.toSegmentDirectory().getColumnsWithIndex(StandardIndexes.fst());
        for (String column : existingColumns) {
            if (columnsToAddIdx.remove(column)) continue;
            LOGGER.info("Need to remove existing FST index from segment: {}, column: {}", (Object)segmentName, (Object)column);
            return true;
        }
        for (String column : columnsToAddIdx) {
            ColumnMetadata columnMetadata = this._segmentDirectory.getSegmentMetadata().getColumnMetadataFor(column);
            if (!this.shouldCreateFSTIndex(columnMetadata)) continue;
            LOGGER.info("Need to create new FST index for segment: {}, column: {}", (Object)segmentName, (Object)column);
            return true;
        }
        return false;
    }

    public void updateIndices(SegmentDirectory.Writer segmentWriter) throws Exception {
        String segmentName = this._segmentDirectory.getSegmentMetadata().getName();
        HashSet<String> columnsToAddIdx = new HashSet<String>(this._columnsToAddIdx);
        Set existingColumns = segmentWriter.toSegmentDirectory().getColumnsWithIndex(StandardIndexes.fst());
        for (String column : existingColumns) {
            if (columnsToAddIdx.remove(column)) continue;
            LOGGER.info("Removing existing FST index from segment: {}, column: {}", (Object)segmentName, (Object)column);
            segmentWriter.removeIndex(column, StandardIndexes.fst());
            LOGGER.info("Removed existing FST index from segment: {}, column: {}", (Object)segmentName, (Object)column);
        }
        for (String column : columnsToAddIdx) {
            ColumnMetadata columnMetadata = this._segmentDirectory.getSegmentMetadata().getColumnMetadataFor(column);
            if (!this.shouldCreateFSTIndex(columnMetadata)) continue;
            this.createFSTIndexForColumn(segmentWriter, columnMetadata);
        }
    }

    @Override
    public void postUpdateIndicesCleanup(SegmentDirectory.Writer segmentWriter) throws Exception {
    }

    private boolean shouldCreateFSTIndex(ColumnMetadata columnMetadata) {
        if (columnMetadata != null) {
            this.checkUnsupportedOperationsForFSTIndex(columnMetadata);
            return true;
        }
        return false;
    }

    private void checkUnsupportedOperationsForFSTIndex(ColumnMetadata columnMetadata) {
        String column = columnMetadata.getColumnName();
        if (columnMetadata.getDataType() != FieldSpec.DataType.STRING) {
            throw new UnsupportedOperationException("FST index is currently only supported on STRING columns: " + column);
        }
        if (!columnMetadata.hasDictionary()) {
            throw new UnsupportedOperationException("FST index is currently only supported on dictionary encoded columns: " + column);
        }
        if (!columnMetadata.isSingleValue()) {
            throw new UnsupportedOperationException("FST index is currently not supported on multi-value columns: " + column);
        }
    }

    private void createFSTIndexForColumn(SegmentDirectory.Writer segmentWriter, ColumnMetadata columnMetadata) throws Exception {
        File indexDir = this._segmentDirectory.getSegmentMetadata().getIndexDir();
        String segmentName = this._segmentDirectory.getSegmentMetadata().getName();
        String columnName = columnMetadata.getColumnName();
        File inProgress = new File(indexDir, columnName + ".fst.inprogress");
        File fstIndexFile = new File(indexDir, columnName + ".lucene.v912.fst");
        if (!inProgress.exists()) {
            FileUtils.touch((File)inProgress);
        } else {
            FileUtils.deleteQuietly((File)fstIndexFile);
        }
        LOGGER.info("Creating new FST index for column: {} in segment: {}, cardinality: {}", new Object[]{columnName, segmentName, columnMetadata.getCardinality()});
        IndexCreationContext.Common context = IndexCreationContext.builder().withIndexDir(indexDir).withColumnMetadata(columnMetadata).build();
        FstIndexConfig config = (FstIndexConfig)((FieldIndexConfigs)this._fieldIndexConfigs.get(columnName)).getConfig(StandardIndexes.fst());
        try (FSTIndexCreator fstIndexCreator = (FSTIndexCreator)StandardIndexes.fst().createIndexCreator((IndexCreationContext)context, (IndexConfig)config);
             Dictionary dictionary = DictionaryIndexType.read((SegmentDirectory.Reader)segmentWriter, columnMetadata);){
            for (int dictId = 0; dictId < dictionary.length(); ++dictId) {
                fstIndexCreator.add(dictionary.getStringValue(dictId));
            }
            fstIndexCreator.seal();
        }
        if (this._segmentDirectory.getSegmentMetadata().getVersion() == SegmentVersion.v3) {
            LoaderUtils.writeIndexToV3Format(segmentWriter, columnName, fstIndexFile, StandardIndexes.fst());
        }
        FileUtils.deleteQuietly((File)inProgress);
        LOGGER.info("Created FST index for segment: {}, column: {}", (Object)segmentName, (Object)columnName);
    }
}

