/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader.invertedindex;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.segment.local.segment.index.forward.ForwardIndexType;
import org.apache.pinot.segment.local.segment.index.loader.BaseIndexHandler;
import org.apache.pinot.segment.local.segment.index.loader.LoaderUtils;
import org.apache.pinot.segment.local.utils.GeometrySerializer;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.index.FieldIndexConfigs;
import org.apache.pinot.segment.spi.index.FieldIndexConfigsUtil;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.creator.GeoSpatialIndexCreator;
import org.apache.pinot.segment.spi.index.creator.H3IndexConfig;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.config.table.IndexConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H3IndexHandler
extends BaseIndexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(H3IndexHandler.class);
    private final Map<String, H3IndexConfig> _h3Configs;

    public H3IndexHandler(SegmentDirectory segmentDirectory, Map<String, FieldIndexConfigs> fieldIndexConfigs, @Nullable TableConfig tableConfig) {
        super(segmentDirectory, fieldIndexConfigs, tableConfig);
        this._h3Configs = FieldIndexConfigsUtil.enableConfigByColumn((IndexType)StandardIndexes.h3(), (Map)this._fieldIndexConfigs);
    }

    public boolean needUpdateIndices(SegmentDirectory.Reader segmentReader) {
        String segmentName = this._segmentDirectory.getSegmentMetadata().getName();
        HashSet<String> columnsToAddIdx = new HashSet<String>(this._h3Configs.keySet());
        Set existingColumns = segmentReader.toSegmentDirectory().getColumnsWithIndex(StandardIndexes.h3());
        for (String column : existingColumns) {
            if (columnsToAddIdx.remove(column)) continue;
            LOGGER.info("Need to remove existing H3 index from segment: {}, column: {}", (Object)segmentName, (Object)column);
            return true;
        }
        for (String column : columnsToAddIdx) {
            ColumnMetadata columnMetadata = this._segmentDirectory.getSegmentMetadata().getColumnMetadataFor(column);
            if (!this.shouldCreateH3Index(columnMetadata)) continue;
            LOGGER.info("Need to create new H3 index for segment: {}, column: {}", (Object)segmentName, (Object)column);
            return true;
        }
        return false;
    }

    public void updateIndices(SegmentDirectory.Writer segmentWriter) throws Exception {
        HashSet<String> columnsToAddIdx = new HashSet<String>(this._h3Configs.keySet());
        String segmentName = this._segmentDirectory.getSegmentMetadata().getName();
        Set existingColumns = segmentWriter.toSegmentDirectory().getColumnsWithIndex(StandardIndexes.h3());
        for (String column : existingColumns) {
            if (columnsToAddIdx.remove(column)) continue;
            LOGGER.info("Removing existing H3 index from segment: {}, column: {}", (Object)segmentName, (Object)column);
            segmentWriter.removeIndex(column, StandardIndexes.h3());
            LOGGER.info("Removed existing H3 index from segment: {}, column: {}", (Object)segmentName, (Object)column);
        }
        for (String column : columnsToAddIdx) {
            ColumnMetadata columnMetadata = this._segmentDirectory.getSegmentMetadata().getColumnMetadataFor(column);
            if (!this.shouldCreateH3Index(columnMetadata)) continue;
            this.createH3IndexForColumn(segmentWriter, columnMetadata);
        }
    }

    private boolean shouldCreateH3Index(ColumnMetadata columnMetadata) {
        return columnMetadata != null;
    }

    private void createH3IndexForColumn(SegmentDirectory.Writer segmentWriter, ColumnMetadata columnMetadata) throws Exception {
        File indexDir = this._segmentDirectory.getSegmentMetadata().getIndexDir();
        String segmentName = this._segmentDirectory.getSegmentMetadata().getName();
        String columnName = columnMetadata.getColumnName();
        File inProgress = new File(indexDir, columnName + ".h3.idx.inprogress");
        File h3IndexFile = new File(indexDir, columnName + ".h3.idx");
        if (!inProgress.exists()) {
            FileUtils.touch((File)inProgress);
        } else {
            FileUtils.deleteQuietly((File)h3IndexFile);
        }
        columnMetadata = this.createForwardIndexIfNeeded(segmentWriter, columnName, true);
        LOGGER.info("Creating new H3 index for segment: {}, column: {}", (Object)segmentName, (Object)columnName);
        Preconditions.checkState((columnMetadata.getDataType() == FieldSpec.DataType.BYTES ? 1 : 0) != 0, (Object)"H3 index can only be applied to BYTES columns");
        if (columnMetadata.hasDictionary()) {
            this.handleDictionaryBasedColumn(segmentWriter, columnMetadata);
        } else {
            this.handleNonDictionaryBasedColumn(segmentWriter, columnMetadata);
        }
        if (this._segmentDirectory.getSegmentMetadata().getVersion() == SegmentVersion.v3) {
            LoaderUtils.writeIndexToV3Format(segmentWriter, columnName, h3IndexFile, StandardIndexes.h3());
        }
        FileUtils.deleteQuietly((File)inProgress);
        LOGGER.info("Created H3 index for segment: {}, column: {}", (Object)segmentName, (Object)columnName);
    }

    private void handleDictionaryBasedColumn(SegmentDirectory.Writer segmentWriter, ColumnMetadata columnMetadata) throws Exception {
        File indexDir = this._segmentDirectory.getSegmentMetadata().getIndexDir();
        String columnName = columnMetadata.getColumnName();
        FieldIndexConfigs colIndexConf = (FieldIndexConfigs)this._fieldIndexConfigs.get(columnName);
        IndexCreationContext.Common context = IndexCreationContext.builder().withIndexDir(indexDir).withColumnMetadata(columnMetadata).build();
        H3IndexConfig config = (H3IndexConfig)colIndexConf.getConfig(StandardIndexes.h3());
        try (ForwardIndexReader forwardIndexReader = (ForwardIndexReader)StandardIndexes.forward().getReaderFactory().createIndexReader((SegmentDirectory.Reader)segmentWriter, colIndexConf, columnMetadata);
             ForwardIndexReaderContext readerContext = forwardIndexReader.createContext();
             Dictionary dictionary = (Dictionary)StandardIndexes.dictionary().getReaderFactory().createIndexReader((SegmentDirectory.Reader)segmentWriter, colIndexConf, columnMetadata);
             GeoSpatialIndexCreator h3IndexCreator = (GeoSpatialIndexCreator)StandardIndexes.h3().createIndexCreator((IndexCreationContext)context, (IndexConfig)config);){
            int numDocs = columnMetadata.getTotalDocs();
            for (int i = 0; i < numDocs; ++i) {
                int dictId = forwardIndexReader.getDictId(i, readerContext);
                h3IndexCreator.add(GeometrySerializer.deserialize(dictionary.getBytesValue(dictId)));
            }
            h3IndexCreator.seal();
        }
    }

    private void handleNonDictionaryBasedColumn(SegmentDirectory.Writer segmentWriter, ColumnMetadata columnMetadata) throws Exception {
        File indexDir = this._segmentDirectory.getSegmentMetadata().getIndexDir();
        String columnName = columnMetadata.getColumnName();
        IndexCreationContext.Common context = IndexCreationContext.builder().withIndexDir(indexDir).withColumnMetadata(columnMetadata).build();
        H3IndexConfig config = (H3IndexConfig)((FieldIndexConfigs)this._fieldIndexConfigs.get(columnName)).getConfig(StandardIndexes.h3());
        try (ForwardIndexReader<?> forwardIndexReader = ForwardIndexType.read((SegmentDirectory.Reader)segmentWriter, columnMetadata);
             ForwardIndexReaderContext readerContext = forwardIndexReader.createContext();
             GeoSpatialIndexCreator h3IndexCreator = (GeoSpatialIndexCreator)StandardIndexes.h3().createIndexCreator((IndexCreationContext)context, (IndexConfig)config);){
            int numDocs = columnMetadata.getTotalDocs();
            for (int i = 0; i < numDocs; ++i) {
                h3IndexCreator.add(GeometrySerializer.deserialize(forwardIndexReader.getBytes(i, readerContext)));
            }
            h3IndexCreator.seal();
        }
    }
}

