/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.map;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.segment.index.datasource.BaseDataSource;
import org.apache.pinot.segment.local.segment.index.datasource.ImmutableDataSource;
import org.apache.pinot.segment.local.segment.index.map.NullDataSource;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.datasource.DataSourceMetadata;
import org.apache.pinot.segment.spi.datasource.MapDataSource;
import org.apache.pinot.segment.spi.index.column.ColumnIndexContainer;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.reader.MapIndexReader;
import org.apache.pinot.spi.data.ComplexFieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMapDataSource
extends BaseDataSource
implements MapDataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseMapDataSource.class);
    protected final Map<String, DataSource> _keyDataSources = new HashMap<String, DataSource>();

    public BaseMapDataSource(DataSourceMetadata dataSourceMetadata, ColumnIndexContainer indexContainer) {
        super(dataSourceMetadata, indexContainer);
    }

    public ComplexFieldSpec.MapFieldSpec getFieldSpec() {
        return ComplexFieldSpec.toMapFieldSpec((ComplexFieldSpec)((ComplexFieldSpec)this.getDataSourceMetadata().getFieldSpec()));
    }

    @Override
    @Nullable
    public Dictionary getDictionary() {
        return null;
    }

    public DataSource getKeyDataSource(String key) {
        ImmutableDataSource immutableDataSource;
        if (this._keyDataSources.containsKey(key)) {
            return this._keyDataSources.get(key);
        }
        Map indexes = this.getMapIndexReader().getKeyIndexes(key);
        if (indexes == null) {
            return new NullDataSource(key);
        }
        ColumnIndexContainer.FromMap indexContainer = new ColumnIndexContainer.FromMap(indexes);
        try {
            ColumnMetadata keyMeta = this.getMapIndexReader().getKeyMetadata(key);
            ImmutableDataSource dataSource = new ImmutableDataSource(keyMeta, (ColumnIndexContainer)indexContainer);
            this._keyDataSources.put(key, dataSource);
            immutableDataSource = dataSource;
        }
        catch (Throwable throwable) {
            try {
                try {
                    indexContainer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                LOGGER.error("Caught exception while creating key data source for key: {}", (Object)key, (Object)ex);
                return null;
            }
        }
        indexContainer.close();
        return immutableDataSource;
    }

    public abstract MapIndexReader getMapIndexReader();

    public Map<String, DataSource> getKeyDataSources() {
        MapIndexReader mapIndexReader = (MapIndexReader)this.getForwardIndex();
        assert (mapIndexReader != null);
        HashMap<String, DataSource> keyDataSources = new HashMap<String, DataSource>();
        Set allKeys = mapIndexReader.getKeys();
        allKeys.forEach(key -> keyDataSources.put((String)key, this.getKeyDataSource((String)key)));
        return keyDataSources;
    }

    public DataSourceMetadata getKeyDataSourceMetadata(String key) {
        throw new UnsupportedOperationException();
    }

    public ColumnIndexContainer getKeyIndexContainer(String key) {
        throw new UnsupportedOperationException();
    }
}

