/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers.bloom;

import org.apache.pinot.segment.local.segment.index.readers.bloom.BaseGuavaBloomFilterReader;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;

public class OffHeapGuavaBloomFilterReader
extends BaseGuavaBloomFilterReader {
    public OffHeapGuavaBloomFilterReader(PinotDataBuffer dataBuffer) {
        super(dataBuffer);
    }

    public boolean mightContain(long hash1, long hash2) {
        long combinedHash = hash1;
        for (int i = 0; i < this._numHashFunctions; ++i) {
            long bitIndex = (combinedHash & Long.MAX_VALUE) % this._numBits;
            int longIndex = (int)(bitIndex >>> 6);
            int bitIndexInLong = (int)(bitIndex & 0x3FL);
            int byteIndex = longIndex << 3 | 7 - (bitIndexInLong >>> 3);
            if ((this._valueBuffer.getByte(byteIndex) & 1 << (bitIndexInLong & 7)) == 0) {
                return false;
            }
            combinedHash += hash2;
        }
        return true;
    }
}

