/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers.json;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.invoke.StringConcatFactory;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.RequestContextUtils;
import org.apache.pinot.common.request.context.predicate.EqPredicate;
import org.apache.pinot.common.request.context.predicate.InPredicate;
import org.apache.pinot.common.request.context.predicate.NotEqPredicate;
import org.apache.pinot.common.request.context.predicate.NotInPredicate;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.common.request.context.predicate.RangePredicate;
import org.apache.pinot.common.request.context.predicate.RegexpLikePredicate;
import org.apache.pinot.common.utils.regex.Pattern;
import org.apache.pinot.segment.local.segment.index.readers.BitmapInvertedIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.StringDictionary;
import org.apache.pinot.segment.spi.index.reader.JsonIndexReader;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.exception.BadQueryRequestException;
import org.apache.pinot.spi.trace.Tracing;
import org.apache.pinot.sql.parsers.CalciteSqlParser;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.RoaringBitmap;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class ImmutableJsonIndexReader
implements JsonIndexReader {
    private final long _numDocs;
    private final int _version;
    private final StringDictionary _dictionary;
    private final BitmapInvertedIndexReader _invertedIndex;
    private final long _numFlattenedDocs;
    private final PinotDataBuffer _docIdMapping;

    public ImmutableJsonIndexReader(PinotDataBuffer dataBuffer, int numDocs) {
        this._numDocs = numDocs;
        this._version = dataBuffer.getInt(0);
        Preconditions.checkState((this._version == 1 || this._version == 2 ? 1 : 0) != 0, (String)"Unsupported json index version: %s", (int)this._version);
        int maxValueLength = dataBuffer.getInt(4);
        long dictionaryLength = dataBuffer.getLong(8);
        long invertedIndexLength = dataBuffer.getLong(16);
        long docIdMappingLength = dataBuffer.getLong(24);
        long dictionaryStartOffset = 32L;
        long dictionaryEndOffset = dictionaryStartOffset + dictionaryLength;
        this._dictionary = new StringDictionary(dataBuffer.view(dictionaryStartOffset, dictionaryEndOffset, ByteOrder.BIG_ENDIAN), 0, maxValueLength);
        long invertedIndexEndOffset = dictionaryEndOffset + invertedIndexLength;
        this._invertedIndex = new BitmapInvertedIndexReader(dataBuffer.view(dictionaryEndOffset, invertedIndexEndOffset, ByteOrder.BIG_ENDIAN), this._dictionary.length());
        long docIdMappingEndOffset = invertedIndexEndOffset + docIdMappingLength;
        this._numFlattenedDocs = docIdMappingLength / 4L;
        this._docIdMapping = dataBuffer.view(invertedIndexEndOffset, docIdMappingEndOffset, ByteOrder.LITTLE_ENDIAN);
    }

    public MutableRoaringBitmap getMatchingDocIds(String filterString) {
        FilterContext filter;
        try {
            filter = RequestContextUtils.getFilter((Expression)CalciteSqlParser.compileToExpression((String)filterString));
            Preconditions.checkArgument((!filter.isConstant() ? 1 : 0) != 0);
        }
        catch (Exception e) {
            throw new BadQueryRequestException("Invalid json match filter: " + filterString);
        }
        if (filter.getType() == FilterContext.Type.PREDICATE && this.isExclusive(filter.getPredicate().getType())) {
            MutableRoaringBitmap matchingFlattenedDocIds = this.getMatchingFlattenedDocIds(filter.getPredicate());
            MutableRoaringBitmap matchingDocIds = new MutableRoaringBitmap();
            matchingFlattenedDocIds.forEach(flattenedDocId -> matchingDocIds.add(this.getDocId(flattenedDocId)));
            matchingDocIds.flip(0L, this._numDocs);
            return matchingDocIds;
        }
        MutableRoaringBitmap matchingFlattenedDocIds = this.getMatchingFlattenedDocIds(filter);
        MutableRoaringBitmap matchingDocIds = new MutableRoaringBitmap();
        matchingFlattenedDocIds.forEach(flattenedDocId -> matchingDocIds.add(this.getDocId(flattenedDocId)));
        return matchingDocIds;
    }

    private boolean isExclusive(Predicate.Type predicateType) {
        return predicateType == Predicate.Type.IS_NULL;
    }

    private MutableRoaringBitmap getMatchingFlattenedDocIds(FilterContext filter) {
        switch (filter.getType()) {
            case AND: {
                List children = filter.getChildren();
                int numChildren = children.size();
                MutableRoaringBitmap matchingDocIds = this.getMatchingFlattenedDocIds((FilterContext)children.get(0));
                for (int i = 1; i < numChildren; ++i) {
                    matchingDocIds.and((ImmutableRoaringBitmap)this.getMatchingFlattenedDocIds((FilterContext)children.get(i)));
                }
                return matchingDocIds;
            }
            case OR: {
                List children = filter.getChildren();
                int numChildren = children.size();
                MutableRoaringBitmap matchingDocIds = this.getMatchingFlattenedDocIds((FilterContext)children.get(0));
                for (int i = 1; i < numChildren; ++i) {
                    matchingDocIds.or((ImmutableRoaringBitmap)this.getMatchingFlattenedDocIds((FilterContext)children.get(i)));
                }
                return matchingDocIds;
            }
            case PREDICATE: {
                Predicate predicate = filter.getPredicate();
                Preconditions.checkArgument((!this.isExclusive(predicate.getType()) ? 1 : 0) != 0, (String)"Exclusive predicate: %s cannot be nested", (Object)predicate);
                return this.getMatchingFlattenedDocIds(predicate);
            }
        }
        throw new IllegalStateException();
    }

    private MutableRoaringBitmap getMatchingFlattenedDocIds(Predicate predicate) {
        ExpressionContext lhs = predicate.getLhs();
        Preconditions.checkArgument((lhs.getType() == ExpressionContext.Type.IDENTIFIER ? 1 : 0) != 0, (String)"Left-hand side of the predicate must be an identifier, got: %s (%s). Put double quotes around the identifier if needed.", (Object)lhs, (Object)lhs.getType());
        Object key = lhs.getIdentifier();
        if (this._version == 2) {
            key = ((String)key).startsWith("$") ? ((String)key).substring(1) : "." + (String)key;
        } else if (((String)key).startsWith("$.")) {
            key = ((String)key).substring(2);
        }
        Pair<String, MutableRoaringBitmap> pair = this.getKeyAndFlattenedDocIds((String)key);
        key = (String)pair.getLeft();
        MutableRoaringBitmap matchingDocIds = (MutableRoaringBitmap)pair.getRight();
        if (matchingDocIds != null && matchingDocIds.isEmpty()) {
            return matchingDocIds;
        }
        Predicate.Type predicateType = predicate.getType();
        switch (predicateType) {
            case EQ: {
                String value = ((EqPredicate)predicate).getValue();
                String keyValuePair = (String)key + "\u0000" + value;
                int dictId = this._dictionary.indexOf(keyValuePair);
                if (dictId >= 0) {
                    ImmutableRoaringBitmap matchingDocIdsForKeyValuePair = this._invertedIndex.getDocIds(dictId);
                    if (matchingDocIds == null) {
                        matchingDocIds = matchingDocIdsForKeyValuePair.toMutableRoaringBitmap();
                    } else {
                        matchingDocIds.and(matchingDocIdsForKeyValuePair);
                    }
                    return matchingDocIds;
                }
                return new MutableRoaringBitmap();
            }
            case NOT_EQ: {
                String notEqualValue = ((NotEqPredicate)predicate).getValue();
                int[] dictIds = this.getDictIdRangeForKey((String)key);
                MutableRoaringBitmap result = null;
                for (int dictId = dictIds[0]; dictId < dictIds[1]; ++dictId) {
                    String value = this._dictionary.getStringValue(dictId).substring(((String)key).length() + 1);
                    if (notEqualValue.equals(value)) continue;
                    if (result == null) {
                        result = this._invertedIndex.getDocIds(dictId).toMutableRoaringBitmap();
                        continue;
                    }
                    result.or(this._invertedIndex.getDocIds(dictId));
                }
                if (result == null) {
                    return new MutableRoaringBitmap();
                }
                if (matchingDocIds == null) {
                    return result;
                }
                matchingDocIds.and(result);
                return matchingDocIds;
            }
            case IN: {
                List values = ((InPredicate)predicate).getValues();
                MutableRoaringBitmap matchingDocIdsForKeyValuePairs = new MutableRoaringBitmap();
                for (String value : values) {
                    String keyValuePair = (String)key + "\u0000" + value;
                    int dictId = this._dictionary.indexOf(keyValuePair);
                    if (dictId < 0) continue;
                    matchingDocIdsForKeyValuePairs.or(this._invertedIndex.getDocIds(dictId));
                }
                if (matchingDocIds == null) {
                    matchingDocIds = matchingDocIdsForKeyValuePairs;
                } else {
                    matchingDocIds.and((ImmutableRoaringBitmap)matchingDocIdsForKeyValuePairs);
                }
                return matchingDocIds;
            }
            case NOT_IN: {
                List notInValues = ((NotInPredicate)predicate).getValues();
                int[] dictIds = this.getDictIdRangeForKey((String)key);
                MutableRoaringBitmap result = null;
                for (int dictId = dictIds[0]; dictId < dictIds[1]; ++dictId) {
                    String value = this._dictionary.getStringValue(dictId).substring(((String)key).length() + 1);
                    if (notInValues.contains(value)) continue;
                    if (result == null) {
                        result = this._invertedIndex.getDocIds(dictId).toMutableRoaringBitmap();
                        continue;
                    }
                    result.or(this._invertedIndex.getDocIds(dictId));
                }
                if (result == null) {
                    return new MutableRoaringBitmap();
                }
                if (matchingDocIds == null) {
                    return result;
                }
                matchingDocIds.and(result);
                return matchingDocIds;
            }
            case IS_NOT_NULL: 
            case IS_NULL: {
                int dictId = this._dictionary.indexOf((String)key);
                if (dictId >= 0) {
                    ImmutableRoaringBitmap matchingDocIdsForKey = this._invertedIndex.getDocIds(dictId);
                    if (matchingDocIds == null) {
                        matchingDocIds = matchingDocIdsForKey.toMutableRoaringBitmap();
                    } else {
                        matchingDocIds.and(matchingDocIdsForKey);
                    }
                    return matchingDocIds;
                }
                return new MutableRoaringBitmap();
            }
            case REGEXP_LIKE: {
                Pattern pattern = ((RegexpLikePredicate)predicate).getPattern();
                int[] dictIds = this.getDictIdRangeForKey((String)key);
                MutableRoaringBitmap result = null;
                for (int dictId = dictIds[0]; dictId < dictIds[1]; ++dictId) {
                    String value = this._dictionary.getStringValue(dictId).substring(((String)key).length() + 1);
                    if (!pattern.matcher((CharSequence)value).matches()) continue;
                    if (result == null) {
                        result = this._invertedIndex.getDocIds(dictId).toMutableRoaringBitmap();
                        continue;
                    }
                    result.or(this._invertedIndex.getDocIds(dictId));
                }
                if (result == null) {
                    return new MutableRoaringBitmap();
                }
                if (matchingDocIds == null) {
                    return result;
                }
                matchingDocIds.and(result);
                return matchingDocIds;
            }
            case RANGE: {
                RangePredicate rangePredicate = (RangePredicate)predicate;
                FieldSpec.DataType rangeDataType = rangePredicate.getRangeDataType();
                rangeDataType = rangeDataType.isNumeric() ? FieldSpec.DataType.DOUBLE : FieldSpec.DataType.STRING;
                boolean lowerUnbounded = rangePredicate.getLowerBound().equals("*");
                boolean upperUnbounded = rangePredicate.getUpperBound().equals("*");
                boolean lowerInclusive = lowerUnbounded || rangePredicate.isLowerInclusive();
                boolean upperInclusive = upperUnbounded || rangePredicate.isUpperInclusive();
                Object lowerBound = lowerUnbounded ? null : rangeDataType.convert(rangePredicate.getLowerBound());
                Object upperBound = upperUnbounded ? null : rangeDataType.convert(rangePredicate.getUpperBound());
                int[] dictIds = this.getDictIdRangeForKey((String)key);
                MutableRoaringBitmap result = null;
                for (int dictId = dictIds[0]; dictId < dictIds[1]; ++dictId) {
                    boolean upperCompareResult;
                    boolean lowerCompareResult;
                    String value = this._dictionary.getStringValue(dictId).substring(((String)key).length() + 1);
                    Object valueObj = rangeDataType.convert(value);
                    boolean bl = lowerUnbounded || (lowerInclusive ? rangeDataType.compare(valueObj, lowerBound) >= 0 : rangeDataType.compare(valueObj, lowerBound) > 0) ? true : (lowerCompareResult = false);
                    boolean bl2 = upperUnbounded || (upperInclusive ? rangeDataType.compare(valueObj, upperBound) <= 0 : rangeDataType.compare(valueObj, upperBound) < 0) ? true : (upperCompareResult = false);
                    if (!lowerCompareResult || !upperCompareResult) continue;
                    if (result == null) {
                        result = this._invertedIndex.getDocIds(dictId).toMutableRoaringBitmap();
                        continue;
                    }
                    result.or(this._invertedIndex.getDocIds(dictId));
                }
                if (result == null) {
                    return new MutableRoaringBitmap();
                }
                if (matchingDocIds == null) {
                    return result;
                }
                matchingDocIds.and(result);
                return matchingDocIds;
            }
        }
        throw new IllegalStateException("Unsupported json_match predicate type: " + predicate);
    }

    private int getDocId(int flattenedDocId) {
        return this._docIdMapping.getInt((long)flattenedDocId << 2);
    }

    public void convertFlattenedDocIdsToDocIds(Map<String, RoaringBitmap> valueToFlattenedDocIds) {
        valueToFlattenedDocIds.replaceAll((key, value) -> {
            RoaringBitmap docIds = new RoaringBitmap();
            value.forEach(flattenedDocId -> docIds.add(this.getDocId(flattenedDocId)));
            return docIds;
        });
    }

    public Map<String, RoaringBitmap> getMatchingFlattenedDocsMap(String jsonPathKey, @Nullable String filterString) {
        RoaringBitmap filteredFlattenedDocIds = null;
        if (filterString != null) {
            FilterContext filter;
            try {
                filter = RequestContextUtils.getFilter((Expression)CalciteSqlParser.compileToExpression((String)filterString));
                Preconditions.checkArgument((!filter.isConstant() ? 1 : 0) != 0);
            }
            catch (Exception e) {
                throw new BadQueryRequestException("Invalid json match filter: " + filterString);
            }
            if (filter.getType() == FilterContext.Type.PREDICATE && this.isExclusive(filter.getPredicate().getType())) {
                filteredFlattenedDocIds = this.getMatchingFlattenedDocIds(filter.getPredicate()).toRoaringBitmap();
                filteredFlattenedDocIds.flip(0L, this._numFlattenedDocs);
            } else {
                filteredFlattenedDocIds = this.getMatchingFlattenedDocIds(filter).toRoaringBitmap();
            }
        }
        if (this._version == 2) {
            jsonPathKey = ((String)jsonPathKey).startsWith("$") ? ((String)jsonPathKey).substring(1) : "." + (String)jsonPathKey;
        } else if (((String)jsonPathKey).startsWith("$.")) {
            jsonPathKey = ((String)jsonPathKey).substring(2);
        }
        HashMap<String, RoaringBitmap> result = new HashMap<String, RoaringBitmap>();
        Pair<String, MutableRoaringBitmap> pathKey = this.getKeyAndFlattenedDocIds((String)jsonPathKey);
        if (pathKey.getRight() != null && ((MutableRoaringBitmap)pathKey.getRight()).isEmpty()) {
            return result;
        }
        jsonPathKey = (String)pathKey.getLeft();
        RoaringBitmap arrayIndexFlattenDocIds = null;
        if (pathKey.getRight() != null) {
            arrayIndexFlattenDocIds = ((MutableRoaringBitmap)pathKey.getRight()).toRoaringBitmap();
        }
        int[] dictIds = this.getDictIdRangeForKey((String)jsonPathKey);
        for (int dictId = dictIds[0]; dictId < dictIds[1]; ++dictId) {
            String key = this._dictionary.getStringValue(dictId);
            RoaringBitmap docIds = this._invertedIndex.getDocIds(dictId).toRoaringBitmap();
            if (filteredFlattenedDocIds != null) {
                docIds.and(filteredFlattenedDocIds);
            }
            if (arrayIndexFlattenDocIds != null) {
                docIds.and(arrayIndexFlattenDocIds);
            }
            if (docIds.isEmpty()) continue;
            result.put(key.substring(((String)jsonPathKey).length() + 1), docIds);
            Tracing.ThreadAccountantOps.sampleAndCheckInterruptionPeriodically((int)result.size());
        }
        return result;
    }

    public String[][] getValuesMV(int[] docIds, int length, Map<String, RoaringBitmap> valueToMatchingFlattenedDocs) {
        String[][] result = new String[length][];
        ArrayList<PriorityQueue<Pair>> docIdToFlattenedDocIdsAndValues = new ArrayList<PriorityQueue<Pair>>();
        for (int i = 0; i < length; ++i) {
            docIdToFlattenedDocIdsAndValues.add(new PriorityQueue<Pair>(Comparator.comparingInt(Pair::getRight)));
        }
        HashMap<Integer, Integer> docIdToPos = new HashMap<Integer, Integer>();
        for (int i = 0; i < length; ++i) {
            docIdToPos.put(docIds[i], i);
        }
        for (Map.Entry<String, RoaringBitmap> entry : valueToMatchingFlattenedDocs.entrySet()) {
            String value = entry.getKey();
            RoaringBitmap matchingFlattenedDocIds = entry.getValue();
            matchingFlattenedDocIds.forEach(flattenedDocId -> {
                int docId = this.getDocId(flattenedDocId);
                if (docIdToPos.containsKey(docId)) {
                    ((PriorityQueue)docIdToFlattenedDocIdsAndValues.get((Integer)docIdToPos.get(docId))).add(Pair.of((Object)value, (Object)flattenedDocId));
                }
            });
        }
        for (int i = 0; i < length; ++i) {
            PriorityQueue pq = (PriorityQueue)docIdToFlattenedDocIdsAndValues.get(i);
            result[i] = new String[pq.size()];
            int j = 0;
            while (!pq.isEmpty()) {
                result[i][j++] = (String)((Pair)pq.poll()).getLeft();
            }
        }
        return result;
    }

    public String[] getValuesSV(int[] docIds, int length, Map<String, RoaringBitmap> valueToMatchingDocs, boolean isFlattenedDocIds) {
        Int2ObjectOpenHashMap docIdToValues = new Int2ObjectOpenHashMap(docIds.length);
        RoaringBitmap docIdMask = RoaringBitmap.bitmapOf((int[])docIds);
        for (Map.Entry<String, RoaringBitmap> entry : valueToMatchingDocs.entrySet()) {
            String value = entry.getKey();
            RoaringBitmap matchingDocIds = entry.getValue();
            if (isFlattenedDocIds) {
                matchingDocIds.forEach(flattenedDocId -> {
                    int docId = this.getDocId(flattenedDocId);
                    if (docIdMask.contains(docId)) {
                        docIdToValues.put(docId, (Object)value);
                    }
                });
                continue;
            }
            RoaringBitmap intersection = RoaringBitmap.and((RoaringBitmap)matchingDocIds, (RoaringBitmap)docIdMask);
            if (intersection.isEmpty()) continue;
            Iterator iterator = intersection.iterator();
            while (iterator.hasNext()) {
                int docId = (Integer)iterator.next();
                docIdToValues.put(docId, (Object)entry.getKey());
            }
        }
        String[] values = new String[length];
        for (int i = 0; i < length; ++i) {
            values[i] = (String)docIdToValues.get(docIds[i]);
        }
        return values;
    }

    private int[] getDictIdRangeForKey(String key) {
        int indexOfMin = this._dictionary.indexOf(key);
        if (indexOfMin == -1) {
            return new int[]{-1, -1};
        }
        int indexOfMax = this._dictionary.insertionIndexOf((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", "\u0001"}, (String)key)));
        int minDictId = indexOfMin + 1;
        int maxDictId = -1 * indexOfMax - 1;
        if (indexOfMax > 0) {
            maxDictId = indexOfMax;
        }
        return new int[]{minDictId, maxDictId};
    }

    private Pair<String, MutableRoaringBitmap> getKeyAndFlattenedDocIds(String key) {
        MutableRoaringBitmap matchingDocIds = null;
        if (this._version == 2) {
            int leftBracketIndex;
            while ((leftBracketIndex = ((String)key).indexOf(91)) >= 0) {
                int rightBracketIndex = ((String)key).indexOf(93, leftBracketIndex + 2);
                Preconditions.checkArgument((rightBracketIndex > 0 ? 1 : 0) != 0, (String)"Missing right bracket in key: %s", (Object)key);
                String leftPart = ((String)key).substring(0, leftBracketIndex);
                String arrayIndex = ((String)key).substring(leftBracketIndex + 1, rightBracketIndex);
                String rightPart = ((String)key).substring(rightBracketIndex + 1);
                if (!arrayIndex.equals("*")) {
                    String searchKey = leftPart + ".$index\u0000" + arrayIndex;
                    int dictId = this._dictionary.indexOf(searchKey);
                    if (dictId >= 0) {
                        ImmutableRoaringBitmap docIds = this._invertedIndex.getDocIds(dictId);
                        if (matchingDocIds == null) {
                            matchingDocIds = docIds.toMutableRoaringBitmap();
                        } else {
                            matchingDocIds.and(docIds);
                        }
                    } else {
                        return Pair.of(null, (Object)new MutableRoaringBitmap());
                    }
                }
                key = leftPart + "." + rightPart;
            }
        } else {
            int leftBracketIndex;
            while ((leftBracketIndex = ((String)key).indexOf(91)) > 0) {
                int rightBracketIndex = ((String)key).indexOf(93, leftBracketIndex + 2);
                Preconditions.checkArgument((rightBracketIndex > 0 ? 1 : 0) != 0, (String)"Missing right bracket in key: %s", (Object)key);
                String leftPart = ((String)key).substring(0, leftBracketIndex);
                String arrayIndex = ((String)key).substring(leftBracketIndex + 1, rightBracketIndex);
                String rightPart = ((String)key).substring(rightBracketIndex + 1);
                if (!arrayIndex.equals("*")) {
                    String searchKey = leftPart + ".$index\u0000" + arrayIndex;
                    int dictId = this._dictionary.indexOf(searchKey);
                    if (dictId >= 0) {
                        ImmutableRoaringBitmap docIds = this._invertedIndex.getDocIds(dictId);
                        if (matchingDocIds == null) {
                            matchingDocIds = docIds.toMutableRoaringBitmap();
                        } else {
                            matchingDocIds.and(docIds);
                        }
                    } else {
                        return Pair.of(null, (Object)new MutableRoaringBitmap());
                    }
                }
                key = leftPart + rightPart;
            }
        }
        return Pair.of((Object)key, matchingDocIds);
    }

    private PeekableIntIterator intersect(MutableRoaringBitmap a, ImmutableRoaringBitmap b) {
        a.and(b);
        return a.getIntIterator();
    }

    public void close() {
    }
}

