/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.text;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.segment.store.TextIndexUtils;
import org.apache.pinot.segment.spi.index.TextIndexConfig;
import org.apache.pinot.segment.spi.utils.CsvParser;
import org.apache.pinot.spi.config.table.FSTType;

public class TextIndexConfigBuilder
extends TextIndexConfig.AbstractBuilder {
    public TextIndexConfigBuilder() {
        super((FSTType)null);
    }

    public TextIndexConfigBuilder(@Nullable FSTType fstType) {
        super(fstType);
    }

    public TextIndexConfigBuilder(TextIndexConfig other) {
        super(other);
    }

    public TextIndexConfig.AbstractBuilder withProperties(@Nullable Map<String, String> textIndexProperties) {
        if (textIndexProperties != null) {
            if (Boolean.parseBoolean(textIndexProperties.get("noRawDataForTextIndex"))) {
                this._rawValueForTextIndex = textIndexProperties.get("rawValueForTextIndex");
                if (this._rawValueForTextIndex == null) {
                    this._rawValueForTextIndex = "n";
                }
            }
            this._enableQueryCache = Boolean.parseBoolean(textIndexProperties.get("enableQueryCacheForTextIndex"));
            this._useANDForMultiTermQueries = Boolean.parseBoolean(textIndexProperties.get("useANDForMultiTermTextIndexQueries"));
            this._stopWordsInclude = TextIndexUtils.extractStopWordsInclude(textIndexProperties);
            this._stopWordsExclude = TextIndexUtils.extractStopWordsExclude(textIndexProperties);
            this._enablePrefixSuffixMatchingInPhraseQueries = Boolean.parseBoolean(textIndexProperties.get("enablePrefixSuffixMatchingInPhraseQueries"));
            if (textIndexProperties.get("luceneUseCompoundFile") != null) {
                this._luceneUseCompoundFile = Boolean.parseBoolean(textIndexProperties.get("luceneUseCompoundFile"));
            }
            if (textIndexProperties.get("luceneMaxBufferSizeMB") != null) {
                this._luceneMaxBufferSizeMB = Integer.parseInt(textIndexProperties.get("luceneMaxBufferSizeMB"));
            }
            if (textIndexProperties.get("luceneAnalyzerClass") != null) {
                this._luceneAnalyzerClass = textIndexProperties.get("luceneAnalyzerClass");
            }
            if (textIndexProperties.get("luceneAnalyzerClassArgs") != null) {
                this._luceneAnalyzerClassArgs = CsvParser.parse((String)textIndexProperties.get("luceneAnalyzerClassArgs"), (boolean)true, (boolean)false);
            }
            if (textIndexProperties.get("luceneAnalyzerClassArgTypes") != null) {
                this._luceneAnalyzerClassArgTypes = CsvParser.parse((String)textIndexProperties.get("luceneAnalyzerClassArgTypes"), (boolean)false, (boolean)true);
            }
            if (textIndexProperties.get("luceneQueryParserClass") != null) {
                this._luceneQueryParserClass = textIndexProperties.get("luceneQueryParserClass");
            }
            if (textIndexProperties.get("reuseMutableIndex") != null) {
                this._reuseMutableIndex = Boolean.parseBoolean(textIndexProperties.get("reuseMutableIndex"));
            }
            if (textIndexProperties.get("luceneNRTCachingDirectoryMaxBufferSizeMB") != null) {
                this._luceneNRTCachingDirectoryMaxBufferSizeMB = Integer.parseInt(textIndexProperties.get("luceneNRTCachingDirectoryMaxBufferSizeMB"));
            }
            for (Map.Entry<String, String> entry : textIndexProperties.entrySet()) {
                if (entry.getKey().equalsIgnoreCase("fstType")) {
                    this._fstType = FSTType.NATIVE;
                    continue;
                }
                this._fstType = FSTType.LUCENE;
            }
        }
        return this;
    }
}

