/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.virtualcolumn;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.index.IndexReader;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.column.ColumnIndexContainer;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.InvertedIndexReader;

public class VirtualColumnIndexContainer
implements ColumnIndexContainer {
    private final ForwardIndexReader<?> _forwardIndex;
    private final InvertedIndexReader<?> _invertedIndex;
    private final Dictionary _dictionary;

    public VirtualColumnIndexContainer(ForwardIndexReader<?> forwardIndex, InvertedIndexReader<?> invertedIndex, Dictionary dictionary) {
        this._forwardIndex = forwardIndex;
        this._invertedIndex = invertedIndex;
        this._dictionary = dictionary;
    }

    @Nullable
    public <I extends IndexReader, T extends IndexType<?, I, ?>> I getIndex(T indexType) {
        if (indexType.equals(StandardIndexes.forward())) {
            return (I)this._forwardIndex;
        }
        if (indexType.equals(StandardIndexes.inverted())) {
            return (I)this._invertedIndex;
        }
        if (indexType.equals(StandardIndexes.dictionary())) {
            return (I)this._dictionary;
        }
        return null;
    }

    public void close() throws IOException {
        this._forwardIndex.close();
        if (this._invertedIndex != null) {
            this._invertedIndex.close();
        }
        if (this._dictionary != null) {
            this._dictionary.close();
        }
    }
}

