/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.startree.v2.store;

import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.segment.index.datasource.BaseDataSource;
import org.apache.pinot.segment.spi.datasource.DataSourceMetadata;
import org.apache.pinot.segment.spi.index.IndexReader;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.column.ColumnIndexContainer;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.partition.PartitionFunction;
import org.apache.pinot.spi.data.FieldSpec;

public class StarTreeDataSource
extends BaseDataSource {
    public StarTreeDataSource(FieldSpec fieldSpec, int numDocs, ForwardIndexReader<?> forwardIndex, @Nullable Dictionary dictionary) {
        super(new StarTreeDataSourceMetadata(fieldSpec, numDocs), (ColumnIndexContainer)new ColumnIndexContainer.FromMap.Builder().with(StandardIndexes.forward(), forwardIndex).with(StandardIndexes.dictionary(), (IndexReader)dictionary).build());
    }

    private static final class StarTreeDataSourceMetadata
    implements DataSourceMetadata {
        private final FieldSpec _fieldSpec;
        private final int _numDocs;

        StarTreeDataSourceMetadata(FieldSpec fieldSpec, int numDocs) {
            this._fieldSpec = fieldSpec;
            this._numDocs = numDocs;
        }

        public FieldSpec getFieldSpec() {
            return this._fieldSpec;
        }

        public boolean isSorted() {
            return false;
        }

        public int getNumDocs() {
            return this._numDocs;
        }

        public int getNumValues() {
            return this._numDocs;
        }

        public int getMaxNumValuesPerMVEntry() {
            return -1;
        }

        @Nullable
        public Comparable getMinValue() {
            return null;
        }

        @Nullable
        public Comparable getMaxValue() {
            return null;
        }

        @Nullable
        public PartitionFunction getPartitionFunction() {
            return null;
        }

        @Nullable
        public Set<Integer> getPartitions() {
            return null;
        }

        public int getCardinality() {
            return -1;
        }
    }
}

