/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.upsert;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.segment.local.indexsegment.immutable.ImmutableSegmentImpl;
import org.apache.pinot.segment.local.segment.readers.LazyRow;
import org.apache.pinot.segment.local.segment.readers.PrimaryKeyReader;
import org.apache.pinot.segment.local.upsert.BasePartitionUpsertMetadataManager;
import org.apache.pinot.segment.local.upsert.RecordInfo;
import org.apache.pinot.segment.local.upsert.UpsertContext;
import org.apache.pinot.segment.local.upsert.UpsertUtils;
import org.apache.pinot.segment.local.utils.HashUtils;
import org.apache.pinot.segment.local.utils.SegmentLocks;
import org.apache.pinot.segment.spi.ImmutableSegment;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.MutableSegment;
import org.apache.pinot.segment.spi.index.mutable.ThreadSafeMutableRoaringBitmap;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.PrimaryKey;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

@ThreadSafe
public class ConcurrentMapPartitionUpsertMetadataManagerForConsistentDeletes
extends BasePartitionUpsertMetadataManager {
    @VisibleForTesting
    final ConcurrentHashMap<Object, RecordLocation> _primaryKeyToRecordLocationMap = new ConcurrentHashMap();
    private final LazyRow _reusePreviousRow = new LazyRow();
    private final Map<String, Object> _reuseMergeResultHolder = new HashMap<String, Object>();

    public ConcurrentMapPartitionUpsertMetadataManagerForConsistentDeletes(String tableNameWithType, int partitionId, UpsertContext context) {
        super(tableNameWithType, partitionId, context);
    }

    @Override
    protected long getNumPrimaryKeys() {
        return this._primaryKeyToRecordLocationMap.size();
    }

    @Override
    protected void doAddOrReplaceSegment(ImmutableSegmentImpl segment, ThreadSafeMutableRoaringBitmap validDocIds, @Nullable ThreadSafeMutableRoaringBitmap queryableDocIds, Iterator<RecordInfo> recordInfoIterator, @Nullable IndexSegment oldSegment, @Nullable MutableRoaringBitmap validDocIdsForOldSegment) {
        if (this._partialUpsertHandler == null) {
            recordInfoIterator = ConcurrentMapPartitionUpsertMetadataManagerForConsistentDeletes.resolveComparisonTies(recordInfoIterator, this._hashFunction);
        }
        String segmentName = segment.getSegmentName();
        segment.enableUpsert(this, validDocIds, queryableDocIds);
        AtomicInteger numKeysInWrongSegment = new AtomicInteger();
        while (recordInfoIterator.hasNext()) {
            RecordInfo recordInfo = recordInfoIterator.next();
            int newDocId = recordInfo.getDocId();
            Comparable newComparisonValue = recordInfo.getComparisonValue();
            this._primaryKeyToRecordLocationMap.compute(HashUtils.hashPrimaryKey(recordInfo.getPrimaryKey(), this._hashFunction), (primaryKey, currentRecordLocation) -> {
                if (currentRecordLocation != null) {
                    IndexSegment currentSegment = currentRecordLocation.getSegment();
                    int currentDocId = currentRecordLocation.getDocId();
                    Comparable currentComparisonValue = currentRecordLocation.getComparisonValue();
                    int comparisonResult = newComparisonValue.compareTo(currentComparisonValue);
                    int currentDistinctSegmentCount = currentRecordLocation.getDistinctSegmentCount();
                    if (currentSegment == segment) {
                        if (comparisonResult >= 0) {
                            this.replaceDocId((IndexSegment)segment, validDocIds, queryableDocIds, currentDocId, newDocId, recordInfo);
                            return new RecordLocation((IndexSegment)segment, newDocId, newComparisonValue, currentDistinctSegmentCount);
                        }
                        return currentRecordLocation;
                    }
                    if (currentSegment == oldSegment) {
                        if (comparisonResult >= 0) {
                            if (validDocIdsForOldSegment == null && oldSegment != null && oldSegment.getValidDocIds() != null) {
                                this.replaceDocId((IndexSegment)segment, validDocIds, queryableDocIds, oldSegment, currentDocId, newDocId, recordInfo);
                            } else {
                                this.addDocId((IndexSegment)segment, validDocIds, queryableDocIds, newDocId, recordInfo);
                                if (validDocIdsForOldSegment != null) {
                                    validDocIdsForOldSegment.remove(currentDocId);
                                }
                            }
                            return new RecordLocation((IndexSegment)segment, newDocId, newComparisonValue, RecordLocation.incrementSegmentCount(currentDistinctSegmentCount));
                        }
                        return new RecordLocation(currentSegment, currentDocId, currentComparisonValue, RecordLocation.incrementSegmentCount(currentDistinctSegmentCount));
                    }
                    String currentSegmentName = currentSegment.getSegmentName();
                    if (currentSegmentName.equals(segmentName)) {
                        numKeysInWrongSegment.getAndIncrement();
                        if (comparisonResult >= 0) {
                            this.addDocId((IndexSegment)segment, validDocIds, queryableDocIds, newDocId, recordInfo);
                            return new RecordLocation((IndexSegment)segment, newDocId, newComparisonValue, RecordLocation.incrementSegmentCount(currentDistinctSegmentCount));
                        }
                        return currentRecordLocation;
                    }
                    if (comparisonResult > 0 || comparisonResult == 0 && this.shouldReplaceOnComparisonTie(segmentName, currentSegmentName, segment.getSegmentMetadata().getIndexCreationTime(), currentSegment.getSegmentMetadata().getIndexCreationTime())) {
                        this.replaceDocId((IndexSegment)segment, validDocIds, queryableDocIds, currentSegment, currentDocId, newDocId, recordInfo);
                        return new RecordLocation((IndexSegment)segment, newDocId, newComparisonValue, RecordLocation.incrementSegmentCount(currentDistinctSegmentCount));
                    }
                    return new RecordLocation(currentSegment, currentDocId, currentComparisonValue, RecordLocation.incrementSegmentCount(currentDistinctSegmentCount));
                }
                this.addDocId((IndexSegment)segment, validDocIds, queryableDocIds, newDocId, recordInfo);
                return new RecordLocation((IndexSegment)segment, newDocId, newComparisonValue, 1);
            });
        }
        int numKeys = numKeysInWrongSegment.get();
        if (numKeys > 0) {
            this._logger.warn("Found {} primary keys in the wrong segment when adding segment: {}", (Object)numKeys, (Object)segmentName);
            this._serverMetrics.addMeteredTableValue(this._tableNameWithType, (AbstractMetrics.Meter)ServerMeter.UPSERT_KEYS_IN_WRONG_SEGMENT, (long)numKeys);
        }
    }

    @Override
    protected void addSegmentWithoutUpsert(ImmutableSegmentImpl segment, ThreadSafeMutableRoaringBitmap validDocIds, @Nullable ThreadSafeMutableRoaringBitmap queryableDocIds, Iterator<RecordInfo> recordInfoIterator) {
        throw new UnsupportedOperationException("Consistent-deletion does not support preloading of segments.");
    }

    @Override
    protected void doRemoveSegment(IndexSegment segment) {
        String segmentName = segment.getSegmentName();
        this._logger.info("Removing {} segment: {}, current primary key count: {}", new Object[]{segment instanceof ImmutableSegment ? "immutable" : "mutable", segmentName, this.getNumPrimaryKeys()});
        long startTimeMs = System.currentTimeMillis();
        try (PrimaryKeyReader primaryKeyReader = new PrimaryKeyReader(segment, this._primaryKeyColumns);){
            this.removeSegment(segment, UpsertUtils.getPrimaryKeyIterator(primaryKeyReader, segment.getSegmentMetadata().getTotalDocs()));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Caught exception while removing segment: %s, table: %s", segment.getSegmentName(), this._tableNameWithType), e);
        }
        long numPrimaryKeys = this.getNumPrimaryKeys();
        this.updatePrimaryKeyGauge(numPrimaryKeys);
        this._logger.info("Finished removing segment: {} in {}ms, current primary key count: {}", new Object[]{segmentName, System.currentTimeMillis() - startTimeMs, numPrimaryKeys});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceSegment(ImmutableSegment segment, @Nullable ThreadSafeMutableRoaringBitmap validDocIds, @Nullable ThreadSafeMutableRoaringBitmap queryableDocIds, @Nullable Iterator<RecordInfo> recordInfoIterator, IndexSegment oldSegment) {
        String segmentName = segment.getSegmentName();
        Lock segmentLock = SegmentLocks.getSegmentLock(this._tableNameWithType, segmentName);
        segmentLock.lock();
        try {
            MutableRoaringBitmap validDocIdsForOldSegment;
            MutableRoaringBitmap mutableRoaringBitmap = validDocIdsForOldSegment = oldSegment.getValidDocIds() != null ? oldSegment.getValidDocIds().getMutableRoaringBitmap() : null;
            if (recordInfoIterator != null) {
                Preconditions.checkArgument((boolean)(segment instanceof ImmutableSegmentImpl), (String)"Got unsupported segment implementation: {} for segment: {}, table: {}", segment.getClass(), (Object)segmentName, (Object)this._tableNameWithType);
                if (validDocIds == null) {
                    validDocIds = new ThreadSafeMutableRoaringBitmap();
                }
                if (queryableDocIds == null && this._deleteRecordColumn != null) {
                    queryableDocIds = new ThreadSafeMutableRoaringBitmap();
                }
                this.addOrReplaceSegment((ImmutableSegmentImpl)segment, validDocIds, queryableDocIds, recordInfoIterator, oldSegment, validDocIdsForOldSegment);
            }
            if (validDocIdsForOldSegment != null && !validDocIdsForOldSegment.isEmpty() && this._partialUpsertHandler != null) {
                int numKeysNotReplaced = validDocIdsForOldSegment.getCardinality();
                this._logger.warn("Found {} primary keys not replaced when replacing segment: {} for partial-upsert table. This can potentially cause inconsistency between replicas", (Object)numKeysNotReplaced, (Object)segmentName);
                this._serverMetrics.addMeteredTableValue(this._tableNameWithType, (AbstractMetrics.Meter)ServerMeter.PARTIAL_UPSERT_KEYS_NOT_REPLACED, (long)numKeysNotReplaced);
            }
            this.doRemoveSegment(oldSegment);
        }
        finally {
            segmentLock.unlock();
        }
    }

    @Override
    protected void removeSegment(IndexSegment segment, Iterator<PrimaryKey> primaryKeyIterator) {
        HashSet uniquePrimaryKeys = new HashSet();
        while (primaryKeyIterator.hasNext()) {
            PrimaryKey primaryKey = primaryKeyIterator.next();
            this._primaryKeyToRecordLocationMap.computeIfPresent(HashUtils.hashPrimaryKey(primaryKey, this._hashFunction), (pk, recordLocation) -> {
                if (recordLocation.getSegment() == segment) {
                    return null;
                }
                if (!uniquePrimaryKeys.add(pk)) {
                    return recordLocation;
                }
                return new RecordLocation(recordLocation.getSegment(), recordLocation.getDocId(), recordLocation.getComparisonValue(), RecordLocation.decrementSegmentCount(recordLocation.getDistinctSegmentCount()));
            });
        }
    }

    @Override
    public void doRemoveExpiredPrimaryKeys() {
        int numDeletedTTLKeys;
        int numDeletedTTLKeysInMultipleSegmentsValue;
        int numDeletedKeysWithinTTLWindowValue;
        AtomicInteger numTotalKeysMarkForDeletion = new AtomicInteger();
        AtomicInteger numDeletedTTLKeysRemoved = new AtomicInteger();
        AtomicInteger numDeletedKeysWithinTTLWindow = new AtomicInteger();
        AtomicInteger numDeletedTTLKeysInMultipleSegments = new AtomicInteger();
        double largestSeenComparisonValue = this._largestSeenComparisonValue.get();
        double deletedKeysThreshold = this._deletedKeysTTL > 0.0 ? largestSeenComparisonValue - this._deletedKeysTTL : Double.NEGATIVE_INFINITY;
        this._primaryKeyToRecordLocationMap.forEach((primaryKey, recordLocation) -> {
            ThreadSafeMutableRoaringBitmap currentQueryableDocIds;
            double comparisonValue = ((Number)((Object)recordLocation.getComparisonValue())).doubleValue();
            if (this._deletedKeysTTL > 0.0 && (currentQueryableDocIds = recordLocation.getSegment().getQueryableDocIds()) != null && !currentQueryableDocIds.contains(recordLocation.getDocId())) {
                numTotalKeysMarkForDeletion.getAndIncrement();
                if (comparisonValue >= deletedKeysThreshold) {
                    numDeletedKeysWithinTTLWindow.getAndIncrement();
                } else if (recordLocation.getDistinctSegmentCount() > 1) {
                    numDeletedTTLKeysInMultipleSegments.getAndIncrement();
                } else {
                    this._primaryKeyToRecordLocationMap.remove(primaryKey, recordLocation);
                    this.removeDocId(recordLocation.getSegment(), recordLocation.getDocId());
                    numDeletedTTLKeysRemoved.getAndIncrement();
                }
            }
        });
        this.updatePrimaryKeyGauge();
        int numTotalKeysMarkedForDeletion = numTotalKeysMarkForDeletion.get();
        if (numTotalKeysMarkedForDeletion > 0) {
            this._serverMetrics.addMeteredTableValue(this._tableNameWithType, (AbstractMetrics.Meter)ServerMeter.TOTAL_KEYS_MARKED_FOR_DELETION, (long)numTotalKeysMarkedForDeletion);
        }
        if ((numDeletedKeysWithinTTLWindowValue = numDeletedKeysWithinTTLWindow.get()) > 0) {
            this._serverMetrics.addMeteredTableValue(this._tableNameWithType, (AbstractMetrics.Meter)ServerMeter.DELETED_KEYS_WITHIN_TTL_WINDOW, (long)numDeletedKeysWithinTTLWindowValue);
        }
        if ((numDeletedTTLKeysInMultipleSegmentsValue = numDeletedTTLKeysInMultipleSegments.get()) > 0) {
            this._serverMetrics.addMeteredTableValue(this._tableNameWithType, (AbstractMetrics.Meter)ServerMeter.DELETED_TTL_KEYS_IN_MULTIPLE_SEGMENTS, (long)numDeletedTTLKeysInMultipleSegmentsValue);
        }
        if ((numDeletedTTLKeys = numDeletedTTLKeysRemoved.get()) > 0) {
            this._logger.info("Deleted {} primary keys based on deletedKeysTTL", (Object)numDeletedTTLKeys);
            this._serverMetrics.addMeteredTableValue(this._tableNameWithType, (AbstractMetrics.Meter)ServerMeter.DELETED_KEYS_TTL_PRIMARY_KEYS_REMOVED, (long)numDeletedTTLKeys);
        }
    }

    @Override
    protected boolean doAddRecord(MutableSegment segment, RecordInfo recordInfo) {
        AtomicBoolean isOutOfOrderRecord = new AtomicBoolean(false);
        ThreadSafeMutableRoaringBitmap validDocIds = Objects.requireNonNull(segment.getValidDocIds());
        ThreadSafeMutableRoaringBitmap queryableDocIds = segment.getQueryableDocIds();
        int newDocId = recordInfo.getDocId();
        Comparable newComparisonValue = recordInfo.getComparisonValue();
        if (this._deletedKeysTTL > 0.0) {
            double comparisonValue = ((Number)((Object)newComparisonValue)).doubleValue();
            this._largestSeenComparisonValue.getAndUpdate(v -> Math.max(v, comparisonValue));
        }
        this._primaryKeyToRecordLocationMap.compute(HashUtils.hashPrimaryKey(recordInfo.getPrimaryKey(), this._hashFunction), (primaryKey, currentRecordLocation) -> {
            if (currentRecordLocation != null) {
                IndexSegment currentSegment = currentRecordLocation.getSegment();
                if (newComparisonValue.compareTo(currentRecordLocation.getComparisonValue()) >= 0) {
                    int currentDocId = currentRecordLocation.getDocId();
                    if (segment == currentSegment) {
                        this.replaceDocId((IndexSegment)segment, validDocIds, queryableDocIds, currentDocId, newDocId, recordInfo);
                        return new RecordLocation((IndexSegment)segment, newDocId, newComparisonValue, currentRecordLocation.getDistinctSegmentCount());
                    }
                    this.replaceDocId((IndexSegment)segment, validDocIds, queryableDocIds, currentSegment, currentDocId, newDocId, recordInfo);
                    return new RecordLocation((IndexSegment)segment, newDocId, newComparisonValue, RecordLocation.incrementSegmentCount(currentRecordLocation.getDistinctSegmentCount()));
                }
                this.handleOutOfOrderEvent(currentRecordLocation.getComparisonValue(), recordInfo.getComparisonValue());
                isOutOfOrderRecord.set(true);
                if (segment == currentSegment) {
                    return currentRecordLocation;
                }
                return new RecordLocation(currentSegment, currentRecordLocation.getDocId(), currentRecordLocation.getComparisonValue(), this._context.isDropOutOfOrderRecord() ? currentRecordLocation.getDistinctSegmentCount() : RecordLocation.incrementSegmentCount(currentRecordLocation.getDistinctSegmentCount()));
            }
            this.addDocId((IndexSegment)segment, validDocIds, queryableDocIds, newDocId, recordInfo);
            return new RecordLocation((IndexSegment)segment, newDocId, newComparisonValue, 1);
        });
        this.updatePrimaryKeyGauge();
        return !isOutOfOrderRecord.get();
    }

    @Override
    protected GenericRow doUpdateRecord(GenericRow record, RecordInfo recordInfo) {
        assert (this._partialUpsertHandler != null);
        this._primaryKeyToRecordLocationMap.computeIfPresent(HashUtils.hashPrimaryKey(recordInfo.getPrimaryKey(), this._hashFunction), (pk, recordLocation) -> {
            if (!recordInfo.isDeleteRecord() && recordInfo.getComparisonValue().compareTo(recordLocation.getComparisonValue()) >= 0) {
                IndexSegment currentSegment = recordLocation.getSegment();
                ThreadSafeMutableRoaringBitmap currentQueryableDocIds = currentSegment.getQueryableDocIds();
                int currentDocId = recordLocation.getDocId();
                if (currentQueryableDocIds == null || currentQueryableDocIds.contains(currentDocId)) {
                    this._reusePreviousRow.init(currentSegment, currentDocId);
                    this._partialUpsertHandler.merge(this._reusePreviousRow, record, this._reuseMergeResultHolder);
                    this._reuseMergeResultHolder.clear();
                }
            }
            return recordLocation;
        });
        return record;
    }

    @VisibleForTesting
    static class RecordLocation {
        private final IndexSegment _segment;
        private final int _docId;
        private final Comparable _comparisonValue;
        private final int _distinctSegmentCount;

        public RecordLocation(IndexSegment indexSegment, int docId, Comparable comparisonValue, int distinctSegmentCount) {
            this._segment = indexSegment;
            this._docId = docId;
            this._comparisonValue = comparisonValue;
            this._distinctSegmentCount = distinctSegmentCount;
        }

        public static int incrementSegmentCount(int count) {
            return count + 1;
        }

        public static int decrementSegmentCount(int count) {
            return count - 1;
        }

        public IndexSegment getSegment() {
            return this._segment;
        }

        public int getDocId() {
            return this._docId;
        }

        public Comparable getComparisonValue() {
            return this._comparisonValue;
        }

        public int getDistinctSegmentCount() {
            return this._distinctSegmentCount;
        }
    }
}

