/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.upsert;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.pinot.common.utils.config.QueryOptionsUtils;
import org.apache.pinot.segment.local.upsert.RecordInfo;
import org.apache.pinot.segment.local.upsert.UpsertContext;
import org.apache.pinot.segment.local.upsert.UpsertUtils;
import org.apache.pinot.segment.spi.ImmutableSegment;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.SegmentContext;
import org.apache.pinot.segment.spi.index.mutable.ThreadSafeMutableRoaringBitmap;
import org.apache.pinot.spi.config.table.UpsertConfig;
import org.roaringbitmap.buffer.MutableRoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpsertViewManager {
    public static final long DEFAULT_NEW_SEGMENT_TRACKING_TIME_MS = 10000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(UpsertViewManager.class);
    private final UpsertConfig.ConsistencyMode _consistencyMode;
    private final ReadWriteLock _trackedSegmentsLock = new ReentrantReadWriteLock();
    private final Set<IndexSegment> _trackedSegments = ConcurrentHashMap.newKeySet();
    private final ReadWriteLock _upsertViewLock = new ReentrantReadWriteLock();
    private volatile Map<IndexSegment, MutableRoaringBitmap> _segmentQueryableDocIdsMap;
    private final Set<IndexSegment> _updatedSegmentsSinceLastRefresh = ConcurrentHashMap.newKeySet();
    private volatile long _lastUpsertViewRefreshTimeMs = 0L;
    private final long _upsertViewRefreshIntervalMs;

    public UpsertViewManager(UpsertConfig.ConsistencyMode consistencyMode, UpsertContext context) {
        this._consistencyMode = consistencyMode;
        this._upsertViewRefreshIntervalMs = context.getUpsertViewRefreshIntervalMs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceDocId(IndexSegment newSegment, ThreadSafeMutableRoaringBitmap validDocIds, ThreadSafeMutableRoaringBitmap queryableDocIds, IndexSegment oldSegment, int oldDocId, int newDocId, RecordInfo recordInfo) {
        if (this._consistencyMode == UpsertConfig.ConsistencyMode.SYNC) {
            this._upsertViewLock.writeLock().lock();
            try {
                UpsertUtils.doRemoveDocId(oldSegment, oldDocId);
                UpsertUtils.doAddDocId(validDocIds, queryableDocIds, newDocId, recordInfo);
                return;
            }
            finally {
                this._upsertViewLock.writeLock().unlock();
            }
        }
        this._upsertViewLock.readLock().lock();
        try {
            UpsertUtils.doRemoveDocId(oldSegment, oldDocId);
            UpsertUtils.doAddDocId(validDocIds, queryableDocIds, newDocId, recordInfo);
            this._updatedSegmentsSinceLastRefresh.add(newSegment);
            this._updatedSegmentsSinceLastRefresh.add(oldSegment);
        }
        finally {
            this._upsertViewLock.readLock().unlock();
            this.doBatchRefreshUpsertView(this._upsertViewRefreshIntervalMs, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceDocId(IndexSegment segment, ThreadSafeMutableRoaringBitmap validDocIds, ThreadSafeMutableRoaringBitmap queryableDocIds, int oldDocId, int newDocId, RecordInfo recordInfo) {
        if (this._consistencyMode == UpsertConfig.ConsistencyMode.SYNC) {
            UpsertUtils.doReplaceDocId(validDocIds, queryableDocIds, oldDocId, newDocId, recordInfo);
            return;
        }
        this._upsertViewLock.readLock().lock();
        try {
            UpsertUtils.doReplaceDocId(validDocIds, queryableDocIds, oldDocId, newDocId, recordInfo);
            this._updatedSegmentsSinceLastRefresh.add(segment);
        }
        finally {
            this._upsertViewLock.readLock().unlock();
            this.doBatchRefreshUpsertView(this._upsertViewRefreshIntervalMs, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocId(IndexSegment segment, ThreadSafeMutableRoaringBitmap validDocIds, ThreadSafeMutableRoaringBitmap queryableDocIds, int docId, RecordInfo recordInfo) {
        if (this._consistencyMode == UpsertConfig.ConsistencyMode.SYNC) {
            UpsertUtils.doAddDocId(validDocIds, queryableDocIds, docId, recordInfo);
            return;
        }
        this._upsertViewLock.readLock().lock();
        try {
            UpsertUtils.doAddDocId(validDocIds, queryableDocIds, docId, recordInfo);
            this._updatedSegmentsSinceLastRefresh.add(segment);
        }
        finally {
            this._upsertViewLock.readLock().unlock();
            this.doBatchRefreshUpsertView(this._upsertViewRefreshIntervalMs, false);
        }
    }

    public void removeDocId(IndexSegment segment, int docId) {
        if (this._consistencyMode == UpsertConfig.ConsistencyMode.SYNC) {
            UpsertUtils.doRemoveDocId(segment, docId);
            return;
        }
        this._upsertViewLock.readLock().lock();
        try {
            UpsertUtils.doRemoveDocId(segment, docId);
            this._updatedSegmentsSinceLastRefresh.add(segment);
        }
        finally {
            this._upsertViewLock.readLock().unlock();
            this.doBatchRefreshUpsertView(this._upsertViewRefreshIntervalMs, false);
        }
    }

    public void setSegmentContexts(List<SegmentContext> segmentContexts, Map<String, String> queryOptions) {
        if (this._consistencyMode == UpsertConfig.ConsistencyMode.SYNC) {
            this._upsertViewLock.readLock().lock();
            try {
                this.setSegmentContexts(segmentContexts);
                return;
            }
            finally {
                this._upsertViewLock.readLock().unlock();
            }
        }
        long upsertViewFreshnessMs = Math.min(QueryOptionsUtils.getUpsertViewFreshnessMs(queryOptions), this._upsertViewRefreshIntervalMs);
        if (upsertViewFreshnessMs < 0L) {
            upsertViewFreshnessMs = this._upsertViewRefreshIntervalMs;
        }
        this.doBatchRefreshUpsertView(upsertViewFreshnessMs, false);
        Map<IndexSegment, MutableRoaringBitmap> currentUpsertView = this._segmentQueryableDocIdsMap;
        for (SegmentContext segmentContext : segmentContexts) {
            IndexSegment segment = segmentContext.getIndexSegment();
            MutableRoaringBitmap segmentView = currentUpsertView.get(segment);
            if (segmentView == null) continue;
            segmentContext.setQueryableDocIdsSnapshot(segmentView);
        }
    }

    private void setSegmentContexts(List<SegmentContext> segmentContexts) {
        for (SegmentContext segmentContext : segmentContexts) {
            IndexSegment segment = segmentContext.getIndexSegment();
            if (!this._trackedSegments.contains(segment)) continue;
            segmentContext.setQueryableDocIdsSnapshot(UpsertUtils.getQueryableDocIdsSnapshotFromSegment(segment, true));
        }
    }

    private boolean skipUpsertViewRefresh(long upsertViewFreshnessMs) {
        if (upsertViewFreshnessMs < 0L) {
            return true;
        }
        return this._lastUpsertViewRefreshTimeMs + upsertViewFreshnessMs > System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void doBatchRefreshUpsertView(long upsertViewFreshnessMs, boolean forceRefresh) {
        if (!forceRefresh && this.skipUpsertViewRefresh(upsertViewFreshnessMs) && this._segmentQueryableDocIdsMap != null) {
            return;
        }
        this._upsertViewLock.writeLock().lock();
        try {
            Map<IndexSegment, MutableRoaringBitmap> current = this._segmentQueryableDocIdsMap;
            if (!forceRefresh && this.skipUpsertViewRefresh(upsertViewFreshnessMs) && current != null) {
                return;
            }
            if (LOGGER.isDebugEnabled()) {
                if (current == null) {
                    LOGGER.debug("Current upsert view is still null");
                } else {
                    current.forEach((segment, bitmap) -> LOGGER.debug("Current upsert view of segment: {}, type: {}, total: {}, valid: {}", new Object[]{segment.getSegmentName(), segment instanceof ImmutableSegment ? "imm" : "mut", segment.getSegmentMetadata().getTotalDocs(), bitmap.getCardinality()}));
                }
            }
            HashMap<IndexSegment, MutableRoaringBitmap> updated = new HashMap<IndexSegment, MutableRoaringBitmap>();
            for (IndexSegment segment2 : this._trackedSegments) {
                if (current == null || current.get(segment2) == null || this._updatedSegmentsSinceLastRefresh.contains(segment2)) {
                    updated.put(segment2, UpsertUtils.getQueryableDocIdsSnapshotFromSegment(segment2, true));
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("Update upsert view of segment: {}, type: {}, total: {}, valid: {}, reason: {}", new Object[]{segment2.getSegmentName(), segment2 instanceof ImmutableSegment ? "imm" : "mut", segment2.getSegmentMetadata().getTotalDocs(), ((MutableRoaringBitmap)updated.get(segment2)).getCardinality(), current == null || current.get(segment2) == null ? "no view yet" : "bitmap updated"});
                    continue;
                }
                updated.put(segment2, current.get(segment2));
            }
            if (LOGGER.isDebugEnabled()) {
                updated.forEach((segment, bitmap) -> LOGGER.debug("Updated upsert view of segment: {}, type: {}, total: {}, valid: {}", new Object[]{segment.getSegmentName(), segment instanceof ImmutableSegment ? "imm" : "mut", segment.getSegmentMetadata().getTotalDocs(), bitmap.getCardinality()}));
            }
            this._segmentQueryableDocIdsMap = updated;
            this._updatedSegmentsSinceLastRefresh.clear();
            this._lastUpsertViewRefreshTimeMs = System.currentTimeMillis();
        }
        finally {
            this._upsertViewLock.writeLock().unlock();
        }
    }

    public void lockTrackedSegments() {
        this._trackedSegmentsLock.readLock().lock();
    }

    public void unlockTrackedSegments() {
        this._trackedSegmentsLock.readLock().unlock();
    }

    public void trackSegment(IndexSegment segment) {
        this._trackedSegmentsLock.writeLock().lock();
        try {
            this._trackedSegments.add(segment);
            if (this._consistencyMode == UpsertConfig.ConsistencyMode.SNAPSHOT) {
                this.doBatchRefreshUpsertView(0L, true);
            }
        }
        finally {
            this._trackedSegmentsLock.writeLock().unlock();
        }
    }

    public void untrackSegment(IndexSegment segment) {
        this._trackedSegmentsLock.writeLock().lock();
        try {
            this._trackedSegments.remove(segment);
        }
        finally {
            this._trackedSegmentsLock.writeLock().unlock();
        }
    }

    @VisibleForTesting
    Map<IndexSegment, MutableRoaringBitmap> getSegmentQueryableDocIdsMap() {
        return this._segmentQueryableDocIdsMap;
    }

    @VisibleForTesting
    Set<IndexSegment> getUpdatedSegmentsSinceLastRefresh() {
        return this._updatedSegmentsSinceLastRefresh;
    }

    @VisibleForTesting
    Set<IndexSegment> getTrackedSegments() {
        return this._trackedSegments;
    }
}

