/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.upsert.merger.columnar;

import org.apache.pinot.segment.local.upsert.merger.columnar.AppendMerger;
import org.apache.pinot.segment.local.upsert.merger.columnar.IgnoreMerger;
import org.apache.pinot.segment.local.upsert.merger.columnar.IncrementMerger;
import org.apache.pinot.segment.local.upsert.merger.columnar.MaxMerger;
import org.apache.pinot.segment.local.upsert.merger.columnar.MinMerger;
import org.apache.pinot.segment.local.upsert.merger.columnar.OverwriteMerger;
import org.apache.pinot.segment.local.upsert.merger.columnar.PartialUpsertColumnMerger;
import org.apache.pinot.segment.local.upsert.merger.columnar.UnionMerger;
import org.apache.pinot.spi.config.table.UpsertConfig;

public class PartialUpsertColumnMergerFactory {
    private static final AppendMerger APPEND_MERGER = new AppendMerger();
    private static final IncrementMerger INCREMENT_MERGER = new IncrementMerger();
    private static final IgnoreMerger IGNORE_MERGER = new IgnoreMerger();
    private static final OverwriteMerger OVERWRITE_MERGER = new OverwriteMerger();
    private static final MaxMerger MAX_MERGER = new MaxMerger();
    private static final MinMerger MIN_MERGER = new MinMerger();
    private static final UnionMerger UNION_MERGER = new UnionMerger();

    private PartialUpsertColumnMergerFactory() {
    }

    public static PartialUpsertColumnMerger getMerger(UpsertConfig.Strategy strategy) {
        switch (strategy) {
            case APPEND: {
                return APPEND_MERGER;
            }
            case INCREMENT: {
                return INCREMENT_MERGER;
            }
            case IGNORE: {
                return IGNORE_MERGER;
            }
            case MAX: {
                return MAX_MERGER;
            }
            case MIN: {
                return MIN_MERGER;
            }
            case OVERWRITE: {
                return OVERWRITE_MERGER;
            }
            case UNION: {
                return UNION_MERGER;
            }
        }
        throw new IllegalStateException("Unsupported partial upsert strategy: " + strategy);
    }
}

