/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils;

import com.google.common.base.Joiner;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.io.geojson.GeoJsonReader;
import org.locationtech.jts.io.geojson.GeoJsonWriter;

public class GeometryUtils {
    public static final int GEOGRAPHY_SRID = 4326;
    public static final byte GEOGRAPHY_SET_MASK = -128;
    public static final byte GEOGRAPHY_GET_MASK = 127;
    public static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();
    public static final GeometryFactory GEOGRAPHY_FACTORY = new GeometryFactory(new PrecisionModel(), 4326);
    public static final WKTReader GEOMETRY_WKT_READER = new WKTReader(GEOMETRY_FACTORY);
    public static final WKTReader GEOGRAPHY_WKT_READER = new WKTReader(GEOGRAPHY_FACTORY);
    public static final GeoJsonReader GEOMETRY_GEO_JSON_READER = new GeoJsonReader(GEOMETRY_FACTORY);
    public static final GeoJsonReader GEOGRAPHY_GEO_JSON_READER = new GeoJsonReader(GEOGRAPHY_FACTORY);
    public static final WKBReader GEOMETRY_WKB_READER = new WKBReader(GEOMETRY_FACTORY);
    public static final WKBReader GEOGRAPHY_WKB_READER = new WKBReader(GEOGRAPHY_FACTORY);
    public static final WKTWriter WKT_WRITER = new WKTWriter();
    public static final WKBWriter WKB_WRITER = new WKBWriter();
    public static final GeoJsonWriter GEO_JSON_WRITER = new GeoJsonWriter();
    public static final double EARTH_RADIUS_KM = 6371.01;
    public static final double EARTH_RADIUS_M = 6371010.0;
    public static final Joiner OR_JOINER = Joiner.on((String)" or ");
    public static final Geometry EMPTY_POINT = GEOMETRY_FACTORY.createPoint();

    private GeometryUtils() {
    }

    public static boolean isGeography(Geometry geometry) {
        return geometry.getSRID() == 4326;
    }

    public static void setGeography(Geometry geometry) {
        geometry.setSRID(4326);
    }

    public static void setGeometry(Geometry geometry) {
        geometry.setSRID(0);
    }
}

