/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils;

import com.dynatrace.hash4j.hashing.HashFunnel;
import com.dynatrace.hash4j.hashing.HashSink;
import com.dynatrace.hash4j.hashing.Hasher64;
import com.dynatrace.hash4j.hashing.Hashing;
import java.math.BigDecimal;
import java.util.Optional;

public class UltraLogLogUtils {
    public static final HashFunnel<Object> OBJECT_FUNNEL = new HashFunnel<Object>(){

        public void put(Object o, HashSink hashSink) {
            if (o instanceof Integer) {
                hashSink.putInt(((Integer)o).intValue());
            } else if (o instanceof Long) {
                hashSink.putLong(((Long)o).longValue());
            } else if (o instanceof Float) {
                hashSink.putFloat(((Float)o).floatValue());
            } else if (o instanceof Double) {
                hashSink.putDouble(((Double)o).doubleValue());
            } else if (o instanceof BigDecimal) {
                hashSink.putString(((BigDecimal)o).toString());
            } else if (o instanceof String) {
                hashSink.putString((String)o);
            } else if (o instanceof byte[]) {
                hashSink.putBytes((byte[])o);
            } else {
                throw new IllegalArgumentException("Unrecognised input type for UltraLogLog: " + o.getClass().getSimpleName());
            }
        }
    };

    private UltraLogLogUtils() {
    }

    public static Hasher64 defaultHasher() {
        return Hashing.wyhashFinal4();
    }

    public static Optional<Long> hashObject(Object obj) {
        return Optional.ofNullable(obj).map(o -> UltraLogLogUtils.defaultHasher().hashToLong(o, OBJECT_FUNNEL));
    }
}

