/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatermarkUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(WatermarkUtils.class);

    private WatermarkUtils() {
    }

    public static double loadWatermark(File watermarkFile, double defaultWatermark) {
        if (watermarkFile.exists()) {
            try {
                byte[] bytes = FileUtils.readFileToByteArray((File)watermarkFile);
                double watermark = ByteBuffer.wrap(bytes).getDouble();
                LOGGER.info("Loaded watermark: {} from file: {}", (Object)watermark, (Object)watermarkFile);
                return watermark;
            }
            catch (Exception e) {
                LOGGER.warn("Failed to load watermark from file: {}, skipping", (Object)watermarkFile);
            }
        }
        return defaultWatermark;
    }

    public static void persistWatermark(double watermark, File watermarkFile) {
        try {
            if (watermarkFile.exists() && !FileUtils.deleteQuietly((File)watermarkFile)) {
                LOGGER.warn("Cannot delete watermark file: {} to persist watermark: {}, skipping", (Object)watermarkFile, (Object)watermark);
                return;
            }
            try (FileOutputStream outputStream = new FileOutputStream(watermarkFile, false);
                 DataOutputStream dataOutputStream = new DataOutputStream(outputStream);){
                dataOutputStream.writeDouble(watermark);
            }
            LOGGER.info("Persisted watermark: {} to file: {}", (Object)watermark, (Object)watermarkFile);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to persist watermark: {} to file: {}, skipping", (Object)watermark, (Object)watermarkFile);
        }
    }

    public static void deleteWatermark(File watermarkFile) {
        if (watermarkFile.exists() && !FileUtils.deleteQuietly((File)watermarkFile)) {
            LOGGER.warn("Cannot delete watermark file: {}, skipping", (Object)watermarkFile);
        }
    }
}

