/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.mapping;

import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.trino.cache.NonKeyEvictableCache;
import io.trino.cache.SafeCaches;
import io.trino.plugin.base.mapping.IdentifierMapping;
import io.trino.plugin.base.mapping.IdentifierMappingModule;
import io.trino.plugin.base.mapping.MappingConfig;
import io.trino.plugin.base.mapping.RemoteIdentifiers;
import io.trino.plugin.base.mapping.RemoteTableNameCacheKey;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.security.ConnectorIdentity;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public final class CachingIdentifierMapping
implements IdentifierMapping {
    private final NonKeyEvictableCache<ConnectorIdentity, Mapping> remoteSchemaNames;
    private final NonKeyEvictableCache<RemoteTableNameCacheKey, Mapping> remoteTableNames;
    private final IdentifierMapping identifierMapping;

    @Inject
    public CachingIdentifierMapping(MappingConfig mappingConfig, @IdentifierMappingModule.ForCachingIdentifierMapping IdentifierMapping identifierMapping) {
        CacheBuilder remoteNamesCacheBuilder = CacheBuilder.newBuilder().expireAfterWrite(mappingConfig.getCaseInsensitiveNameMatchingCacheTtl().toMillis(), TimeUnit.MILLISECONDS);
        this.remoteSchemaNames = SafeCaches.buildNonEvictableCacheWithWeakInvalidateAll((CacheBuilder)remoteNamesCacheBuilder);
        this.remoteTableNames = SafeCaches.buildNonEvictableCacheWithWeakInvalidateAll((CacheBuilder)remoteNamesCacheBuilder);
        this.identifierMapping = Objects.requireNonNull(identifierMapping, "identifierMapping is null");
    }

    public void flushCache() {
        this.remoteSchemaNames.invalidateAll();
        this.remoteTableNames.invalidateAll();
    }

    @Override
    public String fromRemoteSchemaName(String remoteSchemaName) {
        return this.identifierMapping.fromRemoteSchemaName(remoteSchemaName);
    }

    @Override
    public String fromRemoteTableName(String remoteSchemaName, String remoteTableName) {
        return this.identifierMapping.fromRemoteTableName(remoteSchemaName, remoteTableName);
    }

    @Override
    public String fromRemoteColumnName(String remoteColumnName) {
        return this.identifierMapping.fromRemoteColumnName(remoteColumnName);
    }

    @Override
    public String toRemoteSchemaName(RemoteIdentifiers remoteIdentifiers, ConnectorIdentity identity, String schemaName) {
        Objects.requireNonNull(schemaName, "schemaName is null");
        Verify.verify((boolean)CharMatcher.forPredicate(Character::isUpperCase).matchesNoneOf((CharSequence)schemaName), (String)"Expected schema name from internal metadata to be lowercase: %s", (Object)schemaName);
        try {
            String remoteSchema;
            Mapping mapping = (Mapping)this.remoteSchemaNames.getIfPresent((Object)identity);
            if (mapping != null && !mapping.hasRemoteObject(schemaName)) {
                mapping = null;
            }
            if (mapping == null) {
                mapping = this.createSchemaMapping(remoteIdentifiers.getRemoteSchemas());
                this.remoteSchemaNames.put((Object)identity, (Object)mapping);
            }
            if ((remoteSchema = mapping.get(schemaName)) != null) {
                return remoteSchema;
            }
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to find remote schema name: " + String.valueOf(MoreObjects.firstNonNull((Object)e.getMessage(), (Object)e)), (Throwable)e);
        }
        return this.identifierMapping.toRemoteSchemaName(remoteIdentifiers, identity, schemaName);
    }

    @Override
    public String toRemoteTableName(RemoteIdentifiers remoteIdentifiers, ConnectorIdentity identity, String remoteSchema, String tableName) {
        Objects.requireNonNull(remoteSchema, "remoteSchema is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Verify.verify((boolean)CharMatcher.forPredicate(Character::isUpperCase).matchesNoneOf((CharSequence)tableName), (String)"Expected table name from internal metadata to be lowercase: %s", (Object)tableName);
        try {
            String remoteTable;
            RemoteTableNameCacheKey cacheKey = new RemoteTableNameCacheKey(identity, remoteSchema);
            Mapping mapping = (Mapping)this.remoteTableNames.getIfPresent((Object)cacheKey);
            if (mapping != null && !mapping.hasRemoteObject(tableName)) {
                mapping = null;
            }
            if (mapping == null) {
                mapping = this.createTableMapping(remoteSchema, remoteIdentifiers.getRemoteTables(remoteSchema));
                this.remoteTableNames.put((Object)cacheKey, (Object)mapping);
            }
            if ((remoteTable = mapping.get(tableName)) != null) {
                return remoteTable;
            }
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to find remote table name: " + String.valueOf(MoreObjects.firstNonNull((Object)e.getMessage(), (Object)e)), (Throwable)e);
        }
        return this.identifierMapping.toRemoteTableName(remoteIdentifiers, identity, remoteSchema, tableName);
    }

    @Override
    public String toRemoteColumnName(RemoteIdentifiers remoteIdentifiers, String columnName) {
        return this.identifierMapping.toRemoteColumnName(remoteIdentifiers, columnName);
    }

    private Mapping createSchemaMapping(Collection<String> remoteSchemas) {
        return CachingIdentifierMapping.createMapping(remoteSchemas, this.identifierMapping::fromRemoteSchemaName);
    }

    private Mapping createTableMapping(String remoteSchema, Set<String> remoteTables) {
        return CachingIdentifierMapping.createMapping(remoteTables, remoteTableName -> this.identifierMapping.fromRemoteTableName(remoteSchema, (String)remoteTableName));
    }

    private static Mapping createMapping(Collection<String> remoteNames, Function<String, String> mapping) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashSet<String> duplicates = new HashSet<String>();
        for (String remoteName : remoteNames) {
            String name = mapping.apply(remoteName);
            if (duplicates.contains(name) || map.put(name, remoteName) == null) continue;
            duplicates.add(name);
            map.remove(name);
        }
        return new Mapping(map, duplicates);
    }

    private static final class Mapping {
        private final Map<String, String> mapping;
        private final Set<String> duplicates;

        public Mapping(Map<String, String> mapping, Set<String> duplicates) {
            this.mapping = ImmutableMap.copyOf(Objects.requireNonNull(mapping, "mapping is null"));
            this.duplicates = ImmutableSet.copyOf((Collection)Objects.requireNonNull(duplicates, "duplicates is null"));
        }

        public boolean hasRemoteObject(String remoteName) {
            return this.mapping.containsKey(remoteName) || this.duplicates.contains(remoteName);
        }

        @Nullable
        public String get(String remoteName) {
            Preconditions.checkArgument((!this.duplicates.contains(remoteName) ? 1 : 0) != 0, (String)"Ambiguous name: %s", (Object)remoteName);
            return this.mapping.get(remoteName);
        }
    }
}

