/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base;

import com.google.common.collect.ImmutableSet;
import com.google.common.io.Closer;
import com.google.inject.Binder;
import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.multibindings.Multibinder;
import jakarta.annotation.PreDestroy;
import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class ClosingBinder {
    private final Multibinder<ExecutorService> executors;
    private final Multibinder<Closeable> closeables;

    public static ClosingBinder closingBinder(Binder binder) {
        return new ClosingBinder(binder);
    }

    private ClosingBinder(Binder binder) {
        this.executors = Multibinder.newSetBinder((Binder)binder, ExecutorService.class, ForCleanup.class);
        this.closeables = Multibinder.newSetBinder((Binder)binder, Closeable.class, ForCleanup.class);
        binder.bind(Cleanup.class).asEagerSingleton();
    }

    public ClosingBinder registerExecutor(Class<? extends ExecutorService> type) {
        this.executors.addBinding().to(type);
        return this;
    }

    public ClosingBinder registerExecutor(Class<? extends ExecutorService> type, Class<? extends Annotation> annotation) {
        this.executors.addBinding().to(Key.get(type, annotation));
        return this;
    }

    public ClosingBinder registerCloseable(Class<? extends Closeable> type) {
        this.closeables.addBinding().to(type);
        return this;
    }

    public ClosingBinder registerCloseable(Class<? extends Closeable> type, Class<? extends Annotation> annotation) {
        this.closeables.addBinding().to(Key.get(type, annotation));
        return this;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @BindingAnnotation
    private static @interface ForCleanup {
    }

    private static class Cleanup {
        private final Set<ExecutorService> executors;
        private final Set<Closeable> closeables;

        @Inject
        public Cleanup(@ForCleanup Set<ExecutorService> executors, @ForCleanup Set<Closeable> closeables) {
            this.executors = ImmutableSet.copyOf(executors);
            this.closeables = ImmutableSet.copyOf(closeables);
        }

        @PreDestroy
        public void shutdown() throws IOException {
            this.executors.forEach(ExecutorService::shutdownNow);
            try (Closer closer = Closer.create();){
                this.closeables.forEach(arg_0 -> ((Closer)closer).register(arg_0));
            }
        }
    }
}

