/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.classloader;

import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorAccessControl;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorMergeSink;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorMetadata;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorPageSink;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorPageSinkProvider;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorPageSourceProvider;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorRecordSetProvider;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorSplitManager;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorSplitSource;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorTableFunction;
import io.trino.plugin.base.classloader.ClassLoaderSafeEventListener;
import io.trino.plugin.base.classloader.ClassLoaderSafeIterator;
import io.trino.plugin.base.classloader.ClassLoaderSafeNodePartitioningProvider;
import io.trino.plugin.base.classloader.ClassLoaderSafeRecordSet;
import io.trino.plugin.base.classloader.ClassLoaderSafeSystemTable;
import io.trino.plugin.base.classloader.ClassLoaderSafeTableFunctionDataProcessor;
import io.trino.plugin.base.classloader.ClassLoaderSafeTableFunctionProcessorProvider;
import io.trino.plugin.base.classloader.ClassLoaderSafeTableFunctionSplitProcessor;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorMergeSink;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.function.table.ConnectorTableFunction;
import io.trino.spi.function.table.TableFunctionDataProcessor;
import io.trino.spi.function.table.TableFunctionProcessorProvider;
import io.trino.spi.function.table.TableFunctionSplitProcessor;
import io.trino.spi.testing.InterfaceTestUtils;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Stream;
import org.assertj.core.api.Fail;
import org.junit.jupiter.api.Test;

public class TestClassLoaderSafeWrappers {
    @Test
    public void test() throws Exception {
        TestClassLoaderSafeWrappers.testClassLoaderSafe(ConnectorAccessControl.class, ClassLoaderSafeConnectorAccessControl.class);
        TestClassLoaderSafeWrappers.testClassLoaderSafe(ConnectorMetadata.class, ClassLoaderSafeConnectorMetadata.class);
        TestClassLoaderSafeWrappers.testClassLoaderSafe(ConnectorMergeSink.class, ClassLoaderSafeConnectorMergeSink.class);
        TestClassLoaderSafeWrappers.testClassLoaderSafe(ConnectorPageSink.class, ClassLoaderSafeConnectorPageSink.class);
        TestClassLoaderSafeWrappers.testClassLoaderSafe(ConnectorPageSinkProvider.class, ClassLoaderSafeConnectorPageSinkProvider.class);
        TestClassLoaderSafeWrappers.testClassLoaderSafe(ConnectorPageSourceProvider.class, ClassLoaderSafeConnectorPageSourceProvider.class);
        TestClassLoaderSafeWrappers.testClassLoaderSafe(ConnectorSplitManager.class, ClassLoaderSafeConnectorSplitManager.class);
        TestClassLoaderSafeWrappers.testClassLoaderSafe(ConnectorNodePartitioningProvider.class, ClassLoaderSafeNodePartitioningProvider.class);
        TestClassLoaderSafeWrappers.testClassLoaderSafe(ConnectorSplitSource.class, ClassLoaderSafeConnectorSplitSource.class);
        TestClassLoaderSafeWrappers.testClassLoaderSafe(SystemTable.class, ClassLoaderSafeSystemTable.class);
        TestClassLoaderSafeWrappers.testClassLoaderSafe(ConnectorRecordSetProvider.class, ClassLoaderSafeConnectorRecordSetProvider.class);
        TestClassLoaderSafeWrappers.testClassLoaderSafe(RecordSet.class, ClassLoaderSafeRecordSet.class);
        TestClassLoaderSafeWrappers.testClassLoaderSafe(EventListener.class, ClassLoaderSafeEventListener.class);
        TestClassLoaderSafeWrappers.testClassLoaderSafe(ConnectorTableFunction.class, ClassLoaderSafeConnectorTableFunction.class);
        TestClassLoaderSafeWrappers.testClassLoaderSafe(TableFunctionSplitProcessor.class, ClassLoaderSafeTableFunctionSplitProcessor.class);
        TestClassLoaderSafeWrappers.testClassLoaderSafe(TableFunctionDataProcessor.class, ClassLoaderSafeTableFunctionDataProcessor.class);
        TestClassLoaderSafeWrappers.testClassLoaderSafe(TableFunctionProcessorProvider.class, ClassLoaderSafeTableFunctionProcessorProvider.class);
    }

    private static <I, C extends I> void testClassLoaderSafe(Class<I> iface, Class<C> clazz) throws Exception {
        TestClassLoaderSafeWrappers.testClassLoaderSafe(iface, clazz, Set.of());
    }

    private static <I, C extends I> void testClassLoaderSafe(Class<I> iface, Class<C> clazz, Set<Method> exclusions) throws Exception {
        InterfaceTestUtils.assertAllMethodsOverridden(iface, clazz, exclusions);
        for (Method method : iface.getMethods()) {
            if (exclusions.contains(method)) continue;
            Method implementation = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
            if (Stream.class.isAssignableFrom(implementation.getReturnType())) {
                Fail.fail((String)String.format("Method %s returns a Stream, breaks class-loader safety", method));
            }
            if (!Iterator.class.isAssignableFrom(implementation.getReturnType()) || ClassLoaderSafeIterator.class.isAssignableFrom(implementation.getReturnType())) continue;
            Fail.fail((String)String.format("Method %s returns an Iterator (but not ClassLoaderSafeIterator), breaks class-loader safety", method));
        }
    }
}

