/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.filter;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.plugin.base.filter.UtcConstraintExtractor;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.TestingColumnHandle;
import io.trino.spi.expression.Call;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Constant;
import io.trino.spi.expression.FunctionName;
import io.trino.spi.expression.StandardFunctions;
import io.trino.spi.expression.Variable;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestUtcConstraintExtractor {
    private static final ColumnHandle A_BIGINT = new TestingColumnHandle("a_bigint");

    @Test
    public void testExtractSummary() {
        Assertions.assertThat(TestUtcConstraintExtractor.extract(new Constraint(TupleDomain.withColumnDomains(Map.of(A_BIGINT, Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))), (ConnectorExpression)Constant.TRUE, Map.of(), values -> {
            throw new AssertionError((Object)"should not be called");
        }, Set.of(A_BIGINT)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(A_BIGINT, Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))));
    }

    @Test
    public void testExtractTimestampTzMillisDateComparison() {
        String timestampTzColumnSymbol = "timestamp_tz_symbol";
        TimestampWithTimeZoneType columnType = TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS;
        TestingColumnHandle columnHandle = new TestingColumnHandle(timestampTzColumnSymbol);
        Call castOfColumn = new Call((Type)DateType.DATE, StandardFunctions.CAST_FUNCTION_NAME, (List)ImmutableList.of((Object)new Variable(timestampTzColumnSymbol, (Type)columnType)));
        LocalDate someDate = LocalDate.of(2005, 9, 10);
        Constant someDateExpression = new Constant((Object)someDate.toEpochDay(), (Type)DateType.DATE);
        long startOfDateUtcEpochMillis = someDate.atStartOfDay().toEpochSecond(ZoneOffset.UTC) * 1000L;
        long startOfDateUtc = TestUtcConstraintExtractor.timestampTzMillisFromEpochMillis(startOfDateUtcEpochMillis);
        long startOfNextDateUtc = TestUtcConstraintExtractor.timestampTzMillisFromEpochMillis(startOfDateUtcEpochMillis + 86400000L);
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)castOfColumn, (Object)someDateExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.range((Type)columnType, (Object)startOfDateUtc, (boolean)true, (Object)startOfNextDateUtc, (boolean)false), new Range[0]))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.NOT_EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)castOfColumn, (Object)someDateExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.lessThan((Type)columnType, (Object)startOfDateUtc), Range.greaterThanOrEqual((Type)columnType, (Object)startOfNextDateUtc)))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.LESS_THAN_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)castOfColumn, (Object)someDateExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.lessThan((Type)columnType, (Object)startOfDateUtc), new Range[0]))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.LESS_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)castOfColumn, (Object)someDateExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.lessThan((Type)columnType, (Object)startOfNextDateUtc), new Range[0]))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.GREATER_THAN_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)castOfColumn, (Object)someDateExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.greaterThanOrEqual((Type)columnType, (Object)startOfNextDateUtc), new Range[0]))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.GREATER_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)castOfColumn, (Object)someDateExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.greaterThanOrEqual((Type)columnType, (Object)startOfDateUtc), new Range[0]))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.IDENTICAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)castOfColumn, (Object)someDateExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)columnType, (Object)startOfDateUtc, (boolean)true, (Object)startOfNextDateUtc, (boolean)false), (Range[])new Range[0]), (boolean)true))));
    }

    @Test
    public void testExtractTimestampTzMicrosDateComparison() {
        String timestampTzColumnSymbol = "timestamp_tz_symbol";
        TimestampWithTimeZoneType columnType = TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS;
        TestingColumnHandle columnHandle = new TestingColumnHandle(timestampTzColumnSymbol);
        Call castOfColumn = new Call((Type)DateType.DATE, StandardFunctions.CAST_FUNCTION_NAME, (List)ImmutableList.of((Object)new Variable(timestampTzColumnSymbol, (Type)columnType)));
        LocalDate someDate = LocalDate.of(2005, 9, 10);
        Constant someDateExpression = new Constant((Object)someDate.toEpochDay(), (Type)DateType.DATE);
        long startOfDateUtcEpochMillis = someDate.atStartOfDay().toEpochSecond(ZoneOffset.UTC) * 1000L;
        LongTimestampWithTimeZone startOfDateUtc = TestUtcConstraintExtractor.timestampTzMicrosFromEpochMillis(startOfDateUtcEpochMillis);
        LongTimestampWithTimeZone startOfNextDateUtc = TestUtcConstraintExtractor.timestampTzMicrosFromEpochMillis(startOfDateUtcEpochMillis + 86400000L);
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)castOfColumn, (Object)someDateExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.range((Type)columnType, (Object)startOfDateUtc, (boolean)true, (Object)startOfNextDateUtc, (boolean)false), new Range[0]))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.NOT_EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)castOfColumn, (Object)someDateExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.lessThan((Type)columnType, (Object)startOfDateUtc), Range.greaterThanOrEqual((Type)columnType, (Object)startOfNextDateUtc)))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.LESS_THAN_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)castOfColumn, (Object)someDateExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.lessThan((Type)columnType, (Object)startOfDateUtc), new Range[0]))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.LESS_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)castOfColumn, (Object)someDateExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.lessThan((Type)columnType, (Object)startOfNextDateUtc), new Range[0]))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.GREATER_THAN_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)castOfColumn, (Object)someDateExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.greaterThanOrEqual((Type)columnType, (Object)startOfNextDateUtc), new Range[0]))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.GREATER_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)castOfColumn, (Object)someDateExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.greaterThanOrEqual((Type)columnType, (Object)startOfDateUtc), new Range[0]))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.IDENTICAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)castOfColumn, (Object)someDateExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)columnType, (Object)startOfDateUtc, (boolean)true, (Object)startOfNextDateUtc, (boolean)false), (Range[])new Range[0]), (boolean)true))));
    }

    @Test
    public void testExtractDateTruncTimestampTzMillisComparison() {
        String timestampTzColumnSymbol = "timestamp_tz_symbol";
        TimestampWithTimeZoneType columnType = TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS;
        TestingColumnHandle columnHandle = new TestingColumnHandle(timestampTzColumnSymbol);
        Call truncateToDay = new Call((Type)columnType, new FunctionName("date_trunc"), (List)ImmutableList.of((Object)new Constant((Object)Slices.utf8Slice((String)"day"), (Type)VarcharType.createVarcharType((int)17)), (Object)new Variable(timestampTzColumnSymbol, (Type)columnType)));
        LocalDate someDate = LocalDate.of(2005, 9, 10);
        Constant someMidnightExpression = new Constant((Object)TestUtcConstraintExtractor.timestampTzMillisFromEpochMillis(someDate.toEpochDay() * 86400000L), (Type)columnType);
        Constant someMiddayExpression = new Constant((Object)TestUtcConstraintExtractor.timestampTzMillisFromEpochMillis(someDate.toEpochDay() * 86400000L + 43200000L), (Type)columnType);
        long startOfDateUtcEpochMillis = someDate.atStartOfDay().toEpochSecond(ZoneOffset.UTC) * 1000L;
        long startOfDateUtc = TestUtcConstraintExtractor.timestampTzMillisFromEpochMillis(startOfDateUtcEpochMillis);
        long startOfNextDateUtc = TestUtcConstraintExtractor.timestampTzMillisFromEpochMillis(startOfDateUtcEpochMillis + 86400000L);
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)truncateToDay, (Object)someMidnightExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.range((Type)columnType, (Object)startOfDateUtc, (boolean)true, (Object)startOfNextDateUtc, (boolean)false), new Range[0]))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)truncateToDay, (Object)someMiddayExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.none());
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.NOT_EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)truncateToDay, (Object)someMidnightExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.lessThan((Type)columnType, (Object)startOfDateUtc), Range.greaterThanOrEqual((Type)columnType, (Object)startOfNextDateUtc)))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.LESS_THAN_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)truncateToDay, (Object)someMidnightExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.lessThan((Type)columnType, (Object)startOfDateUtc), new Range[0]))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.LESS_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)truncateToDay, (Object)someMidnightExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.lessThan((Type)columnType, (Object)startOfNextDateUtc), new Range[0]))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.GREATER_THAN_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)truncateToDay, (Object)someMidnightExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.greaterThanOrEqual((Type)columnType, (Object)startOfNextDateUtc), new Range[0]))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.GREATER_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)truncateToDay, (Object)someMidnightExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.greaterThanOrEqual((Type)columnType, (Object)startOfDateUtc), new Range[0]))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.IDENTICAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)truncateToDay, (Object)someMidnightExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)columnType, (Object)startOfDateUtc, (boolean)true, (Object)startOfNextDateUtc, (boolean)false), (Range[])new Range[0]), (boolean)true))));
    }

    @Test
    public void testExtractDateTruncTimestampTzMicrosComparison() {
        String timestampTzColumnSymbol = "timestamp_tz_symbol";
        TimestampWithTimeZoneType columnType = TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS;
        TestingColumnHandle columnHandle = new TestingColumnHandle(timestampTzColumnSymbol);
        Call truncateToDay = new Call((Type)columnType, new FunctionName("date_trunc"), (List)ImmutableList.of((Object)new Constant((Object)Slices.utf8Slice((String)"day"), (Type)VarcharType.createVarcharType((int)17)), (Object)new Variable(timestampTzColumnSymbol, (Type)columnType)));
        LocalDate someDate = LocalDate.of(2005, 9, 10);
        Constant someMidnightExpression = new Constant((Object)LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)(someDate.toEpochDay() * 86400000L), (int)0, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)columnType);
        Constant someMiddayExpression = new Constant((Object)LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)(someDate.toEpochDay() * 86400000L), (int)1000000, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)columnType);
        long startOfDateUtcEpochMillis = someDate.atStartOfDay().toEpochSecond(ZoneOffset.UTC) * 1000L;
        LongTimestampWithTimeZone startOfDateUtc = TestUtcConstraintExtractor.timestampTzMicrosFromEpochMillis(startOfDateUtcEpochMillis);
        LongTimestampWithTimeZone startOfNextDateUtc = TestUtcConstraintExtractor.timestampTzMicrosFromEpochMillis(startOfDateUtcEpochMillis + 86400000L);
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)truncateToDay, (Object)someMidnightExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.range((Type)columnType, (Object)startOfDateUtc, (boolean)true, (Object)startOfNextDateUtc, (boolean)false), new Range[0]))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)truncateToDay, (Object)someMiddayExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.none());
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.NOT_EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)truncateToDay, (Object)someMidnightExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.lessThan((Type)columnType, (Object)startOfDateUtc), Range.greaterThanOrEqual((Type)columnType, (Object)startOfNextDateUtc)))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.LESS_THAN_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)truncateToDay, (Object)someMidnightExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.lessThan((Type)columnType, (Object)startOfDateUtc), new Range[0]))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.LESS_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)truncateToDay, (Object)someMidnightExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.lessThan((Type)columnType, (Object)startOfNextDateUtc), new Range[0]))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.GREATER_THAN_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)truncateToDay, (Object)someMidnightExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.greaterThanOrEqual((Type)columnType, (Object)startOfNextDateUtc), new Range[0]))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.GREATER_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)truncateToDay, (Object)someMidnightExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.greaterThanOrEqual((Type)columnType, (Object)startOfDateUtc), new Range[0]))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.IDENTICAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)truncateToDay, (Object)someMidnightExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)columnType, (Object)startOfDateUtc, (boolean)true, (Object)startOfNextDateUtc, (boolean)false), (Range[])new Range[0]), (boolean)true))));
    }

    @Test
    public void testExtractYearTimestampTzMicrosComparison() {
        String timestampTzColumnSymbol = "timestamp_tz_symbol";
        TimestampWithTimeZoneType columnType = TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS;
        TestingColumnHandle columnHandle = new TestingColumnHandle(timestampTzColumnSymbol);
        Call extractYear = new Call((Type)BigintType.BIGINT, new FunctionName("year"), (List)ImmutableList.of((Object)new Variable(timestampTzColumnSymbol, (Type)columnType)));
        LocalDate someDate = LocalDate.of(2005, 9, 10);
        Constant yearExpression = new Constant((Object)2005L, (Type)BigintType.BIGINT);
        long startOfYearUtcEpochMillis = someDate.withDayOfYear(1).atStartOfDay().toEpochSecond(ZoneOffset.UTC) * 1000L;
        LongTimestampWithTimeZone startOfYearUtc = TestUtcConstraintExtractor.timestampTzMicrosFromEpochMillis(startOfYearUtcEpochMillis);
        LongTimestampWithTimeZone startOfNextDateUtc = TestUtcConstraintExtractor.timestampTzMicrosFromEpochMillis(someDate.plusYears(1L).withDayOfYear(1).atStartOfDay().toEpochSecond(ZoneOffset.UTC) * 1000L);
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)extractYear, (Object)yearExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.range((Type)columnType, (Object)startOfYearUtc, (boolean)true, (Object)startOfNextDateUtc, (boolean)false), new Range[0]))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.NOT_EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)extractYear, (Object)yearExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.lessThan((Type)columnType, (Object)startOfYearUtc), Range.greaterThanOrEqual((Type)columnType, (Object)startOfNextDateUtc)))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.LESS_THAN_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)extractYear, (Object)yearExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.lessThan((Type)columnType, (Object)startOfYearUtc), new Range[0]))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.LESS_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)extractYear, (Object)yearExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.lessThan((Type)columnType, (Object)startOfNextDateUtc), new Range[0]))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.GREATER_THAN_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)extractYear, (Object)yearExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.greaterThanOrEqual((Type)columnType, (Object)startOfNextDateUtc), new Range[0]))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.GREATER_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)extractYear, (Object)yearExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.greaterThanOrEqual((Type)columnType, (Object)startOfYearUtc), new Range[0]))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.IDENTICAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)extractYear, (Object)yearExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)columnType, (Object)startOfYearUtc, (boolean)true, (Object)startOfNextDateUtc, (boolean)false), (Range[])new Range[0]), (boolean)true))));
    }

    @Test
    public void testExtractYearTimestampTzMillisComparison() {
        String timestampTzColumnSymbol = "timestamp_tz_symbol";
        TimestampWithTimeZoneType columnType = TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS;
        TestingColumnHandle columnHandle = new TestingColumnHandle(timestampTzColumnSymbol);
        Call extractYear = new Call((Type)BigintType.BIGINT, new FunctionName("year"), (List)ImmutableList.of((Object)new Variable(timestampTzColumnSymbol, (Type)columnType)));
        LocalDate someDate = LocalDate.of(2005, 9, 10);
        Constant yearExpression = new Constant((Object)2005L, (Type)BigintType.BIGINT);
        long startOfYearUtcEpochMillis = someDate.withDayOfYear(1).atStartOfDay().toEpochSecond(ZoneOffset.UTC) * 1000L;
        long startOfYearUtc = TestUtcConstraintExtractor.timestampTzMillisFromEpochMillis(startOfYearUtcEpochMillis);
        long startOfNextDateUtc = TestUtcConstraintExtractor.timestampTzMillisFromEpochMillis(someDate.plusYears(1L).withDayOfYear(1).atStartOfDay().toEpochSecond(ZoneOffset.UTC) * 1000L);
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)extractYear, (Object)yearExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.range((Type)columnType, (Object)startOfYearUtc, (boolean)true, (Object)startOfNextDateUtc, (boolean)false), new Range[0]))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.NOT_EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)extractYear, (Object)yearExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.lessThan((Type)columnType, (Object)startOfYearUtc), Range.greaterThanOrEqual((Type)columnType, (Object)startOfNextDateUtc)))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.LESS_THAN_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)extractYear, (Object)yearExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.lessThan((Type)columnType, (Object)startOfYearUtc), new Range[0]))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.LESS_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)extractYear, (Object)yearExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.lessThan((Type)columnType, (Object)startOfNextDateUtc), new Range[0]))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.GREATER_THAN_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)extractYear, (Object)yearExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.greaterThanOrEqual((Type)columnType, (Object)startOfNextDateUtc), new Range[0]))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.GREATER_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)extractYear, (Object)yearExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.greaterThanOrEqual((Type)columnType, (Object)startOfYearUtc), new Range[0]))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.IDENTICAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)extractYear, (Object)yearExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)columnType, (Object)startOfYearUtc, (boolean)true, (Object)startOfNextDateUtc, (boolean)false), (Range[])new Range[0]), (boolean)true))));
    }

    @Test
    public void testIntersectSummaryAndExpressionExtraction() {
        String timestampTzColumnSymbol = "timestamp_tz_symbol";
        TimestampWithTimeZoneType columnType = TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS;
        TestingColumnHandle columnHandle = new TestingColumnHandle(timestampTzColumnSymbol);
        Call castOfColumn = new Call((Type)DateType.DATE, StandardFunctions.CAST_FUNCTION_NAME, (List)ImmutableList.of((Object)new Variable(timestampTzColumnSymbol, (Type)columnType)));
        LocalDate someDate = LocalDate.of(2005, 9, 10);
        Constant someDateExpression = new Constant((Object)someDate.toEpochDay(), (Type)DateType.DATE);
        long startOfDateUtcEpochMillis = someDate.atStartOfDay().toEpochSecond(ZoneOffset.UTC) * 1000L;
        LongTimestampWithTimeZone startOfDateUtc = TestUtcConstraintExtractor.timestampTzMicrosFromEpochMillis(startOfDateUtcEpochMillis);
        LongTimestampWithTimeZone startOfNextDateUtc = TestUtcConstraintExtractor.timestampTzMicrosFromEpochMillis(startOfDateUtcEpochMillis + 86400000L);
        LongTimestampWithTimeZone startOfNextNextDateUtc = TestUtcConstraintExtractor.timestampTzMicrosFromEpochMillis(startOfDateUtcEpochMillis + 172800000L);
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.lessThan((Type)columnType, (Object)startOfNextNextDateUtc), new Range[0]))), (ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.NOT_EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)castOfColumn, (Object)someDateExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.lessThan((Type)columnType, (Object)startOfDateUtc), Range.range((Type)columnType, (Object)startOfNextDateUtc, (boolean)true, (Object)startOfNextNextDateUtc, (boolean)false)))));
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains(Map.of(columnHandle, TestUtcConstraintExtractor.domain(Range.lessThan((Type)columnType, (Object)startOfNextDateUtc), new Range[0]))), (ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.GREATER_THAN_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)castOfColumn, (Object)someDateExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.none());
        Assertions.assertThat(TestUtcConstraintExtractor.extract(TestUtcConstraintExtractor.constraint((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains(Map.of(A_BIGINT, Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))), (ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.GREATER_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)castOfColumn, (Object)someDateExpression)), Map.of(timestampTzColumnSymbol, columnHandle)))).isEqualTo((Object)TupleDomain.withColumnDomains(Map.of(A_BIGINT, Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), columnHandle, TestUtcConstraintExtractor.domain(Range.greaterThanOrEqual((Type)columnType, (Object)startOfDateUtc), new Range[0]))));
    }

    private static TupleDomain<ColumnHandle> extract(Constraint constraint) {
        UtcConstraintExtractor.ExtractionResult result = UtcConstraintExtractor.extractTupleDomain((Constraint)constraint);
        Assertions.assertThat((Object)result.remainingExpression()).isEqualTo((Object)Constant.TRUE);
        return result.tupleDomain();
    }

    private static Constraint constraint(ConnectorExpression expression, Map<String, ColumnHandle> assignments) {
        return TestUtcConstraintExtractor.constraint((TupleDomain<ColumnHandle>)TupleDomain.all(), expression, assignments);
    }

    private static Constraint constraint(TupleDomain<ColumnHandle> summary, ConnectorExpression expression, Map<String, ColumnHandle> assignments) {
        return new Constraint(summary, expression, assignments);
    }

    private static long timestampTzMillisFromEpochMillis(long epochMillis) {
        return DateTimeEncoding.packDateTimeWithZone((long)epochMillis, (TimeZoneKey)TimeZoneKey.UTC_KEY);
    }

    private static LongTimestampWithTimeZone timestampTzMicrosFromEpochMillis(long epochMillis) {
        return LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)epochMillis, (int)0, (TimeZoneKey)TimeZoneKey.UTC_KEY);
    }

    private static Domain domain(Range first, Range ... rest) {
        return Domain.create((ValueSet)ValueSet.ofRanges((Range)first, (Range[])rest), (boolean)false);
    }
}

