/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.ldap;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.testing.ValidationAssertions;
import io.airlift.units.Duration;
import io.trino.plugin.base.ldap.LdapClientConfig;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;

public class TestLdapConfig {
    @Test
    public void testDefault() {
        ConfigAssertions.assertRecordedDefaults((Object)((LdapClientConfig)ConfigAssertions.recordDefaults(LdapClientConfig.class)).setLdapUrl(null).setAllowInsecure(false).setKeystorePath(null).setKeystorePassword(null).setTrustStorePath(null).setTruststorePassword(null).setIgnoreReferrals(false).setLdapConnectionTimeout(null).setLdapReadTimeout(null));
    }

    @Test
    public void testExplicitConfig() throws IOException {
        Path trustStoreFile = Files.createTempFile(null, null, new FileAttribute[0]);
        Path keyStoreFile = Files.createTempFile(null, null, new FileAttribute[0]);
        ImmutableMap properties = ImmutableMap.builder().put((Object)"ldap.url", (Object)"ldaps://localhost:636").put((Object)"ldap.allow-insecure", (Object)"true").put((Object)"ldap.ssl.keystore.path", (Object)keyStoreFile.toString()).put((Object)"ldap.ssl.keystore.password", (Object)"12345").put((Object)"ldap.ssl.truststore.path", (Object)trustStoreFile.toString()).put((Object)"ldap.ssl.truststore.password", (Object)"54321").put((Object)"ldap.ignore-referrals", (Object)"true").put((Object)"ldap.timeout.connect", (Object)"3m").put((Object)"ldap.timeout.read", (Object)"4m").buildOrThrow();
        LdapClientConfig expected = new LdapClientConfig().setLdapUrl("ldaps://localhost:636").setAllowInsecure(true).setKeystorePath(keyStoreFile.toFile()).setKeystorePassword("12345").setTrustStorePath(trustStoreFile.toFile()).setTruststorePassword("54321").setIgnoreReferrals(true).setLdapConnectionTimeout(new Duration(3.0, TimeUnit.MINUTES)).setLdapReadTimeout(new Duration(4.0, TimeUnit.MINUTES));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test
    public void testValidation() {
        ValidationAssertions.assertValidates((Object)new LdapClientConfig().setLdapUrl("ldaps://localhost"));
        ValidationAssertions.assertValidates((Object)new LdapClientConfig().setLdapUrl("ldap://localhost").setAllowInsecure(true));
        ValidationAssertions.assertFailsValidation((Object)new LdapClientConfig().setLdapUrl("ldap://").setAllowInsecure(false), (String)"urlConfigurationValid", (String)"Connecting to the LDAP server without SSL enabled requires `ldap.allow-insecure=true`", AssertTrue.class);
        ValidationAssertions.assertFailsValidation((Object)new LdapClientConfig().setLdapUrl("localhost"), (String)"ldapUrl", (String)"Invalid LDAP server URL. Expected ldap:// or ldaps://", Pattern.class);
        ValidationAssertions.assertFailsValidation((Object)new LdapClientConfig().setLdapUrl("ldaps:/localhost"), (String)"ldapUrl", (String)"Invalid LDAP server URL. Expected ldap:// or ldaps://", Pattern.class);
        ValidationAssertions.assertFailsValidation((Object)new LdapClientConfig(), (String)"ldapUrl", (String)"must not be null", NotNull.class);
    }
}

