/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.projection;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.base.projection.ApplyProjectionUtil;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Constant;
import io.trino.spi.expression.FieldDereference;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestApplyProjectionUtil {
    private static final ConnectorExpression ROW_OF_ROW_VARIABLE = new Variable("a", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"b", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"c", (Type)IntegerType.INTEGER)}))}));
    private static final ConnectorExpression LEAF_DOTTED_ROW_OF_ROW_VARIABLE = new Variable("a", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"b", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"c.x", (Type)IntegerType.INTEGER)}))}));
    private static final ConnectorExpression MID_DOTTED_ROW_OF_ROW_VARIABLE = new Variable("a", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"b.x", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"c", (Type)IntegerType.INTEGER)}))}));
    private static final ConnectorExpression ONE_LEVEL_DEREFERENCE = new FieldDereference((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"c", (Type)IntegerType.INTEGER)}), ROW_OF_ROW_VARIABLE, 0);
    private static final ConnectorExpression TWO_LEVEL_DEREFERENCE = new FieldDereference((Type)IntegerType.INTEGER, ONE_LEVEL_DEREFERENCE, 0);
    private static final ConnectorExpression LEAF_DOTTED_ONE_LEVEL_DEREFERENCE = new FieldDereference((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"c.x", (Type)IntegerType.INTEGER)}), LEAF_DOTTED_ROW_OF_ROW_VARIABLE, 0);
    private static final ConnectorExpression LEAF_DOTTED_TWO_LEVEL_DEREFERENCE = new FieldDereference((Type)IntegerType.INTEGER, LEAF_DOTTED_ONE_LEVEL_DEREFERENCE, 0);
    private static final ConnectorExpression MID_DOTTED_ONE_LEVEL_DEREFERENCE = new FieldDereference((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"c.x", (Type)IntegerType.INTEGER)}), MID_DOTTED_ROW_OF_ROW_VARIABLE, 0);
    private static final ConnectorExpression MID_DOTTED_TWO_LEVEL_DEREFERENCE = new FieldDereference((Type)IntegerType.INTEGER, MID_DOTTED_ONE_LEVEL_DEREFERENCE, 0);
    private static final ConnectorExpression INT_VARIABLE = new Variable("a", (Type)IntegerType.INTEGER);
    private static final ConnectorExpression CONSTANT = new Constant((Object)5, (Type)IntegerType.INTEGER);

    @Test
    public void testIsProjectionSupported() {
        Assertions.assertThat((boolean)ApplyProjectionUtil.isPushdownSupported((ConnectorExpression)ONE_LEVEL_DEREFERENCE, connectorExpression -> true)).isTrue();
        Assertions.assertThat((boolean)ApplyProjectionUtil.isPushdownSupported((ConnectorExpression)TWO_LEVEL_DEREFERENCE, connectorExpression -> true)).isTrue();
        Assertions.assertThat((boolean)ApplyProjectionUtil.isPushdownSupported((ConnectorExpression)INT_VARIABLE, connectorExpression -> true)).isTrue();
        Assertions.assertThat((boolean)ApplyProjectionUtil.isPushdownSupported((ConnectorExpression)CONSTANT, connectorExpression -> true)).isFalse();
        Assertions.assertThat((boolean)ApplyProjectionUtil.isPushdownSupported((ConnectorExpression)ONE_LEVEL_DEREFERENCE, connectorExpression -> false)).isFalse();
        Assertions.assertThat((boolean)ApplyProjectionUtil.isPushdownSupported((ConnectorExpression)TWO_LEVEL_DEREFERENCE, connectorExpression -> false)).isFalse();
        Assertions.assertThat((boolean)ApplyProjectionUtil.isPushdownSupported((ConnectorExpression)INT_VARIABLE, connectorExpression -> false)).isFalse();
        Assertions.assertThat((boolean)ApplyProjectionUtil.isPushdownSupported((ConnectorExpression)CONSTANT, connectorExpression -> false)).isFalse();
        Assertions.assertThat((boolean)ApplyProjectionUtil.isPushdownSupported((ConnectorExpression)LEAF_DOTTED_ONE_LEVEL_DEREFERENCE, this::isSupportedForPushDown)).isTrue();
        Assertions.assertThat((boolean)ApplyProjectionUtil.isPushdownSupported((ConnectorExpression)LEAF_DOTTED_TWO_LEVEL_DEREFERENCE, this::isSupportedForPushDown)).isFalse();
        Assertions.assertThat((boolean)ApplyProjectionUtil.isPushdownSupported((ConnectorExpression)MID_DOTTED_ONE_LEVEL_DEREFERENCE, this::isSupportedForPushDown)).isFalse();
        Assertions.assertThat((boolean)ApplyProjectionUtil.isPushdownSupported((ConnectorExpression)MID_DOTTED_TWO_LEVEL_DEREFERENCE, this::isSupportedForPushDown)).isFalse();
    }

    @Test
    public void testExtractSupportedProjectionColumns() {
        Assertions.assertThat((List)ApplyProjectionUtil.extractSupportedProjectedColumns((ConnectorExpression)ONE_LEVEL_DEREFERENCE)).isEqualTo((Object)ImmutableList.of((Object)ONE_LEVEL_DEREFERENCE));
        Assertions.assertThat((List)ApplyProjectionUtil.extractSupportedProjectedColumns((ConnectorExpression)TWO_LEVEL_DEREFERENCE)).isEqualTo((Object)ImmutableList.of((Object)TWO_LEVEL_DEREFERENCE));
        Assertions.assertThat((List)ApplyProjectionUtil.extractSupportedProjectedColumns((ConnectorExpression)INT_VARIABLE)).isEqualTo((Object)ImmutableList.of((Object)INT_VARIABLE));
        Assertions.assertThat((List)ApplyProjectionUtil.extractSupportedProjectedColumns((ConnectorExpression)CONSTANT)).isEqualTo((Object)ImmutableList.of());
        Assertions.assertThat((List)ApplyProjectionUtil.extractSupportedProjectedColumns((ConnectorExpression)ONE_LEVEL_DEREFERENCE, connectorExpression -> false)).isEqualTo((Object)ImmutableList.of());
        Assertions.assertThat((List)ApplyProjectionUtil.extractSupportedProjectedColumns((ConnectorExpression)TWO_LEVEL_DEREFERENCE, connectorExpression -> false)).isEqualTo((Object)ImmutableList.of());
        Assertions.assertThat((List)ApplyProjectionUtil.extractSupportedProjectedColumns((ConnectorExpression)INT_VARIABLE, connectorExpression -> false)).isEqualTo((Object)ImmutableList.of());
        Assertions.assertThat((List)ApplyProjectionUtil.extractSupportedProjectedColumns((ConnectorExpression)CONSTANT, connectorExpression -> false)).isEqualTo((Object)ImmutableList.of());
        Assertions.assertThat((List)ApplyProjectionUtil.extractSupportedProjectedColumns((ConnectorExpression)LEAF_DOTTED_ONE_LEVEL_DEREFERENCE, this::isSupportedForPushDown)).isEqualTo((Object)ImmutableList.of((Object)LEAF_DOTTED_ONE_LEVEL_DEREFERENCE));
        Assertions.assertThat((List)ApplyProjectionUtil.extractSupportedProjectedColumns((ConnectorExpression)LEAF_DOTTED_TWO_LEVEL_DEREFERENCE, this::isSupportedForPushDown)).isEqualTo((Object)ImmutableList.of((Object)LEAF_DOTTED_ONE_LEVEL_DEREFERENCE));
        Assertions.assertThat((List)ApplyProjectionUtil.extractSupportedProjectedColumns((ConnectorExpression)MID_DOTTED_ONE_LEVEL_DEREFERENCE, this::isSupportedForPushDown)).isEqualTo((Object)ImmutableList.of((Object)MID_DOTTED_ROW_OF_ROW_VARIABLE));
        Assertions.assertThat((List)ApplyProjectionUtil.extractSupportedProjectedColumns((ConnectorExpression)MID_DOTTED_TWO_LEVEL_DEREFERENCE, this::isSupportedForPushDown)).isEqualTo((Object)ImmutableList.of((Object)MID_DOTTED_ROW_OF_ROW_VARIABLE));
    }

    private boolean isSupportedForPushDown(ConnectorExpression connectorExpression) {
        FieldDereference fieldDereference;
        RowType rowType;
        RowType.Field field;
        String fieldName;
        return !(connectorExpression instanceof FieldDereference) || !(fieldName = (String)(field = (RowType.Field)(rowType = (RowType)(fieldDereference = (FieldDereference)connectorExpression).getTarget().getType()).getFields().get(fieldDereference.getField())).getName().get()).contains(".") && !fieldName.contains("$");
    }
}

