/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import com.google.common.collect.ImmutableMap;
import io.airlift.testing.Closeables;
import io.trino.plugin.base.security.BaseFileBasedConnectorAccessControlTest;
import io.trino.plugin.base.util.TestingHttpServer;
import io.trino.spi.connector.ConnectorAccessControl;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestHttpFileBasedAccessControl
extends BaseFileBasedConnectorAccessControlTest {
    private final TestingHttpServer testingHttpServer = new TestingHttpServer();

    @AfterAll
    public void tearDown() throws IOException {
        Closeables.closeAll((Closeable[])new Closeable[]{this.testingHttpServer});
    }

    @Override
    protected ConnectorAccessControl createAccessControl(File configFile, Map<String, String> properties) {
        try {
            String dataUrl = this.testingHttpServer.resource(configFile.getCanonicalFile().getAbsolutePath()).toString();
            return this.createAccessControl((Map<String, String>)ImmutableMap.builder().putAll(properties).put((Object)"security.config-file", (Object)dataUrl).buildOrThrow());
        }
        catch (IOException e) {
            throw new RuntimeException("Error while creating SystemAccessControl", e);
        }
    }
}

